/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.filters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.filters.DefaultFilter;

public class NamespaceBinder
extends DefaultFilter {
    public static final String XHTML_1_0_URI = "http://www.w3.org/1999/xhtml";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String OVERRIDE_NAMESPACES = "http://cyberneko.org/html/features/override-namespaces";
    protected static final String INSERT_NAMESPACES = "http://cyberneko.org/html/features/insert-namespaces";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://cyberneko.org/html/features/override-namespaces", "http://cyberneko.org/html/features/insert-namespaces"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, Boolean.FALSE, Boolean.FALSE};
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String NAMESPACES_URI = "http://cyberneko.org/html/properties/namespaces-uri";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/names/attrs", "http://cyberneko.org/html/properties/namespaces-uri"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, "http://www.w3.org/1999/xhtml"};
    protected static final short NAMES_NO_CHANGE = 0;
    protected static final short NAMES_UPPERCASE = 1;
    protected static final short NAMES_LOWERCASE = 2;
    protected boolean fNamespaces;
    protected boolean fNamespacePrefixes;
    protected boolean fOverrideNamespaces;
    protected boolean fInsertNamespaces;
    protected short fNamesElems;
    protected short fNamesAttrs;
    protected String fNamespacesURI;
    protected final NamespaceSupport fNamespaceContext = new NamespaceSupport();
    private static final QName fQName = new QName();
    static /* synthetic */ Class class$java$lang$String;

    public String[] getRecognizedFeatures() {
        return DefaultFilter.merge(super.getRecognizedFeatures(), RECOGNIZED_FEATURES);
    }

    public Boolean getFeatureDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n].equals(string)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return super.getFeatureDefault(string);
    }

    public String[] getRecognizedProperties() {
        return DefaultFilter.merge(super.getRecognizedProperties(), RECOGNIZED_PROPERTIES);
    }

    public Object getPropertyDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n].equals(string)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return super.getPropertyDefault(string);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        super.reset(xMLComponentManager);
        this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        this.fOverrideNamespaces = xMLComponentManager.getFeature(OVERRIDE_NAMESPACES);
        this.fInsertNamespaces = xMLComponentManager.getFeature(INSERT_NAMESPACES);
        this.fNamesElems = NamespaceBinder.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ELEMS)));
        this.fNamesAttrs = NamespaceBinder.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ATTRS)));
        this.fNamespacesURI = String.valueOf(xMLComponentManager.getProperty(NAMESPACES_URI));
        this.fNamespaceContext.reset();
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        super.startDocument(xMLLocator, string, this.fNamespaceContext, augmentations);
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.fNamespaceContext.pushContext();
            this.bindNamespaces(qName, xMLAttributes);
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n > 0) {
                try {
                    Class<?> clazz = this.fDocumentHandler.getClass();
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    Method method = clazz.getMethod("startPrefixMapping", classArray);
                    int n2 = 0;
                    while (n2 < n) {
                        String string = this.fNamespaceContext.getDeclaredPrefixAt(n2);
                        String string2 = this.fNamespaceContext.getURI(string);
                        Object[] objectArray = new Object[]{string, string2};
                        method.invoke((Object)this.fDocumentHandler, objectArray);
                        ++n2;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        super.startElement(qName, xMLAttributes, augmentations);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Object[] objectArray;
        String string;
        int n;
        Method method;
        Class[] classArray;
        Class<?> clazz;
        int n2;
        if (this.fNamespaces) {
            this.fNamespaceContext.pushContext();
            this.bindNamespaces(qName, xMLAttributes);
            n2 = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n2 > 0) {
                try {
                    clazz = this.fDocumentHandler.getClass();
                    classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    method = clazz.getMethod("startPrefixMapping", classArray);
                    n = 0;
                    while (n < n2) {
                        string = this.fNamespaceContext.getDeclaredPrefixAt(n);
                        objectArray = this.fNamespaceContext.getURI(string);
                        Object[] objectArray2 = new Object[]{string, objectArray};
                        method.invoke((Object)this.fDocumentHandler, objectArray2);
                        ++n;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        super.emptyElement(qName, xMLAttributes, augmentations);
        if (this.fNamespaces) {
            n2 = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n2 > 0) {
                try {
                    clazz = this.fDocumentHandler.getClass();
                    classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    method = clazz.getMethod("endPrefixMapping", classArray);
                    n = n2 - 1;
                    while (n >= 0) {
                        string = this.fNamespaceContext.getDeclaredPrefixAt(n);
                        objectArray = new Object[]{string};
                        method.invoke((Object)this.fDocumentHandler, objectArray);
                        --n;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.fNamespaceContext.popContext();
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.bindNamespaces(qName, null);
        }
        super.endElement(qName, augmentations);
        if (this.fNamespaces) {
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            if (this.fDocumentHandler != null && n > 0) {
                try {
                    Class<?> clazz = this.fDocumentHandler.getClass();
                    Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NamespaceBinder.class$("java.lang.String")) : class$java$lang$String};
                    Method method = clazz.getMethod("endPrefixMapping", classArray);
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        String string = this.fNamespaceContext.getDeclaredPrefixAt(n2);
                        Object[] objectArray = new Object[]{string};
                        method.invoke((Object)this.fDocumentHandler, objectArray);
                        --n2;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.fNamespaceContext.popContext();
        }
    }

    protected static void splitQName(QName qName) {
        int n = qName.rawname.indexOf(58);
        if (n != -1) {
            qName.prefix = qName.rawname.substring(0, n);
            qName.localpart = qName.rawname.substring(n + 1);
        }
    }

    protected static final short getNamesValue(String string) {
        if (string.equals("lower")) {
            return 2;
        }
        if (string.equals("upper")) {
            return 1;
        }
        return 0;
    }

    protected static final String modifyName(String string, short s) {
        switch (s) {
            case 1: {
                return string.toUpperCase();
            }
            case 2: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    protected void bindNamespaces(QName qName, XMLAttributes xMLAttributes) {
        String string;
        String string2;
        NamespaceBinder.splitQName(qName);
        int n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        int n2 = n - 1;
        while (n2 >= 0) {
            xMLAttributes.getName(n2, fQName);
            string2 = NamespaceBinder.fQName.rawname;
            string = string2.toUpperCase();
            if (string.startsWith("XMLNS:") || string.equals("XMLNS")) {
                String string3;
                int n3 = string2.length();
                String string4 = n3 > 5 ? string2.substring(0, 5) : null;
                String string5 = n3 > 5 ? string2.substring(6) : string2;
                String string6 = xMLAttributes.getValue(n2);
                if (n3 > 5) {
                    string4 = NamespaceBinder.modifyName(string4, (short)2);
                    string5 = NamespaceBinder.modifyName(string5, this.fNamesElems);
                    string2 = string4 + ':' + string5;
                } else {
                    string2 = string5 = NamespaceBinder.modifyName(string5, (short)2);
                }
                fQName.setValues(string4, string5, string2, null);
                xMLAttributes.setName(n2, fQName);
                String string7 = string5 != string2 ? string5 : "";
                String string8 = string3 = string6.length() > 0 ? string6 : null;
                if (this.fOverrideNamespaces && string7.equals(qName.prefix) && HTMLElements.getElement(qName.localpart, null) != null) {
                    string3 = this.fNamespacesURI;
                }
                this.fNamespaceContext.declarePrefix(string7, string3);
            }
            --n2;
        }
        string2 = qName.prefix != null ? qName.prefix : "";
        qName.uri = this.fNamespaceContext.getURI(string2);
        if (qName.uri != null && qName.prefix == null) {
            qName.prefix = "";
        }
        if (this.fInsertNamespaces && HTMLElements.getElement(qName.localpart, null) != null && (qName.prefix == null || this.fNamespaceContext.getURI(qName.prefix) == null)) {
            string = "xmlns" + (qName.prefix != null ? ":" + qName.prefix : "");
            fQName.setValues(null, string, string, null);
            xMLAttributes.addAttribute(fQName, "CDATA", this.fNamespacesURI);
            this.bindNamespaces(qName, xMLAttributes);
            return;
        }
        n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        int n4 = 0;
        while (n4 < n) {
            xMLAttributes.getName(n4, fQName);
            NamespaceBinder.splitQName(fQName);
            string2 = !NamespaceBinder.fQName.rawname.equals("xmlns") ? (NamespaceBinder.fQName.prefix != null ? NamespaceBinder.fQName.prefix : "") : "xmlns";
            NamespaceBinder.fQName.uri = this.fNamespaceContext.getURI(string2);
            xMLAttributes.setName(n4, fQName);
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class NamespaceSupport
    implements NamespaceContext {
        protected int fTop = 0;
        protected int[] fLevels = new int[10];
        protected Entry[] fEntries = new Entry[10];

        public NamespaceSupport() {
            this.pushContext();
            this.declarePrefix("xml", NamespaceContext.XML_URI);
            this.declarePrefix("xmlns", NamespaceContext.XMLNS_URI);
        }

        public String getURI(String string) {
            int n = this.fLevels[this.fTop] - 1;
            while (n >= 0) {
                Entry entry = this.fEntries[n];
                if (entry.prefix.equals(string)) {
                    return entry.uri;
                }
                --n;
            }
            return null;
        }

        public int getDeclaredPrefixCount() {
            return this.fLevels[this.fTop] - this.fLevels[this.fTop - 1];
        }

        public String getDeclaredPrefixAt(int n) {
            return this.fEntries[this.fLevels[this.fTop - 1] + n].prefix;
        }

        public NamespaceContext getParentContext() {
            return this;
        }

        public void reset() {
            this.fTop = 1;
            this.fLevels[1] = this.fLevels[this.fTop - 1];
        }

        public void pushContext() {
            if (++this.fTop == this.fLevels.length) {
                int[] nArray = new int[this.fLevels.length + 10];
                System.arraycopy(this.fLevels, 0, nArray, 0, this.fLevels.length);
                this.fLevels = nArray;
            }
            this.fLevels[this.fTop] = this.fLevels[this.fTop - 1];
        }

        public void popContext() {
            --this.fTop;
        }

        public boolean declarePrefix(String string, String string2) {
            Object object;
            int n = this.getDeclaredPrefixCount();
            int n2 = 0;
            while (n2 < n) {
                object = this.getDeclaredPrefixAt(n2);
                if (((String)object).equals(string)) {
                    return false;
                }
                ++n2;
            }
            object = new Entry(string, string2);
            if (this.fLevels[this.fTop] == this.fEntries.length) {
                Entry[] entryArray = new Entry[this.fEntries.length + 10];
                System.arraycopy(this.fEntries, 0, entryArray, 0, this.fEntries.length);
                this.fEntries = entryArray;
            }
            int n3 = this.fTop;
            int n4 = this.fLevels[n3];
            this.fLevels[n3] = n4 + 1;
            this.fEntries[n4] = object;
            return true;
        }

        public String getPrefix(String string) {
            int n = this.fLevels[this.fTop] - 1;
            while (n >= 0) {
                Entry entry = this.fEntries[n];
                if (entry.uri.equals(string)) {
                    return entry.prefix;
                }
                --n;
            }
            return null;
        }

        public Enumeration getAllPrefixes() {
            Vector<String> vector = new Vector<String>();
            int n = this.fLevels[1];
            while (n < this.fLevels[this.fTop]) {
                String string = this.fEntries[n].prefix;
                if (!vector.contains(string)) {
                    vector.addElement(string);
                }
                ++n;
            }
            return vector.elements();
        }

        static class Entry {
            public String prefix;
            public String uri;

            public Entry(String string, String string2) {
                this.prefix = string;
                this.uri = string2;
            }
        }
    }
}

