/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.apache.cactus.internal.CactusTestCase;
import org.apache.cactus.internal.ServiceEnumeration;
import org.apache.cactus.internal.WebTestResult;
import org.apache.cactus.internal.server.ServletUtil;
import org.apache.cactus.internal.server.WebImplicitObjects;
import org.apache.cactus.internal.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractWebTestCaller {
    protected static final String TEST_RESULTS = "ServletTestRedirector_TestResults";
    private static final Log LOGGER;
    protected WebImplicitObjects webImplicitObjects;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.internal.server.AbstractWebTestCaller");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = LogFactory.getLog((Class)clazz);
    }

    public AbstractWebTestCaller(WebImplicitObjects theObjects) {
        this.webImplicitObjects = theObjects;
    }

    protected abstract void setTestCaseFields(TestCase var1) throws Exception;

    protected abstract Writer getResponseWriter() throws IOException;

    public void doTest() throws ServletException {
        WebTestResult result = null;
        try {
            TestCase testInstance = this.getTestClassInstance(this.getTestClassName(), this.getWrappedTestClassName(), this.getTestMethodName());
            this.setTestCaseFields(testInstance);
            if (testInstance instanceof CactusTestCase) {
                ((CactusTestCase)testInstance).runBareServer();
            } else {
                testInstance.runBare();
            }
            result = new WebTestResult();
        }
        catch (Throwable e) {
            result = new WebTestResult(e);
        }
        LOGGER.debug((Object)("Test result : [" + result + "]"));
        this.webImplicitObjects.getServletContext().setAttribute(TEST_RESULTS, (Object)result);
        LOGGER.debug((Object)"Result saved in context scope");
    }

    public void doGetResults() throws ServletException {
        WebTestResult result = (WebTestResult)this.webImplicitObjects.getServletContext().getAttribute(TEST_RESULTS);
        if (result == null) {
            String message = "Error getting test result. This could happen for example if you're using a load-balancer. Please disable it before running Cactus tests.";
            LOGGER.error((Object)message);
            throw new ServletException(message);
        }
        LOGGER.debug((Object)("Test Result = [" + result + "]"));
        this.webImplicitObjects.getHttpServletResponse().setContentType("text/xml; charset=UTF-8");
        try {
            Writer writer = this.getResponseWriter();
            writer.write(result.toXml());
            writer.close();
        }
        catch (IOException e) {
            String message = "Error writing WebTestResult instance to output stream";
            LOGGER.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
    }

    public void doRunTest() throws ServletException {
    }

    public void doGetVersion() throws ServletException {
        try {
            Writer writer = this.getResponseWriter();
            writer.write("1.7.2");
            writer.close();
        }
        catch (IOException e) {
            String message = "Error writing HTTP response back to client for service [" + ServiceEnumeration.GET_VERSION_SERVICE + "]";
            LOGGER.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
    }

    public void doCreateSession() throws ServletException {
        this.webImplicitObjects.getHttpServletRequest().getSession(true);
        try {
            Writer writer = this.getResponseWriter();
            writer.close();
        }
        catch (IOException e) {
            String message = "Error writing HTTP response back to client for service [" + ServiceEnumeration.CREATE_SESSION_SERVICE + "]";
            LOGGER.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
    }

    protected String getTestClassName() throws ServletException {
        String queryString = this.webImplicitObjects.getHttpServletRequest().getQueryString();
        String className = ServletUtil.getQueryStringParameter(queryString, "Cactus_TestClass");
        if (className == null) {
            String message = "Missing class name parameter [Cactus_TestClass] in HTTP request.";
            LOGGER.error((Object)message);
            throw new ServletException(message);
        }
        LOGGER.debug((Object)("Class to call = [" + className + "]"));
        return className;
    }

    protected String getWrappedTestClassName() throws ServletException {
        String queryString = this.webImplicitObjects.getHttpServletRequest().getQueryString();
        String className = ServletUtil.getQueryStringParameter(queryString, "Cactus_WrappedTestClass");
        if (className == null) {
            LOGGER.debug((Object)"No wrapped test class");
        } else {
            LOGGER.debug((Object)("Wrapped test class = [" + className + "]"));
        }
        return className;
    }

    protected String getTestMethodName() throws ServletException {
        String queryString = this.webImplicitObjects.getHttpServletRequest().getQueryString();
        String methodName = ServletUtil.getQueryStringParameter(queryString, "Cactus_TestMethod");
        if (methodName == null) {
            String message = "Missing method name parameter [Cactus_TestMethod] in HTTP request.";
            LOGGER.error((Object)message);
            throw new ServletException(message);
        }
        LOGGER.debug((Object)("Method to call = " + methodName));
        return methodName;
    }

    protected boolean isAutoSession() {
        String queryString = this.webImplicitObjects.getHttpServletRequest().getQueryString();
        String autoSession = ServletUtil.getQueryStringParameter(queryString, "Cactus_AutomaticSession");
        boolean isAutomaticSession = Boolean.valueOf(autoSession);
        LOGGER.debug((Object)("Auto session is " + isAutomaticSession));
        return isAutomaticSession;
    }

    protected TestCase getTestClassInstance(String theClassName, String theWrappedClassName, String theTestCaseName) throws ServletException {
        TestCase testInstance;
        block13: {
            Class testClass = this.getTestClassClass(theClassName);
            testInstance = null;
            try {
                TestCase wrappedTestInstance;
                if (theWrappedClassName == null) {
                    Constructor constructor = this.getTestClassConstructor(testClass);
                    if (constructor.getParameterTypes().length == 0) {
                        testInstance = (TestCase)constructor.newInstance(new Object[0]);
                        testInstance.setName(theTestCaseName);
                    } else {
                        testInstance = (TestCase)constructor.newInstance(theTestCaseName);
                    }
                    break block13;
                }
                Class wrappedTestClass = this.getTestClassClass(theWrappedClassName);
                Constructor wrappedConstructor = this.getTestClassConstructor(wrappedTestClass);
                if (wrappedConstructor.getParameterTypes().length == 0) {
                    wrappedTestInstance = (TestCase)wrappedConstructor.newInstance(new Object[0]);
                    wrappedTestInstance.setName(theTestCaseName);
                } else {
                    wrappedTestInstance = (TestCase)wrappedConstructor.newInstance(theTestCaseName);
                }
                Class[] classArray = new Class[2];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("junit.framework.Test");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Constructor constructor = testClass.getConstructor(classArray);
                testInstance = (TestCase)constructor.newInstance(theTestCaseName, wrappedTestInstance);
            }
            catch (Exception e) {
                String message = "Error instantiating class [" + theClassName + "([" + theTestCaseName + "], [" + theWrappedClassName + "])]";
                LOGGER.error((Object)message, (Throwable)e);
                throw new ServletException(message, (Throwable)e);
            }
        }
        return testInstance;
    }

    private Constructor getTestClassConstructor(Class theTestClass) throws NoSuchMethodException {
        Constructor constructor;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            constructor = theTestClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            constructor = theTestClass.getConstructor(new Class[0]);
        }
        return constructor;
    }

    protected Class getTestClassClass(String theClassName) throws ServletException {
        Class testClass = null;
        try {
            testClass = ClassLoaderUtils.loadClass(theClassName, this.getClass());
        }
        catch (Exception e) {
            String message = "Error finding class [" + theClassName + "] using both the Context classloader and the webapp " + "classloader. Possible causes include:\r\n";
            message = String.valueOf(message) + "\t- Your webapp does not include your test classes,\r\n";
            message = String.valueOf(message) + "\t- The cactus.jar is not located in your WEB-INF/lib directory and your Container has not set the Context classloader to point to the webapp one";
            LOGGER.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        return testClass;
    }
}

