/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.deployment.webapp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cactus.integration.ant.deployment.webapp.WebXmlTag;
import org.apache.cactus.integration.ant.deployment.webapp.WebXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebXml {
    private static final WebXmlTag[] ELEMENT_ORDER = new WebXmlTag[]{WebXmlTag.ICON, WebXmlTag.DISPLAY_NAME, WebXmlTag.DESCRIPTION, WebXmlTag.DISTRIBUTABLE, WebXmlTag.FILTER, WebXmlTag.FILTER_MAPPING, WebXmlTag.LISTENER, WebXmlTag.SERVLET, WebXmlTag.SERVLET_MAPPING, WebXmlTag.SESSION_CONFIG, WebXmlTag.MIME_MAPPING, WebXmlTag.WELCOME_FILE_LIST, WebXmlTag.ERROR_PAGE, WebXmlTag.TAGLIB, WebXmlTag.RESOURCE_ENV_REF, WebXmlTag.RESOURCE_REF, WebXmlTag.SECURITY_CONSTRAINT, WebXmlTag.LOGIN_CONFIG, WebXmlTag.SECURITY_ROLE, WebXmlTag.ENV_ENTRY, WebXmlTag.EJB_REF, WebXmlTag.EJB_LOCAL_REF};
    private final Document document;
    private final Element rootElement;

    public WebXml(Document theDocument) {
        this.document = theDocument;
        this.rootElement = theDocument.getDocumentElement();
    }

    public final Document getDocument() {
        return this.document;
    }

    public final WebXmlVersion getVersion() {
        DocumentType docType = this.document.getDoctype();
        if (docType != null) {
            return WebXmlVersion.valueOf(docType);
        }
        return null;
    }

    public final void addFilter(String theFilterName, String theFilterClass) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        if (this.hasFilter(theFilterName)) {
            throw new IllegalStateException("Filter '" + theFilterName + "' already defined");
        }
        Element filterElement = this.document.createElement(WebXmlTag.FILTER.getTagName());
        filterElement.appendChild(this.createNestedText(WebXmlTag.FILTER_NAME, theFilterName));
        filterElement.appendChild(this.createNestedText(WebXmlTag.FILTER_CLASS, theFilterClass));
        this.addElement(WebXmlTag.FILTER, filterElement);
    }

    public final void addContextParam(Element theContextParam) {
        this.checkElement(theContextParam, WebXmlTag.CONTEXT_PARAM);
        String paramName = this.getNestedText(theContextParam, WebXmlTag.PARAM_NAME);
        if (paramName == null) {
            throw new IllegalArgumentException("Not a valid context-param name element");
        }
        String paramValue = this.getNestedText(theContextParam, WebXmlTag.PARAM_VALUE);
        if (paramValue == null) {
            throw new IllegalArgumentException("Not a valid context-param value element");
        }
        if (this.hasContextParam(paramName)) {
            throw new IllegalStateException("Context param '" + paramName + "' already defined");
        }
        this.addElement(WebXmlTag.CONTEXT_PARAM, theContextParam);
    }

    public final void addFilter(Element theFilter) {
        this.checkElement(theFilter, WebXmlTag.FILTER);
        String filterName = this.getNestedText(theFilter, WebXmlTag.FILTER_NAME);
        if (filterName == null) {
            throw new IllegalArgumentException("Not a valid filter element");
        }
        if (this.hasFilter(filterName)) {
            throw new IllegalStateException("Filter '" + filterName + "' already defined");
        }
        this.addElement(WebXmlTag.FILTER, theFilter);
    }

    public final void addFilterInitParam(String theFilterName, String theParamName, String theParamValue) {
        Element filterElement = this.getFilter(theFilterName);
        if (filterElement == null) {
            throw new IllegalStateException("Filter '" + theFilterName + "' not defined");
        }
        this.addInitParam(filterElement, theParamName, theParamValue);
    }

    public final void addFilterMapping(String theFilterName, String theUrlPattern) {
        if (!this.hasFilter(theFilterName)) {
            throw new IllegalStateException("Filter '" + theFilterName + "' not defined");
        }
        Element filterMappingElement = this.document.createElement(WebXmlTag.FILTER_MAPPING.getTagName());
        filterMappingElement.appendChild(this.createNestedText(WebXmlTag.FILTER_NAME, theFilterName));
        filterMappingElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, theUrlPattern));
        this.addElement(WebXmlTag.FILTER_MAPPING, filterMappingElement);
    }

    public final Element getFilter(String theFilterName) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            if (!theFilterName.equals(this.getNestedText(filterElement, WebXmlTag.FILTER_NAME))) continue;
            return filterElement;
        }
        return null;
    }

    public final Element getContextParam(String theParamName) {
        if (theParamName == null) {
            throw new NullPointerException();
        }
        Iterator contextParamElements = this.getElements(WebXmlTag.CONTEXT_PARAM);
        while (contextParamElements.hasNext()) {
            Element contextParamElement = (Element)contextParamElements.next();
            if (!theParamName.equals(this.getNestedText(contextParamElement, WebXmlTag.PARAM_NAME))) continue;
            return contextParamElement;
        }
        return null;
    }

    public final String getContextParamName(Element theContextParam) {
        return this.getNestedText(theContextParam, WebXmlTag.PARAM_NAME);
    }

    public final Iterator getFilterNamesForClass(String theClassName) {
        if (theClassName == null) {
            throw new NullPointerException();
        }
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        ArrayList<String> filterNames = new ArrayList<String>();
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            if (!theClassName.equals(this.getNestedText(filterElement, WebXmlTag.FILTER_CLASS))) continue;
            filterNames.add(this.getNestedText(filterElement, WebXmlTag.FILTER_NAME));
        }
        return filterNames.iterator();
    }

    public final String getFilterInitParam(String theFilterName, String theParamName) {
        return this.getInitParam(this.getFilter(theFilterName), theParamName);
    }

    public final Iterator getFilterInitParamNames(String theFilterName) {
        return this.getInitParamNames(this.getFilter(theFilterName));
    }

    public final Iterator getFilterMappings(String theFilterName) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> filterMappings = new ArrayList<String>();
        Iterator filterMappingElements = this.getElements(WebXmlTag.FILTER_MAPPING);
        while (filterMappingElements.hasNext()) {
            String urlPattern;
            Element filterMappingElement = (Element)filterMappingElements.next();
            if (!theFilterName.equals(this.getNestedText(filterMappingElement, WebXmlTag.FILTER_NAME)) || (urlPattern = this.getNestedText(filterMappingElement, WebXmlTag.URL_PATTERN)) == null) continue;
            filterMappings.add(urlPattern);
        }
        return filterMappings.iterator();
    }

    public final Iterator getFilterNames() {
        ArrayList<String> filterNames = new ArrayList<String>();
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            String filterName = this.getNestedText(filterElement, WebXmlTag.FILTER_NAME);
            if (filterName == null) continue;
            filterNames.add(filterName);
        }
        return filterNames.iterator();
    }

    public final boolean hasContextParam(String theParamName) {
        return this.getContextParam(theParamName) != null;
    }

    public final boolean hasFilter(String theFilterName) {
        return this.getFilter(theFilterName) != null;
    }

    public final void addJspFile(String theServletName, String theJspFile) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        if (this.hasFilter(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' already defined");
        }
        Element servletElement = this.document.createElement(WebXmlTag.SERVLET.getTagName());
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletElement.appendChild(this.createNestedText(WebXmlTag.JSP_FILE, theJspFile));
        this.addElement(WebXmlTag.SERVLET, servletElement);
    }

    public final void addServlet(String theServletName, String theServletClass) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        if (this.hasServlet(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' already defined");
        }
        Element servletElement = this.document.createElement(WebXmlTag.SERVLET.getTagName());
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_CLASS, theServletClass));
        this.addElement(WebXmlTag.SERVLET, servletElement);
    }

    public final void addServlet(Element theServlet) {
        this.checkElement(theServlet, WebXmlTag.SERVLET);
        String servletName = this.getNestedText(theServlet, WebXmlTag.SERVLET_NAME);
        if (servletName == null) {
            throw new IllegalArgumentException("Not a valid servlet element");
        }
        if (this.hasServlet(servletName)) {
            throw new IllegalStateException("Servlet '" + servletName + "' already defined");
        }
        this.addElement(WebXmlTag.SERVLET, theServlet);
    }

    public final void addServletInitParam(String theServletName, String theParamName, String theParamValue) {
        Element servletElement = this.getServlet(theServletName);
        if (servletElement == null) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        this.addInitParam(servletElement, theParamName, theParamValue);
    }

    public final void addServletRunAsRoleName(String theServletName, String theRoleName) {
        Element servlet = this.getServlet(theServletName);
        Element runAsElement = this.document.createElement(WebXmlTag.RUN_AS.getTagName());
        runAsElement.appendChild(this.createNestedText(WebXmlTag.ROLE_NAME, theRoleName));
        servlet.appendChild(runAsElement);
    }

    public final void addServletMapping(String theServletName, String theUrlPattern) {
        if (!this.hasServlet(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        Element servletMappingElement = this.document.createElement(WebXmlTag.SERVLET_MAPPING.getTagName());
        servletMappingElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletMappingElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, theUrlPattern));
        this.addElement(WebXmlTag.SERVLET_MAPPING, servletMappingElement);
    }

    public final Element getServlet(String theServletName) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theServletName.equals(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME))) continue;
            return servletElement;
        }
        return null;
    }

    public final String getServletInitParam(String theServletName, String theParamName) {
        return this.getInitParam(this.getServlet(theServletName), theParamName);
    }

    public final Iterator getServletInitParamNames(String theServletName) {
        return this.getInitParamNames(this.getServlet(theServletName));
    }

    public final String getServletRunAsRoleName(String theServletName) {
        Element e;
        if (theServletName == null) {
            throw new NullPointerException();
        }
        String roleName = null;
        Element servlet = this.getServlet(theServletName);
        NodeList nodeList = servlet.getElementsByTagName(WebXmlTag.RUN_AS.getTagName());
        if (nodeList != null && (e = (Element)nodeList.item(0)) != null) {
            roleName = this.getNestedText(e, WebXmlTag.ROLE_NAME);
        }
        return roleName;
    }

    public final Iterator getServletMappings(String theServletName) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> servletMappings = new ArrayList<String>();
        Iterator servletMappingElements = this.getElements(WebXmlTag.SERVLET_MAPPING);
        while (servletMappingElements.hasNext()) {
            String urlPattern;
            Element servletMappingElement = (Element)servletMappingElements.next();
            if (!theServletName.equals(this.getNestedText(servletMappingElement, WebXmlTag.SERVLET_NAME)) || (urlPattern = this.getNestedText(servletMappingElement, WebXmlTag.URL_PATTERN)) == null) continue;
            servletMappings.add(urlPattern);
        }
        return servletMappings.iterator();
    }

    public final Iterator getServletNames() {
        ArrayList<String> servletNames = new ArrayList<String>();
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            String servletName = this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME);
            if (servletName == null) continue;
            servletNames.add(servletName);
        }
        return servletNames.iterator();
    }

    public final Iterator getServletNamesForClass(String theClassName) {
        if (theClassName == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        ArrayList<String> servletNames = new ArrayList<String>();
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theClassName.equals(this.getNestedText(servletElement, WebXmlTag.SERVLET_CLASS))) continue;
            servletNames.add(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME));
        }
        return servletNames.iterator();
    }

    public final Iterator getServletNamesForJspFile(String theJspFile) {
        if (theJspFile == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        ArrayList<String> servletNames = new ArrayList<String>();
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theJspFile.equals(this.getNestedText(servletElement, WebXmlTag.JSP_FILE))) continue;
            servletNames.add(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME));
        }
        return servletNames.iterator();
    }

    public final boolean hasServlet(String theServletName) {
        return this.getServlet(theServletName) != null;
    }

    public final void addSecurityConstraint(String theWebResourceName, String theUrlPattern, List theRoles) {
        if (theWebResourceName == null || theUrlPattern == null || theRoles == null) {
            throw new NullPointerException();
        }
        if (this.hasSecurityConstraint(theUrlPattern)) {
            throw new IllegalStateException("Security constraint for URL pattern " + theUrlPattern + " already defined");
        }
        Element securityConstraintElement = this.document.createElement(WebXmlTag.SECURITY_CONSTRAINT.getTagName());
        Element webResourceCollectionElement = this.document.createElement(WebXmlTag.WEB_RESOURCE_COLLECTION.getTagName());
        webResourceCollectionElement.appendChild(this.createNestedText(WebXmlTag.WEB_RESOURCE_NAME, theWebResourceName));
        webResourceCollectionElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, theUrlPattern));
        securityConstraintElement.appendChild(webResourceCollectionElement);
        Element authConstraintElement = this.document.createElement(WebXmlTag.AUTH_CONSTRAINT.getTagName());
        Iterator i = theRoles.iterator();
        while (i.hasNext()) {
            authConstraintElement.appendChild(this.createNestedText(WebXmlTag.ROLE_NAME, (String)i.next()));
        }
        securityConstraintElement.appendChild(authConstraintElement);
        this.addElement(WebXmlTag.SECURITY_CONSTRAINT, securityConstraintElement);
    }

    public final Element getSecurityConstraint(String theUrlPattern) {
        if (theUrlPattern == null) {
            throw new NullPointerException();
        }
        Iterator securityConstraintElements = this.getElements(WebXmlTag.SECURITY_CONSTRAINT);
        while (securityConstraintElements.hasNext()) {
            Element webResourceCollectionElement;
            Element securityConstraintElement = (Element)securityConstraintElements.next();
            Iterator webResourceCollectionElements = this.getNestedElements(securityConstraintElement, WebXmlTag.WEB_RESOURCE_COLLECTION);
            if (!webResourceCollectionElements.hasNext() || !theUrlPattern.equals(this.getNestedText(webResourceCollectionElement = (Element)webResourceCollectionElements.next(), WebXmlTag.URL_PATTERN))) continue;
            return securityConstraintElement;
        }
        return null;
    }

    public final boolean hasSecurityConstraint(String theUrlPattern) {
        return this.getSecurityConstraint(theUrlPattern) != null;
    }

    public final boolean hasLoginConfig() {
        return this.getLoginConfig() != null;
    }

    public final Element getLoginConfig() {
        Iterator loginConfigElements = this.getElements(WebXmlTag.LOGIN_CONFIG);
        if (loginConfigElements.hasNext()) {
            return (Element)loginConfigElements.next();
        }
        return null;
    }

    public final String getLoginConfigAuthMethod() {
        return this.getNestedText(this.getLoginConfig(), WebXmlTag.AUTH_METHOD);
    }

    public final void setLoginConfig(String theAuthMethod, String theRealmName) {
        if (theRealmName == null || theAuthMethod == null) {
            throw new NullPointerException();
        }
        Element loginConfigElement = this.document.createElement(WebXmlTag.LOGIN_CONFIG.getTagName());
        loginConfigElement.appendChild(this.createNestedText(WebXmlTag.AUTH_METHOD, theAuthMethod));
        loginConfigElement.appendChild(this.createNestedText(WebXmlTag.REALM_NAME, theRealmName));
        this.replaceElement(WebXmlTag.LOGIN_CONFIG, loginConfigElement);
    }

    public final void addSecurityRole(String theRoleName) {
        if (theRoleName == null) {
            throw new NullPointerException();
        }
        if (this.hasSecurityRole(theRoleName)) {
            throw new IllegalStateException("Security role '" + theRoleName + "' already defined");
        }
        Element securityRoleElement = this.document.createElement(WebXmlTag.SECURITY_ROLE.getTagName());
        securityRoleElement.appendChild(this.createNestedText(WebXmlTag.ROLE_NAME, theRoleName));
        this.addElement(WebXmlTag.SECURITY_ROLE, securityRoleElement);
    }

    public final Element getSecurityRole(String theRoleName) {
        if (theRoleName == null) {
            throw new NullPointerException();
        }
        Iterator securityRoleElements = this.getElements(WebXmlTag.SECURITY_ROLE);
        while (securityRoleElements.hasNext()) {
            Element securityRoleElement = (Element)securityRoleElements.next();
            if (!theRoleName.equals(this.getNestedText(securityRoleElement, WebXmlTag.ROLE_NAME))) continue;
            return securityRoleElement;
        }
        return null;
    }

    public final Iterator getSecurityRoleNames() {
        ArrayList<String> securityRoleNames = new ArrayList<String>();
        Iterator securityRoleElements = this.getElements(WebXmlTag.SECURITY_ROLE);
        while (securityRoleElements.hasNext()) {
            Element securityRoleElement = (Element)securityRoleElements.next();
            String securityRoleName = this.getNestedText(securityRoleElement, WebXmlTag.ROLE_NAME);
            if (securityRoleName == null) continue;
            securityRoleNames.add(securityRoleName);
        }
        return securityRoleNames.iterator();
    }

    public final boolean hasSecurityRole(String theRoleName) {
        return this.getSecurityRole(theRoleName) != null;
    }

    public final Iterator getElements(WebXmlTag theTag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = this.rootElement.getElementsByTagName(theTag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    public final void addElement(WebXmlTag theTag, Element theElement) {
        this.checkElement(theElement, theTag);
        if (!theTag.isMultipleAllowed() && this.getElements(theTag).hasNext()) {
            throw new IllegalStateException("The tag '" + theTag + "' may not occur more than once in the descriptor");
        }
        Node importedNode = this.document.importNode(theElement, true);
        Node refNode = this.getInsertionPointFor(theTag);
        this.rootElement.insertBefore(importedNode, refNode);
    }

    public final void replaceElement(WebXmlTag theTag, Element theElement) {
        Iterator elements = this.getElements(theTag);
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            element.getParentNode().removeChild(element);
        }
        this.addElement(theTag, theElement);
    }

    private void addInitParam(Element theElement, String theParamName, String theParamValue) {
        Element initParamElement = this.document.createElement(WebXmlTag.INIT_PARAM.getTagName());
        initParamElement.appendChild(this.createNestedText(WebXmlTag.PARAM_NAME, theParamName));
        initParamElement.appendChild(this.createNestedText(WebXmlTag.PARAM_VALUE, theParamValue));
        Iterator loadOnStartupElements = this.getNestedElements(theElement, WebXmlTag.LOAD_ON_STARTUP);
        if (loadOnStartupElements.hasNext()) {
            theElement.insertBefore(initParamElement, (Element)loadOnStartupElements.next());
        } else {
            theElement.appendChild(initParamElement);
        }
    }

    private void checkElement(Element theElement, WebXmlTag theExpectedTag) throws IllegalArgumentException {
        if (!theExpectedTag.getTagName().equals(theElement.getNodeName())) {
            throw new IllegalArgumentException("Not a '" + theExpectedTag + "' element");
        }
    }

    private Iterator getNestedElements(Element theParent, WebXmlTag theTag) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = theParent.getElementsByTagName(theTag.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elements.add(nodeList.item(i));
        }
        return elements.iterator();
    }

    private Element createNestedText(WebXmlTag theTag, String theText) {
        Element element = this.document.createElement(theTag.getTagName());
        element.appendChild(this.document.createTextNode(theText));
        return element;
    }

    private String getInitParam(Element theElement, String theParamName) {
        if (theElement != null) {
            NodeList initParamElements = theElement.getElementsByTagName(WebXmlTag.INIT_PARAM.getTagName());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                String paramName = this.getNestedText(initParamElement, WebXmlTag.PARAM_NAME);
                if (!theParamName.equals(paramName)) continue;
                return this.getNestedText(initParamElement, WebXmlTag.PARAM_VALUE);
            }
        }
        return null;
    }

    private Iterator getInitParamNames(Element theElement) {
        ArrayList<String> initParamNames = new ArrayList<String>();
        if (theElement != null) {
            NodeList initParamElements = theElement.getElementsByTagName(WebXmlTag.INIT_PARAM.getTagName());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                String paramName = this.getNestedText(initParamElement, WebXmlTag.PARAM_NAME);
                if (paramName == null) continue;
                initParamNames.add(paramName);
            }
        }
        return initParamNames.iterator();
    }

    private Node getInsertionPointFor(WebXmlTag theTag) {
        for (int i = 0; i < ELEMENT_ORDER.length; ++i) {
            if (ELEMENT_ORDER[i] != theTag) continue;
            for (int j = i + 1; j < ELEMENT_ORDER.length; ++j) {
                NodeList elements = this.rootElement.getElementsByTagName(ELEMENT_ORDER[j].getTagName());
                if (elements.getLength() <= 0) continue;
                Node result = elements.item(0);
                Node previous = result.getPreviousSibling();
                while (previous != null && (previous.getNodeType() == 8 || previous.getNodeType() == 3)) {
                    result = previous;
                    previous = result.getPreviousSibling();
                }
                return result;
            }
            break;
        }
        return null;
    }

    private String getNestedText(Element theElement, WebXmlTag theTag) {
        Node nestedText;
        NodeList nestedElements = theElement.getElementsByTagName(theTag.getTagName());
        if (nestedElements.getLength() > 0 && (nestedText = nestedElements.item(0).getFirstChild()) != null) {
            return nestedText.getNodeValue();
        }
        return null;
    }
}

