/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.haw.grain.transform.GudTransformException;
import jp.haw.grain.transform.TransformOperation;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.Body2View;
import jp.haw.grain.transform.transformer.BodyDescendants2Inline;
import jp.haw.grain.transform.transformer.Br2inline;
import jp.haw.grain.transform.transformer.DivAndGroup2Block;
import jp.haw.grain.transform.transformer.Html2Form;
import jp.haw.grain.transform.transformer.Item2Item;
import jp.haw.grain.transform.transformer.ModelChildCopy;
import jp.haw.grain.transform.transformer.P2InlineBlock;
import jp.haw.grain.transform.transformer.Secret2Textbox;
import jp.haw.grain.transform.transformer.Span2Inlinegroup;
import jp.haw.grain.transform.transformer.Submit2Button;
import jp.haw.grain.transform.transformer.Text2Inline;
import jp.haw.grain.transform.transformer.Textarea2Textbox;
import jp.haw.grain.transform.transformer.Transformer;
import jp.haw.grain.transform.transformer.TriggerAndSubmitChildCopy;
import jp.haw.grain.transform.transformer.XFormsElementTransformer;
import jp.haw.grain.transform.util.TargetNode;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GudBuilder {
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    public static final String XFORMS_NS = "http://www.w3.org/2002/xforms";
    public static final String EVENT_NS = "http://www.w3.org/2001/xml-events";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String GUD_NS = "http://grain.jp/gud/";
    public static final String STYLE_ITALIC = "italic";
    public static final String STYLE_BOLD = "bold";
    public static final String SIZE_LARGE = "large";
    public static final String SIZE_MEDIUM = "medium";
    public static final String SIZE_SMALL = "small";
    protected Document xhtmlDoc;
    protected Document gudDoc;
    protected Element currentGud;
    protected List skipNodeList;
    protected Transformer startTransformer;
    protected Map nsMap;
    protected int deep = 0;

    public GudBuilder(Document doc) {
        this.xhtmlDoc = doc;
        DOMImplementationImpl domi = new DOMImplementationImpl();
        this.gudDoc = domi.createDocument(GUD_NS, "form", null);
        this.currentGud = this.gudDoc.getDocumentElement();
        this.skipNodeList = new ArrayList();
        this.nsMap = new HashMap();
    }

    protected AbstractTransformer createTransformerChain() {
        Html2Form html2form = new Html2Form(this);
        ModelChildCopy modelchildCopy = new ModelChildCopy(this);
        Body2View body2view = new Body2View(this);
        XFormsElementTransformer input2textbox = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "input", 1), "textbox");
        Secret2Textbox secret2Textbox = new Secret2Textbox(this);
        Textarea2Textbox textarea2Textbox = new Textarea2Textbox(this);
        XFormsElementTransformer output2inline = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "output", 1), "inline");
        XFormsElementTransformer trigger2button = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "trigger", 1), "button");
        trigger2button.setTransformChildLabel(false);
        TriggerAndSubmitChildCopy triggerChildCopy = new TriggerAndSubmitChildCopy(this);
        Submit2Button submit2Button = new Submit2Button(this);
        XFormsElementTransformer select2Select = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "select", 1), "select");
        XFormsElementTransformer select12Choice = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "select1", 1), "choice");
        Item2Item item2Item = new Item2Item(this);
        XFormsElementTransformer switch2TabBlock = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "switch", 1), "tab-block");
        XFormsElementTransformer case2Inlinblock = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "case", 1), "block");
        XFormsElementTransformer toggle2Toggle = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "toggle", 1), "toggle");
        XFormsElementTransformer update2update = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "upload", 1), "upload");
        XFormsElementTransformer mediatype2mediatype = new XFormsElementTransformer(this, new TargetNode(XFORMS_NS, "mediatype", 1), "mediatype");
        XFormsElementTransformer img2image = new XFormsElementTransformer(this, new TargetNode(XHTML_NS, "img", 1), "image");
        DivAndGroup2Block divAndGroup2Block = new DivAndGroup2Block(this);
        P2InlineBlock p2inlineblock = new P2InlineBlock(this);
        Span2Inlinegroup span2inlinegroup = new Span2Inlinegroup(this);
        Br2inline br2inline = new Br2inline(this);
        BodyDescendants2Inline toItalicInline = new BodyDescendants2Inline(this);
        toItalicInline.setTargetLocalNames(new String[]{"cite", "dfn", "em", "i", "var"});
        toItalicInline.setStyle(STYLE_ITALIC);
        BodyDescendants2Inline toBoldInline = new BodyDescendants2Inline(this);
        toBoldInline.setTargetLocalNames(new String[]{"b", "strong"});
        toBoldInline.setStyle(STYLE_BOLD);
        BodyDescendants2Inline hxToInline = new BodyDescendants2Inline(this);
        hxToInline.setTargetLocalNames(new String[]{"h1", "h2", "h3", "h4", "h5", "h6"});
        hxToInline.setStyle(STYLE_BOLD);
        hxToInline.setSize(SIZE_LARGE);
        BodyDescendants2Inline bigToInline = new BodyDescendants2Inline(this);
        bigToInline.setTargetLocalNames(new String[]{"big"});
        bigToInline.setSize(SIZE_LARGE);
        BodyDescendants2Inline smallToInline = new BodyDescendants2Inline(this);
        smallToInline.setTargetLocalNames(new String[]{SIZE_SMALL});
        smallToInline.setSize(SIZE_SMALL);
        Text2Inline text2inline = new Text2Inline(this);
        html2form.setNext(modelchildCopy);
        modelchildCopy.setNext(body2view);
        body2view.setNext(output2inline);
        output2inline.setNext(input2textbox);
        input2textbox.setNext(secret2Textbox);
        secret2Textbox.setNext(textarea2Textbox);
        textarea2Textbox.setNext(trigger2button);
        trigger2button.setNext(submit2Button);
        submit2Button.setNext(triggerChildCopy);
        triggerChildCopy.setNext(update2update);
        update2update.setNext(mediatype2mediatype);
        mediatype2mediatype.setNext(img2image);
        img2image.setNext(select2Select);
        select2Select.setNext(select12Choice);
        select12Choice.setNext(item2Item);
        item2Item.setNext(switch2TabBlock);
        switch2TabBlock.setNext(case2Inlinblock);
        case2Inlinblock.setNext(toggle2Toggle);
        toggle2Toggle.setNext(divAndGroup2Block);
        divAndGroup2Block.setNext(p2inlineblock);
        p2inlineblock.setNext(span2inlinegroup);
        span2inlinegroup.setNext(toItalicInline);
        toItalicInline.setNext(toBoldInline);
        toBoldInline.setNext(hxToInline);
        hxToInline.setNext(bigToInline);
        bigToInline.setNext(smallToInline);
        smallToInline.setNext(br2inline);
        br2inline.setNext(text2inline);
        return html2form;
    }

    public void addNamespace(String prefix, String namespaceURI) {
        this.nsMap.put(prefix, namespaceURI);
    }

    protected void transformNode(Node node, TransformOperation operation) throws GudTransformException {
        try {
            if (!this.isSkipNode(node)) {
                this.createTransformerChain().apply(node, operation);
            }
        }
        catch (Exception e) {
            throw new GudTransformException("deep=" + this.deep + " node=" + node.getClass().getName() + "[" + node.getNodeName() + ": " + node.getNamespaceURI() + ": " + node.getNodeValue(), e);
        }
        if (!node.hasChildNodes()) {
            return;
        }
        ++this.deep;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            TransformOperation childOperation = operation.createChildNodeOperation();
            this.transformNode(children.item(i), childOperation);
        }
        --this.deep;
    }

    protected boolean isSkipNode(Node node) {
        for (int i = 0; i < this.skipNodeList.size(); ++i) {
            if (!this.skipNodeList.get(i).equals(node)) continue;
            this.skipNodeList.remove(node);
            return true;
        }
        return false;
    }

    public Document build() throws GudTransformException {
        Element xhtmlRoot = this.xhtmlDoc.getDocumentElement();
        TransformOperation operation = new TransformOperation(this.currentGud);
        this.transformNode(xhtmlRoot, operation);
        Element form = this.gudDoc.getDocumentElement();
        form.setAttribute("xmlns", GUD_NS);
        Iterator keys = this.nsMap.keySet().iterator();
        while (keys.hasNext()) {
            String prefix = keys.next().toString();
            String ns = this.nsMap.get(prefix).toString();
            if (XFORMS_NS.equals(ns) || XHTML_NS.equals(ns) || XMLNS_NS.equals(ns)) continue;
            form.setAttribute("xmlns:" + prefix, ns);
        }
        return this.gudDoc;
    }

    public Document getGudDoc() {
        return this.gudDoc;
    }

    public void addSkipNode(Node node) {
        if (node == null) {
            return;
        }
        this.skipNodeList.add(node);
    }
}

