/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import jp.haw.grain.framework.xml.XMLOutputter;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class BinaryXMLReader
extends Reader {
    private static final Logger log = Logger.getLogger((Class)BinaryXMLReader.class);
    private XMLOutputter out;
    private boolean versionread = false;
    private CharBuffer buffer;
    private CharsetEncoder encoder;

    public BinaryXMLReader(XMLOutputter out) {
        this.out = out;
        this.encoder = Charset.forName(out.getEncoding()).newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int pos;
        int size;
        for (pos = 0; pos < len; pos += size) {
            if (this.buffer == null || this.buffer.remaining() == 0) {
                this.allocateBuffer();
            }
            if (this.buffer == null) {
                return pos > 0 ? pos : -1;
            }
            size = this.buffer.remaining();
            if (pos + size > len) {
                size = len - pos;
            }
            this.buffer.get(cbuf, off + pos, size);
        }
        return pos;
    }

    public void close() throws IOException {
    }

    private void allocateBuffer() throws IOException {
        try {
            do {
                if (this.out.isEndOfDocument()) {
                    this.buffer = null;
                    return;
                }
                StringWriter writer = new StringWriter();
                this.out.writeNextTagTo(writer);
                log.debug((Object)("read tag while allocate buffer: " + writer.toString()));
                this.buffer = CharBuffer.wrap(writer.getBuffer());
                log.debug((Object)("initial remaining: " + this.buffer.remaining()));
            } while (this.buffer.limit() == 0);
        }
        catch (XmlPullParserException e) {
            log.warn((Object)"parse error while filling buffer", (Throwable)e);
            try {
                throw new IOException("binary xml parse error").initCause(e);
            }
            catch (Throwable throwable) {
            }
        }
        catch (IOException e) {
            log.warn((Object)"io error while parsing", (Throwable)e);
            throw e;
        }
    }
}

