
/*
GL_TEXTURE_RECTANGLE_NVgƂ
samplerRECT + texture2DRect
GL_TEXTURE_2DgƂ
sampler2D + texture2D
*/
uniform sampler2D Texture0;
uniform sampler2D Texture1;

varying vec3 position;
varying vec3 normal;

void main (void)
{
	vec4 tex_color = texture2D(Texture0, gl_TexCoord[0].xy);

	// Spot light from camera
	vec3 nrml = normalize(normal);
	vec3 light_dir = normalize(position);
	float light_power = pow(max(dot(light_dir, vec3(0.0, 0.0, -1.0)), 0.0), 9.0);

	float diffuse = dot(-light_dir, nrml);
	vec4 ret_color = vec4(0.6, 0.3, 0.1, 1.0)*0.1;/*gl_LightSource[0].ambient;*/
	if (diffuse > 0.0)
	{
		vec3 reflected = reflect(light_dir, nrml);
		float specular = pow(max(dot(reflected, -light_dir), 0.0), 2.0);//gl_FrontMaterial.shininess);
		ret_color += /*gl_LightSource[0].diffuse*/vec4(0.785, 0.416, 0.310, 1.0) * diffuse*0.4
				  + /*gl_FrontLightProduct[0].specular*/vec4(0.914, 0.804, 0.750, 1.0) * specular*/*0.1*/0.7*light_power;
	}

	gl_FragColor = //tex_color * /*gl_Color */0.2+
					ret_color;
}
