/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTAllocationExpression;
import FESI.AST.ASTAndExpressionSequence;
import FESI.AST.ASTAssignmentExpression;
import FESI.AST.ASTBinaryExpressionSequence;
import FESI.AST.ASTBreakStatement;
import FESI.AST.ASTCompositeReference;
import FESI.AST.ASTConditionalExpression;
import FESI.AST.ASTContinueStatement;
import FESI.AST.ASTEmptyExpression;
import FESI.AST.ASTExpressionList;
import FESI.AST.ASTForInStatement;
import FESI.AST.ASTForStatement;
import FESI.AST.ASTForVarInStatement;
import FESI.AST.ASTForVarStatement;
import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTFunctionCallParameters;
import FESI.AST.ASTFunctionDeclaration;
import FESI.AST.ASTIdentifier;
import FESI.AST.ASTIfStatement;
import FESI.AST.ASTLiteral;
import FESI.AST.ASTOperator;
import FESI.AST.ASTOrExpressionSequence;
import FESI.AST.ASTPostfixExpression;
import FESI.AST.ASTProgram;
import FESI.AST.ASTPropertyIdentifierReference;
import FESI.AST.ASTPropertyValueReference;
import FESI.AST.ASTReturnStatement;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.AST.ASTThisReference;
import FESI.AST.ASTUnaryExpression;
import FESI.AST.ASTVariableDeclaration;
import FESI.AST.ASTWhileStatement;
import FESI.AST.ASTWithStatement;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.SimpleNode;
import FESI.Data.ConstructedFunctionObject;
import FESI.Data.ESReference;
import FESI.Data.GlobalObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EcmaScriptVariableVisitor;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FunctionEvaluationSource;
import FESI.Parser.EcmaScriptConstants;
import java.util.Vector;

public class EcmaScriptFunctionVisitor
implements EcmaScriptVisitor,
EcmaScriptConstants {
    private Evaluator evaluator;
    private boolean debug = false;
    private EvaluationSource currentEvaluationSource;

    public EcmaScriptFunctionVisitor(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void processFunctionDeclarations(ASTProgram aSTProgram, EvaluationSource evaluationSource) {
        if (this.debug) {
            System.out.println("processFunctionDeclarations: " + aSTProgram);
        }
        if (this.currentEvaluationSource != null) {
            throw new ProgrammingError("illegal recursive function definition");
        }
        this.currentEvaluationSource = evaluationSource;
        try {
            aSTProgram.jjtAccept(this, null);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentEvaluationSource = null;
            throw throwable;
        }
        Object var4_3 = null;
        this.currentEvaluationSource = null;
    }

    private void badAST() {
        throw new ProgrammingError("Bad AST walk in EcmaScriptFunctionVisitor");
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTProgram aSTProgram, Object object) {
        object = aSTProgram.childrenAccept(this, object);
        return object;
    }

    public Object visit(ASTStatementList aSTStatementList, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTFunctionDeclaration aSTFunctionDeclaration, Object object) {
        int n = aSTFunctionDeclaration.jjtGetNumChildren();
        if (n != 3) {
            throw new ProgrammingError("Bad AST in function declaration");
        }
        ASTIdentifier aSTIdentifier = (ASTIdentifier)aSTFunctionDeclaration.jjtGetChild(0);
        FunctionEvaluationSource functionEvaluationSource = new FunctionEvaluationSource(this.currentEvaluationSource, aSTIdentifier.getName());
        ASTFormalParameterList aSTFormalParameterList = (ASTFormalParameterList)aSTFunctionDeclaration.jjtGetChild(1);
        ASTStatementList aSTStatementList = (ASTStatementList)aSTFunctionDeclaration.jjtGetChild(2);
        EcmaScriptVariableVisitor ecmaScriptVariableVisitor = this.evaluator.getVarDeclarationVisitor();
        Vector vector = ecmaScriptVariableVisitor.processVariableDeclarations(aSTStatementList, (EvaluationSource)functionEvaluationSource);
        if (this.debug) {
            System.out.println("FUNC DECL: " + aSTIdentifier.getName());
        }
        GlobalObject globalObject = this.evaluator.getGlobalObject();
        try {
            ESReference eSReference = new ESReference(globalObject, aSTIdentifier.getName(), aSTIdentifier.hashCode());
            ConstructedFunctionObject constructedFunctionObject = ConstructedFunctionObject.makeNewConstructedFunction(this.evaluator, aSTIdentifier.getName(), functionEvaluationSource, aSTFunctionDeclaration.getSourceString(), aSTFormalParameterList.getArguments(), vector, aSTStatementList);
            this.evaluator.putValue(eSReference, constructedFunctionObject);
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError("Unexpected error registering function" + ecmaScriptException.getMessage());
        }
        return object;
    }

    public Object visit(ASTFormalParameterList aSTFormalParameterList, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTStatement aSTStatement, Object object) {
        return object;
    }

    public Object visit(ASTVariableDeclaration aSTVariableDeclaration, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTIfStatement aSTIfStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTContinueStatement aSTContinueStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTWhileStatement aSTWhileStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTForStatement aSTForStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTForInStatement aSTForInStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTForVarStatement aSTForVarStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTForVarInStatement aSTForVarInStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTBreakStatement aSTBreakStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTReturnStatement aSTReturnStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTWithStatement aSTWithStatement, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTThisReference aSTThisReference, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTCompositeReference aSTCompositeReference, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTFunctionCallParameters aSTFunctionCallParameters, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTPropertyValueReference aSTPropertyValueReference, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTPropertyIdentifierReference aSTPropertyIdentifierReference, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTAllocationExpression aSTAllocationExpression, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTOperator aSTOperator, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTPostfixExpression aSTPostfixExpression, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTUnaryExpression aSTUnaryExpression, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTBinaryExpressionSequence aSTBinaryExpressionSequence, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTAndExpressionSequence aSTAndExpressionSequence, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTOrExpressionSequence aSTOrExpressionSequence, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTConditionalExpression aSTConditionalExpression, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTAssignmentExpression aSTAssignmentExpression, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTExpressionList aSTExpressionList, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTEmptyExpression aSTEmptyExpression, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTLiteral aSTLiteral, Object object) {
        this.badAST();
        return object;
    }

    public Object visit(ASTIdentifier aSTIdentifier, Object object) {
        this.badAST();
        return object;
    }
}

