/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESDatabase;
import FESI.Interpreter.Evaluator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

class ESRowSet
extends ESObject {
    private transient ESDatabase database;
    private transient String sql;
    private transient Statement statement;
    private transient ResultSet resultSet;
    private transient ResultSetMetaData resultSetMetaData;
    private transient Vector colNames;
    private transient boolean lastRowSeen = false;
    private transient boolean firstRowSeen = false;
    private transient Exception lastError;

    ESRowSet(ESObject eSObject, Evaluator evaluator, String string, ESDatabase eSDatabase, Statement statement, ResultSet resultSet) throws EcmaScriptException {
        super(eSObject, evaluator);
        this.sql = string;
        this.database = eSDatabase;
        this.statement = statement;
        this.resultSet = resultSet;
        if (string == null) {
            throw new NullPointerException("sql");
        }
        if (resultSet == null) {
            throw new NullPointerException("resultSet");
        }
        if (statement == null) {
            throw new NullPointerException("statement");
        }
        if (eSDatabase == null) {
            throw new NullPointerException("database");
        }
        try {
            this.resultSetMetaData = resultSet.getMetaData();
            int n = this.resultSetMetaData.getColumnCount();
            this.colNames = new Vector(n);
            int n2 = 0;
            while (n2 < n) {
                String string2 = this.resultSetMetaData.getColumnLabel(n2 + 1);
                this.colNames.addElement(string2);
                ++n2;
            }
            return;
        }
        catch (SQLException sQLException) {
            this.colNames = new Vector();
            throw new EcmaScriptException("Could not get column names", sQLException);
        }
    }

    public String getESClassName() {
        return "RowSet";
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    public int getColumnCount() {
        return this.colNames.size();
    }

    public Object getMetaData() {
        return this.resultSetMetaData;
    }

    ESValue getLastError() throws EcmaScriptException {
        if (this.lastError == null) {
            return ESUndefined.theUndefined;
        }
        return ESLoader.normalizeValue(this.lastError, this.evaluator);
    }

    ESValue release() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException sQLException) {}
        this.statement = null;
        this.resultSet = null;
        this.resultSetMetaData = null;
        return ESUndefined.theUndefined;
    }

    public boolean hasMoreRows() {
        return !this.lastRowSeen;
    }

    public String getColumnName(int n) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (n > 0 && n <= this.colNames.size()) {
            return (String)this.colNames.elementAt(n - 1);
        }
        throw new EcmaScriptException("Column index (base 1) " + n + " out of range, max: " + this.colNames.size());
    }

    public int getColumnDatatypeNumber(int n) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (n > 0 && n <= this.colNames.size()) {
            try {
                return this.resultSetMetaData.getColumnType(n);
            }
            catch (SQLException sQLException) {
                this.lastError = sQLException;
                return -1;
            }
        }
        throw new EcmaScriptException("Column index (base 1) " + n + " out of range, max: " + this.colNames.size());
    }

    public String getColumnDatatypeName(int n) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (n > 0 && n <= this.colNames.size()) {
            try {
                return this.resultSetMetaData.getColumnTypeName(n);
            }
            catch (SQLException sQLException) {
                this.lastError = sQLException;
                return null;
            }
        }
        throw new EcmaScriptException("Column index (base 1) " + n + " out of range, max: " + this.colNames.size());
    }

    public ESValue getColumnItem(String string) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (!this.firstRowSeen) {
            throw new EcmaScriptException("Attempt to access data before the first row is read");
        }
        string.hashCode();
        try {
            int n = -1;
            try {
                char c = string.charAt(0);
                if (c >= '0' && c <= '9') {
                    n = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            if (n >= 0) {
                return this.getProperty(n);
            }
            Object object = this.resultSet.getObject(string);
            ESValue eSValue = ESLoader.normalizeValue(object, this.evaluator);
            this.lastError = null;
            return eSValue;
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException;
            return ESUndefined.theUndefined;
        }
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        if (string.equals("length")) {
            return new ESNumber(this.colNames.size());
        }
        if (super.hasProperty(string, n)) {
            return super.getProperty(string, n);
        }
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (!this.firstRowSeen) {
            throw new EcmaScriptException("Attempt to access data before the first row is read");
        }
        try {
            int n2 = -1;
            try {
                char c = string.charAt(0);
                if (c >= '0' && c <= '9') {
                    n2 = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            if (n2 >= 0) {
                return this.getProperty(n2);
            }
            Object object = this.resultSet.getObject(string);
            ESValue eSValue = ESLoader.normalizeValue(object, this.evaluator);
            this.lastError = null;
            return eSValue;
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException;
            return ESUndefined.theUndefined;
        }
    }

    public ESValue getProperty(int n) throws EcmaScriptException {
        if (!this.firstRowSeen) {
            throw new EcmaScriptException("Attempt to access data before the first row is read");
        }
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        try {
            Object object = this.resultSet.getObject(n);
            ESValue eSValue = ESLoader.normalizeValue(object, this.evaluator);
            this.lastError = null;
            return eSValue;
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException;
            return ESUndefined.theUndefined;
        }
    }

    public Enumeration getProperties() {
        if (this.resultSet == null) {
            return new Vector().elements();
        }
        return this.colNames.elements();
    }

    public Enumeration getAllProperties() {
        return new 1();
    }

    public String[] getSpecialPropertyNames() {
        String[] stringArray = new String[]{"length"};
        return stringArray;
    }

    ESValue next() throws EcmaScriptException {
        boolean bl = false;
        if (this.lastRowSeen) {
            throw new EcmaScriptException("Attempt to access a next row after last row has been returned");
        }
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        try {
            bl = this.resultSet.next();
            this.lastError = null;
        }
        catch (SQLException sQLException) {
            this.lastError = sQLException;
        }
        if (bl) {
            this.firstRowSeen = true;
        } else {
            this.lastRowSeen = true;
        }
        return ESBoolean.makeBoolean(bl);
    }

    public String toString() {
        return "[RowSet: '" + this.sql + "'" + (this.resultSet == null ? " - released]" : (this.lastRowSeen ? " - at end]" : (this.firstRowSeen ? "]" : " - at start]")));
    }

    private final class 1
    implements Enumeration {
        String[] specialProperties;
        int specialEnumerator;
        Enumeration props;
        String currentKey;
        int currentHash;
        boolean inside;

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.currentKey != null) {
                return true;
            }
            if (this.specialEnumerator >= this.specialProperties.length) ** GOTO lbl17
            this.currentKey = this.specialProperties[this.specialEnumerator];
            this.currentHash = this.currentKey.hashCode();
            ++this.specialEnumerator;
            return true;
lbl-1000:
            // 1 sources

            {
                this.currentKey = (String)this.props.nextElement();
                this.currentHash = this.currentKey.hashCode();
                if (this.inside) {
                    try {
                        if (ESRowSet.this.hasProperty(this.currentKey, this.currentHash)) {
                            continue;
                        }
                    }
                    catch (EcmaScriptException v0) {}
                }
                return true;
lbl17:
                // 2 sources

                ** while (this.props.hasMoreElements())
            }
lbl18:
            // 1 sources

            if (!this.inside && ESRowSet.this.getPrototype() != null) {
                this.inside = true;
                this.props = ESRowSet.this.getPrototype().getProperties();
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    try {
                        if (ESRowSet.this.hasProperty(this.currentKey, this.currentHash)) {
                            continue;
                        }
                    }
                    catch (EcmaScriptException v1) {}
                    return true;
                }
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = this.currentKey;
                this.currentKey = null;
                return string;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 1() {
            this.specialProperties = ESRowSet.this.getSpecialPropertyNames();
            this.props = ESRowSet.this.getProperties();
            this.inside = false;
        }
    }
}

