/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Interpreter.Evaluator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

class ESFile
extends ESObject {
    File file;
    Object readerWriter;
    boolean atEOF = false;
    String lastLine;
    Throwable lastError;

    ESFile(ESObject eSObject, Evaluator evaluator, String string) {
        super(eSObject, evaluator);
        this.file = new File(string);
    }

    ESFile(ESObject eSObject, Evaluator evaluator, String string, String string2) {
        super(eSObject, evaluator);
        this.file = new File(string, string2);
    }

    protected ESFile(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator);
    }

    public String getESClassName() {
        return "File";
    }

    public String toString() {
        if (this.file == null) {
            return "<null>";
        }
        return this.file.toString();
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + (this.file == null ? "null" : this.file.toString()) + "]";
    }

    protected void setError(Throwable throwable) {
        this.lastError = throwable;
    }

    public boolean exists() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    public boolean open() {
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("File already open"));
            return false;
        }
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        try {
            this.readerWriter = this.file.exists() ? new BufferedReader(new FileReader(this.file)) : new PrintWriter(new FileWriter(this.file));
            return true;
        }
        catch (IOException iOException) {
            this.setError(iOException);
            return false;
        }
    }

    public boolean isOpened() {
        return this.readerWriter != null;
    }

    public boolean close() {
        if (this.readerWriter == null) {
            return false;
        }
        try {
            if (this.readerWriter instanceof Reader) {
                ((Reader)this.readerWriter).close();
            } else {
                ((Writer)this.readerWriter).close();
            }
            this.readerWriter = null;
            return true;
        }
        catch (IOException iOException) {
            this.setError(iOException);
            this.readerWriter = null;
            return false;
        }
    }

    public boolean write(boolean bl, ESValue[] eSValueArray) {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return false;
        }
        if (!(this.readerWriter instanceof PrintWriter)) {
            this.setError(new IllegalStateException("File not opened for writing"));
            return false;
        }
        PrintWriter printWriter = (PrintWriter)this.readerWriter;
        int n = 0;
        while (n < eSValueArray.length) {
            printWriter.print(eSValueArray[n].toString());
            ++n;
        }
        if (bl) {
            printWriter.println();
        }
        return true;
    }

    public String readln() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return null;
        }
        if (!(this.readerWriter instanceof BufferedReader)) {
            this.setError(new IllegalStateException("File not opened for reading"));
            return null;
        }
        if (this.atEOF) {
            this.setError(new EOFException());
            return null;
        }
        if (this.lastLine != null) {
            String string = this.lastLine;
            this.lastLine = null;
            return string;
        }
        BufferedReader bufferedReader = (BufferedReader)this.readerWriter;
        try {
            String string = bufferedReader.readLine();
            if (string == null) {
                this.atEOF = true;
                this.setError(new EOFException());
            }
            return string;
        }
        catch (IOException iOException) {
            this.setError(iOException);
            return null;
        }
    }

    public boolean eof() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return true;
        }
        if (!(this.readerWriter instanceof BufferedReader)) {
            this.setError(new IllegalStateException("File not opened for read"));
            return true;
        }
        if (this.atEOF) {
            return true;
        }
        if (this.lastLine != null) {
            return false;
        }
        BufferedReader bufferedReader = (BufferedReader)this.readerWriter;
        try {
            this.lastLine = bufferedReader.readLine();
            if (this.lastLine == null) {
                this.atEOF = true;
            }
            return this.atEOF;
        }
        catch (IOException iOException) {
            this.setError(iOException);
            return true;
        }
    }

    public boolean isFile() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.isFile();
    }

    public boolean isDirectory() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.isDirectory();
    }

    public boolean flush() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return false;
        }
        if (this.readerWriter instanceof Writer) {
            try {
                ((Writer)this.readerWriter).flush();
            }
            catch (IOException iOException) {
                this.setError(iOException);
                return false;
            }
        } else {
            this.setError(new IllegalStateException("File not opened for write"));
            return false;
        }
        return true;
    }

    public long getLength() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return -1L;
        }
        return this.file.length();
    }

    public long lastModified() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return 0L;
        }
        return this.file.lastModified();
    }

    public String error() {
        if (this.lastError == null) {
            return "";
        }
        String string = this.lastError.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return String.valueOf(string) + ": " + this.lastError.getMessage();
    }

    public void clearError() {
        this.lastError = null;
    }

    public boolean remove() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("An openened file cannot be removed"));
            return false;
        }
        return this.file.delete();
    }

    public boolean renameTo(ESFile eSFile) {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized source File object"));
            return false;
        }
        if (eSFile.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized target File object"));
            return false;
        }
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("An openened file cannot be renamed"));
            return false;
        }
        if (eSFile.readerWriter != null) {
            this.setError(new IllegalStateException("You cannot rename to an openened file"));
            return false;
        }
        return this.file.renameTo(eSFile.file);
    }

    public boolean canRead() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.canRead();
    }

    public boolean canWrite() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.canWrite();
    }

    public String getParent() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String string = this.file.getParent();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getName() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String string = this.file.getName();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getPath() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String string = this.file.getPath();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getAbsolutePath() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String string = this.file.getAbsolutePath();
        if (string == null) {
            return "";
        }
        return string;
    }

    public boolean isAbsolute() {
        if (this.file == null) {
            return false;
        }
        return this.file.isAbsolute();
    }

    public boolean mkdir() {
        if (this.file == null) {
            return false;
        }
        if (this.readerWriter != null) {
            return false;
        }
        return this.file.mkdirs();
    }

    public String[] list() {
        if (this.file == null) {
            return null;
        }
        if (this.readerWriter != null) {
            return null;
        }
        if (!this.file.isDirectory()) {
            return null;
        }
        return this.file.list();
    }

    public String readAll() {
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("File already open"));
            return null;
        }
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return null;
        }
        try {
            String string;
            if (!this.file.exists()) {
                this.setError(new IllegalStateException("File does not exist"));
                return null;
            }
            this.readerWriter = new BufferedReader(new FileReader(this.file));
            if (!this.file.isFile()) {
                this.setError(new IllegalStateException("File is not a regular file"));
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer((int)((double)this.file.length() * 1.1));
            BufferedReader bufferedReader = (BufferedReader)this.readerWriter;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            ((Reader)this.readerWriter).close();
            this.readerWriter = null;
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            this.readerWriter = null;
            this.setError(iOException);
            return null;
        }
    }
}

