/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Extensions.BasicIOInterface;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;
import FESI.swinggui.SwingConfirmationBox;
import FESI.swinggui.SwingMessageBox;
import FESI.swinggui.SwingPromptBox;
import java.io.File;

public class BasicIOs
extends Extension
implements BasicIOInterface {
    private Evaluator evaluator;
    private ESObject document;
    private ESObject window;

    public ESObject getDocument() {
        return this.document;
    }

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        this.document = ObjectObject.createObject(evaluator);
        this.window = ObjectObject.createObject(evaluator);
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        globalObject.putHiddenProperty("document", this.document);
        this.document.putHiddenProperty("write", new GlobalObjectWrite("write", evaluator, functionPrototype));
        this.document.putHiddenProperty("writeln", new GlobalObjectWriteln("writeln", evaluator, functionPrototype));
        this.document.putHiddenProperty("open", new GlobalObjectNoop("open", evaluator, functionPrototype));
        this.document.putHiddenProperty("close", new GlobalObjectNoop("close", evaluator, functionPrototype));
        this.document.putHiddenProperty("URL", new ESString("file://<unknown>"));
        globalObject.putHiddenProperty("window", this.window);
        this.window.putHiddenProperty("alert", new GlobalObjectAlert("alert", evaluator, functionPrototype));
        this.window.putHiddenProperty("prompt", new GlobalObjectPrompt("prompt", evaluator, functionPrototype));
        this.window.putHiddenProperty("confirm", new GlobalObjectConfirm("confirm", evaluator, functionPrototype));
        globalObject.putHiddenProperty("write", new GlobalObjectWrite("write", evaluator, functionPrototype));
        globalObject.putHiddenProperty("writeln", new GlobalObjectWriteln("writeln", evaluator, functionPrototype));
        globalObject.putHiddenProperty("alert", new GlobalObjectAlert("alert", evaluator, functionPrototype));
        globalObject.putHiddenProperty("prompt", new GlobalObjectPrompt("prompt", evaluator, functionPrototype));
        globalObject.putHiddenProperty("confirm", new GlobalObjectConfirm("confirm", evaluator, functionPrototype));
        globalObject.putHiddenProperty("exit", new GlobalObjectExit("exit", evaluator, functionPrototype));
        globalObject.putHiddenProperty("load", new GlobalObjectLoad("load", evaluator, functionPrototype));
    }

    class GlobalObjectWrite
    extends BuiltinFunctionObject {
        GlobalObjectWrite(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            int n = 0;
            while (n < eSValueArray.length) {
                System.out.print(eSValueArray[n].toString());
                ++n;
            }
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectWriteln
    extends BuiltinFunctionObject {
        GlobalObjectWriteln(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            int n = 0;
            while (n < eSValueArray.length) {
                System.out.print(eSValueArray[n].toString());
                ++n;
            }
            System.out.println();
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectAlert
    extends BuiltinFunctionObject {
        GlobalObjectAlert(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < eSValueArray.length) {
                stringBuffer.append(eSValueArray[n].toString());
                ++n;
            }
            SwingMessageBox swingMessageBox = new SwingMessageBox("EcmaScript Alert", stringBuffer.toString());
            swingMessageBox.waitOK();
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectPrompt
    extends BuiltinFunctionObject {
        GlobalObjectPrompt(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            String string = "";
            String string2 = "";
            if (eSValueArray.length > 0) {
                string = eSValueArray[0].toString();
            }
            if (eSValueArray.length > 1) {
                string2 = eSValueArray[1].toString();
            }
            SwingPromptBox swingPromptBox = new SwingPromptBox("EcmaScript promt", string, string2);
            return new ESString(swingPromptBox.waitResponse());
        }
    }

    class GlobalObjectConfirm
    extends BuiltinFunctionObject {
        GlobalObjectConfirm(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < eSValueArray.length) {
                stringBuffer.append(eSValueArray[n].toString());
                ++n;
            }
            SwingConfirmationBox swingConfirmationBox = new SwingConfirmationBox("EcmaScript Confirm", stringBuffer.toString());
            boolean bl = swingConfirmationBox.waitYesOrNo();
            return ESBoolean.makeBoolean(bl);
        }
    }

    class GlobalObjectExit
    extends BuiltinFunctionObject {
        GlobalObjectExit(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            int n = 0;
            if (eSValueArray.length > 0) {
                n = eSValueArray[0].toInt32();
            }
            System.exit(n);
            return null;
        }
    }

    class GlobalObjectNoop
    extends BuiltinFunctionObject {
        GlobalObjectNoop(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectLoad
    extends BuiltinFunctionObject {
        GlobalObjectLoad(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIOs.this = BasicIOs.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESValue eSValue;
            String string = null;
            if (eSValueArray.length > 0) {
                string = eSValueArray[0].toString();
            }
            if (string == null) {
                throw new EcmaScriptException("Missing file name for load");
            }
            new File(string);
            try {
                eSValue = this.evaluator.evaluateLoadModule(string);
            }
            catch (EcmaScriptParseException ecmaScriptParseException) {
                ecmaScriptParseException.setNeverIncomplete();
                throw ecmaScriptParseException;
            }
            return eSValue;
        }
    }
}

