/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.JSGlobalWrapper;
import FESI.Data.JSWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.UserEvaluationSource;
import FESI.jslib.JSException;
import FESI.jslib.JSFunction;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSObject;
import java.io.Reader;

public class JSWrapper
implements JSObject {
    protected Evaluator evaluator;
    protected ESObject object;

    public JSWrapper(ESObject eSObject, Evaluator evaluator) {
        this.object = eSObject;
        this.evaluator = evaluator;
    }

    public ESObject getESObject() {
        return this.object;
    }

    public JSGlobalObject getGlobalObject() {
        return new JSGlobalWrapper(this.evaluator.getGlobalObject(), this.evaluator);
    }

    public Object call(String string, Object[] objectArray) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue eSValue = this.object.getProperty(string, string.hashCode());
                ESValue[] eSValueArray = null;
                if (objectArray == null) {
                    eSValueArray = new ESValue[]{};
                } else {
                    eSValueArray = new ESValue[objectArray.length];
                    int n = 0;
                    while (n < objectArray.length) {
                        eSValueArray[n] = ESLoader.normalizeValue(objectArray[n], this.evaluator);
                        ++n;
                    }
                }
                ESValue eSValue2 = eSValue.callFunction(this.object, eSValueArray);
                object = eSValue2.toJavaObject();
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public Object eval(String string) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue eSValue = this.evaluator.evaluate(string, this.object, false);
                if (eSValue != null) {
                    object = eSValue.toJavaObject();
                }
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public Object eval(Reader reader, String string) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                UserEvaluationSource userEvaluationSource = string == null ? new UserEvaluationSource("<Anonymous stream>", null) : new UserEvaluationSource(string, null);
                ESValue eSValue = this.evaluator.evaluate(reader, this.object, userEvaluationSource, false);
                if (eSValue != null) {
                    object = eSValue.toJavaObject();
                }
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public Object evalAsFunction(Reader reader, String string) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                UserEvaluationSource userEvaluationSource = string == null ? new UserEvaluationSource("<Anonymous stream>", null) : new UserEvaluationSource(string, null);
                ESValue eSValue = this.evaluator.evaluate(reader, this.object, userEvaluationSource, true);
                if (eSValue != null) {
                    object = eSValue.toJavaObject();
                }
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public Object evalAsFunction(String string) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue eSValue = this.evaluator.evaluate(string, this.object, true);
                if (eSValue != null) {
                    object = eSValue.toJavaObject();
                }
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public Object evalAsFunction(Reader reader, String string, String[] stringArray, Object[] objectArray) throws JSException {
        throw new ProgrammingError("NOT IMPLEMENTED");
    }

    public Object evalAsFunction(String string, String[] stringArray, Object[] objectArray) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                int n;
                int n2 = stringArray == null ? 0 : stringArray.length;
                int n3 = n = objectArray == null ? 0 : stringArray.length;
                if (n2 != n) {
                    throw new JSException("argument names and values arrays must have the same length, now: " + n2 + ", " + n);
                }
                ESValue[] eSValueArray = new ESValue[n2 + 1];
                int n4 = 0;
                while (n4 < n2) {
                    eSValueArray[n4] = new ESString(stringArray[n4]);
                    ++n4;
                }
                eSValueArray[n2] = new ESString(string);
                ESObject eSObject = this.evaluator.getFunctionObject();
                ESObject eSObject2 = eSObject.doConstruct(null, eSValueArray);
                eSValueArray = new ESValue[n2];
                int n5 = 0;
                while (n5 < n2) {
                    eSValueArray[n5] = ESLoader.normalizeValue(objectArray[n5], this.evaluator);
                    ++n5;
                }
                ESValue eSValue = eSObject2.callFunction(this.object, eSValueArray);
                if (eSValue != null) {
                    object = eSValue.toJavaObject();
                }
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public Object getMember(String string) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue eSValue = this.object.getProperty(string, string.hashCode());
                object = eSValue.toJavaObject();
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public Object getSlot(int n) throws JSException {
        Object object = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue eSValue = this.object.getProperty(n);
                object = eSValue.toJavaObject();
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
        }
        return object;
    }

    public void removeMember(String string) throws JSException {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                this.object.deleteProperty(string, string.hashCode());
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
            return;
        }
    }

    public void setMember(String string, Object object) throws JSException {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue eSValue = ESLoader.normalizeValue(object, this.evaluator);
                this.object.putProperty(string, eSValue, string.hashCode());
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
            return;
        }
    }

    public void setSlot(int n, Object object) throws JSException {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue eSValue = ESLoader.normalizeValue(object, this.evaluator);
                this.object.putProperty(n, eSValue);
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
            }
            return;
        }
    }

    public static JSGlobalObject makeEvaluator() throws JSException {
        Evaluator evaluator = new Evaluator();
        GlobalObject globalObject = evaluator.getGlobalObject();
        return new JSGlobalWrapper(globalObject, evaluator);
    }

    public static JSGlobalObject makeEvaluator(String[] stringArray) throws JSException {
        Evaluator evaluator = new Evaluator();
        GlobalObject globalObject = evaluator.getGlobalObject();
        try {
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    Object object = evaluator.addMandatoryExtension(stringArray[n]);
                    if (object == null) {
                        throw new JSException("Could not load extension '" + stringArray[n] + "'");
                    }
                    ++n;
                }
            }
            return new JSGlobalWrapper(globalObject, evaluator);
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new JSException(ecmaScriptException.getMessage(), ecmaScriptException);
        }
    }

    public static ESObject wrapJSFunction(Evaluator evaluator, JSFunction jSFunction) {
        Evaluator evaluator2 = evaluator;
        synchronized (evaluator2) {
            JSFunction jSFunction2 = jSFunction;
            1.WrapedJSFunction wrapedJSFunction = new 1.WrapedJSFunction(jSFunction2, jSFunction.toString(), evaluator, (FunctionPrototype)evaluator.getFunctionPrototype());
            Object var4_5 = null;
            return wrapedJSFunction;
        }
    }

    public String toString() {
        return this.object.toString();
    }
}

