/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;
import java.beans.Beans;
import java.io.IOException;

public class ESBeans
extends ESLoader {
    public ESBeans(Evaluator evaluator) {
        super(evaluator);
    }

    public ESBeans(String string, ESBeans eSBeans, LocalClassLoader localClassLoader, Evaluator evaluator) {
        super(string, eSBeans, localClassLoader, evaluator);
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Beans");
    }

    public String getESClassName() {
        return "Beans";
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        ESValue eSValue = this.properties.get(string, n);
        if (eSValue == null) {
            this.buildPrefix();
            eSValue = new ESBeans(string, this, this.classLoader, this.evaluator);
            this.properties.put(string, n, false, false, eSValue);
        }
        return eSValue;
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        if (this.previousPackage == null && this.classLoader == null) {
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("Missing class directory or jar file name");
            }
            String string = eSValueArray[0].toString();
            LocalClassLoader localClassLoader = LocalClassLoader.makeLocalClassLoader(string);
            return new ESBeans(null, null, localClassLoader, this.evaluator);
        }
        throw new EcmaScriptException("Java class not found: '" + this.buildPrefix() + "'");
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        String string = this.buildPrefix();
        ESWrapper eSWrapper = null;
        if (string == null) {
            throw new EcmaScriptException("cannot create beans without a package name");
        }
        try {
            Object object = Beans.instantiate(this.classLoader, string);
            if (ESLoader.debugJavaAccess) {
                System.out.println(" ** Bean '" + string + "' created");
            }
            eSWrapper = new ESWrapper(object, this.evaluator, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new EcmaScriptException("Bean '" + string + "' not found: " + classNotFoundException);
        }
        catch (IOException iOException) {
            throw new EcmaScriptException("IOexception loading bean '" + string + "': " + iOException);
        }
        return eSWrapper;
    }

    public String getTypeofString() {
        return "JavaBeans";
    }

    public String toDetailString() {
        return "ES:<" + this.getESClassName() + ":'" + this.buildPrefix() + "'" + (this.classLoader == null ? "" : ",@" + this.classLoader) + ">";
    }
}

