/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESLoader;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ESArrayWrapper
extends ESObject {
    protected Object javaArray;

    public ESArrayWrapper(Object object, Evaluator evaluator) {
        super(null, evaluator);
        this.javaArray = object;
        if (!object.getClass().isArray()) {
            throw new ProgrammingError("Array wrapper used on non array object");
        }
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Array Wrapper");
    }

    public String getESClassName() {
        return "Java Array";
    }

    public int getTypeOf() {
        return 6;
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (string.equals("length")) {
            int n2 = (int)((ESPrimitive)eSValue).doubleValue();
            if (n2 < 0) {
                throw new EcmaScriptException("Invalid length value: " + eSValue);
            }
            throw new EcmaScriptException("length of Java Arrays is immutable");
        }
        int n3 = -1;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n3 < 0) {
            throw new EcmaScriptException("Java Arrays accept only index properties");
        }
        this.putProperty(n3, eSValue);
    }

    public void putProperty(int n, ESValue eSValue) throws EcmaScriptException {
        int n2 = Array.getLength(this.javaArray);
        if (n >= n2 || n < 0) {
            throw new EcmaScriptException("Index " + n + " outside of Java Arrays size of " + n2);
        }
        Object object = eSValue.toJavaObject();
        try {
            Array.set(this.javaArray, n, object);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "null";
            if (object != null) {
                string = ESLoader.typeName(object.getClass());
            }
            throw new EcmaScriptException("Cannot store a " + string + " in the java array " + ESLoader.typeName(this.javaArray.getClass()));
        }
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        if (string.equals("length")) {
            return new ESNumber(Array.getLength(this.javaArray));
        }
        if (scopeChain == null) {
            throw new EcmaScriptException("global variable '" + string + "' does not have a value");
        }
        return scopeChain.getValue(string, n);
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        if (string.equals("length")) {
            return new ESNumber(Array.getLength(this.javaArray));
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n2 < 0) {
            throw new EcmaScriptException("Java Arrays accept only index properties");
        }
        return this.getProperty(n2);
    }

    public ESValue getProperty(int n) throws EcmaScriptException {
        Object object = null;
        int n2 = Array.getLength(this.javaArray);
        if (n >= n2 || n < 0) {
            throw new EcmaScriptException("Java Array index " + n + " is out of range " + n2);
        }
        object = Array.get(this.javaArray, n);
        return ESLoader.normalizeValue(object, this.evaluator);
    }

    public boolean hasProperty(String string, int n) throws EcmaScriptException {
        if (string.equals("length")) {
            return true;
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n2 < 0) {
            return false;
        }
        return n2 >= 0 && n2 < Array.getLength(this.javaArray);
    }

    public Enumeration getProperties() {
        return new 1();
    }

    public Enumeration getAllProperties() {
        return new 2();
    }

    public String[] getSpecialPropertyNames() {
        String[] stringArray = new String[]{"length"};
        return stringArray;
    }

    public boolean isHiddenProperty(String string, int n) {
        return false;
    }

    public void putHiddenProperty(String string, ESValue eSValue) throws EcmaScriptException {
        throw new ProgrammingError("Cannot put hidden property in " + this);
    }

    public boolean deleteProperty(String string, int n) throws EcmaScriptException {
        return !this.hasProperty(string, n);
    }

    public ESValue getDefaultValue(int n) throws EcmaScriptException {
        if (n == 5) {
            return new ESString(this.javaArray.toString());
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + n);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }

    public double doubleValue() {
        double d = Double.NaN;
        return d;
    }

    public boolean booleanValue() {
        return true;
    }

    public String toString() {
        if (this.javaArray == null) {
            return "<?Array Wrapper to null?>";
        }
        return "[object JavaArray]";
    }

    public Object toJavaObject() {
        return this.javaArray;
    }

    public String toDetailString() {
        return "ES:[" + this.getESClassName() + ":" + this.javaArray.toString() + "]";
    }

    private final class 1
    implements Enumeration {
        int nextIndex;
        int length;

        public boolean hasMoreElements() {
            while (this.nextIndex < this.length && Array.get(ESArrayWrapper.this.javaArray, this.nextIndex) == null) {
                ++this.nextIndex;
            }
            return this.nextIndex < this.length;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                return new ESNumber(this.nextIndex++);
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 1() {
            this.length = Array.getLength(ESArrayWrapper.this.javaArray);
        }
    }

    private final class 2
    implements Enumeration {
        String[] specialProperties;
        int specialEnumerator;
        Enumeration props;
        String currentKey;
        int currentHash;
        int nextIndex;
        int length;

        public boolean hasMoreElements() {
            if (this.currentKey != null) {
                return true;
            }
            if (this.nextIndex < this.length) {
                while (this.nextIndex < this.length && Array.get(ESArrayWrapper.this.javaArray, this.nextIndex) == null) {
                    ++this.nextIndex;
                }
                if (this.nextIndex < this.length) {
                    this.currentKey = Integer.toString(this.nextIndex);
                    this.currentHash = this.currentKey.hashCode();
                    ++this.nextIndex;
                    return true;
                }
            }
            if (this.specialEnumerator < this.specialProperties.length) {
                this.currentKey = this.specialProperties[this.specialEnumerator];
                this.currentHash = this.currentKey.hashCode();
                ++this.specialEnumerator;
                return true;
            }
            if (this.props.hasMoreElements()) {
                this.currentKey = (String)this.props.nextElement();
                this.currentHash = this.currentKey.hashCode();
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = this.currentKey;
                this.currentKey = null;
                return string;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 2() {
            this.specialProperties = ESArrayWrapper.this.getSpecialPropertyNames();
            this.props = ESArrayWrapper.this.properties.keys();
            this.length = Array.getLength(ESArrayWrapper.this.javaArray);
        }
    }
}

