/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.samples;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.wda.gpss.GeneralSocklet;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.samples.ContoroledChatSample;

public class ContoroledChatSampleRoomsAdministrator
extends GeneralSocklet {
    private LinkedList roomsList = new LinkedList();
    private Hashtable roomsInfo = new Hashtable();

    protected void init(List linkedSocklets) {
    }

    public int addToRoom(String room) {
        ChatroomInfo info = null;
        if (!this.roomsInfo.containsKey(room)) {
            info = new ChatroomInfo(room);
            this.roomsInfo.put(room, info);
            this.roomsList.add(info);
        } else {
            info = (ChatroomInfo)this.roomsInfo.get(room);
        }
        StringBuffer stringBuffer = new StringBuffer("<room name=\"").append(room).append("\" members=\"");
        ChatroomInfo chatroomInfo = info;
        int n = chatroomInfo.members + 1;
        chatroomInfo.members = n;
        this.sendToAllClients(stringBuffer.append(n).append("\" />").toString());
        return info.members;
    }

    public int removeFromRoom(String room) {
        if (!this.roomsInfo.containsKey(room)) {
            return -1;
        }
        ChatroomInfo info = (ChatroomInfo)this.roomsInfo.get(room);
        StringBuffer stringBuffer = new StringBuffer("<room name=\"").append(room).append("\" members=\"");
        ChatroomInfo chatroomInfo = info;
        int n = chatroomInfo.members - 1;
        chatroomInfo.members = n;
        this.sendToAllClients(stringBuffer.append(n).append("\" />").toString());
        return info.members;
    }

    public boolean checkConnection(SocketProcessor client) {
        client.send("+OK welcome");
        return true;
    }

    public void preRemoveClient(SocketProcessor client) {
    }

    public boolean doCommand(SocketProcessor client, String command) {
        StringBuffer ret = new StringBuffer("<rooms>");
        Iterator rooms = this.roomsList.iterator();
        while (rooms.hasNext()) {
            ChatroomInfo room = (ChatroomInfo)rooms.next();
            ret.append("<room name=\"");
            ret.append(room.name);
            ret.append("\" members=\"");
            ret.append(room.members);
            ret.append("\" />");
        }
        ret.append("</rooms>");
        client.send(ret.toString());
        return true;
    }

    public boolean allowAccessFromOtherSocklet(Socklet from) {
        if (!(from instanceof ContoroledChatSample)) {
            return false;
        }
        return this.getName().equals(String.valueOf(from.getName()) + "_Admin");
    }

    private class ChatroomInfo {
        private String name;
        private int members;

        ChatroomInfo(String name) {
            this.name = name;
            this.members = 0;
        }
    }
}

