package jp.wda.gpss.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

/**
 *	\Pbg҂CT[oINX
 *
 * @version	1.00007	2003/05/10
 * @since		1.00002	2003/04/30
 * @author	amoi
 */
public class SystemCommander {
	public static void main(String[] args){
		if(args.length < 2){ return; }
		
		System.out.println("GPSS terminating!");
		int portNum;
		// |[gԍ擾
		try { portNum = Integer.parseInt(args[0]); }
		catch(Throwable e){
			e.printStackTrace();
			portNum = 0;
			System.out.println("Please port number...");
		}
		
		// Mp
		char c[] = new char[1];
		
		Socket socket = null;
		BufferedReader reader = null;
		PrintWriter writer = null;
		try{
			socket = new Socket("localhost", portNum);
			
			reader = new BufferedReader( new InputStreamReader(  socket.getInputStream(),  "SJIS"));
			writer = new PrintWriter(    new OutputStreamWriter( socket.getOutputStream(), "SJIS"), true);
			
			writer.print(Main.SYSTEM_APPLICATION_NAME + ":::" + "\0");
			if(writer.checkError()){ return; }
			
			// T[oM
			int counter = 0;
			String nextcommand = null;
			while( reader.read(c, 0, 1) != -1 ){
				StringBuffer sb = new StringBuffer(4096);
				
				while(c[0] != '\0'){
					sb.append(c[0]);
					reader.read(c, 0 ,1);
				}
				
				System.out.println(sb.toString());
				switch(counter){
					case 0: nextcommand = checkInitialMessage(sb.toString(), args[1]); break;
					default : nextcommand = null;
				}
				
				if(nextcommand == null){ return; }
				counter++;
				
				writer.print(nextcommand + "\0");
				if(writer.checkError()){ return; }
			}
		}catch(Throwable e){ ; }finally{
			// PrintWriter
			if(writer != null)      { writer.close(); }
			
			//BufferdReader
			try { if(reader != null){ reader.close(); }    }
			catch(IOException e){
			}
			
			// \Pbg
			try { if(socket != null){ socket.close(); }}
			catch(IOException e){
			}
			
			writer = null;
			reader = null;
			socket = null;
		}
	}
	
	public static String checkInitialMessage(String message, String command){
		if(message.charAt(0) == '-'){
			return null;
		}
		return command;
	}
}
