package jp.wda.gpss.system;

import jp.wda.gpss.*;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SocketProcessor;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Function;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.FileInputStream;
import java.util.List;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 * JavaScriptSockletNX<BR>
 * ̃NX́AJavaScriptɂT[o[TChXNveBO̎łB<BR>
 * ̃NX́AMozilla RhinoɂɂȂĂ܂B<BR>
 * <br>
 * ȉ4̊֐XNvgt@Cɒ`邷邱ƂɂāA
 * Socklet̓rIeՂɐݒ肷邱Ƃł܂B<BR><BR>
 * function onInit() AvP[V`܂B<BR>
 * function onConnect(client) NCAg̐ڑ̃`FbNя`܂B<BR>
 * function onDisconnect(client) NCAgڑؒfꍇɎs鏈`܂B<BR>
 * function onCommand(client,command) NCAgf[^MꍇɎs鏈`܂B<BR>
 * <BR>
 * XNvgt@CscriptsfBNgɊgq".rjs"ŕۑ邱ƂɂA
 * T[o[NɎIɓǂݍ܂܂B<BR>
 *
 * @author iEREj RTquCoolEE
 */
public class RhinoJsSocklet extends ScriptSocklet {
	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	private Context cx;
	private Scriptable scope;
	private String encoding;
	private String debug;
	
	// I[@[Ch /////////////////////////////////////////////////////////////////
	//                                                               Over Ride Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ECMAScriptSocklet邽߂̃\bhB<BR>
	 * ̃\bh͏ݒt@CŎw肳ꂽXNvgt@Cǂݍ݁A
	 * XNvg֐onInit()Ăяo܂B<BR>
	 * ̃\bh́A\PbgҎ󂯃T[őNɁA1񂾂Ă΂܂B<BR>
	 * ܂XNvgɑgݍ݃IuWFNgapplicationݒ肵܂B
	 * applicationIuWFNg𗘗pāAXNvgSocklet APIɃANZX邱Ƃ\łB<BR>
	 * ECMAScriptSocklet̏ƂKvȏꍇ́AXNvg֐onInit()ɋLqĂB<BR>
	 */
	public void init(List linkedSocklets) {
		//C^[v^̐
		try{
			cx = Context.enter(null);
			//scope = cx.initStandardObjects(null);
			scope = new ImporterTopLevel(cx); //importPackage,importClassT|[g
		}catch(Exception e){
			e.printStackTrace();
		}
		
		//GR[fBOݒ
		encoding = getInitParam("sourceEncoding");
		if(encoding==null){
			encoding="UTF-8";
		}
		
		//fobOxݒ
		debug = getInitParam("debug");
		if(debug==null){
			debug="normal";
		}
		
		//\[Xt@Cݒ
		String fileName = getInitParam("source");
		String script = "";
		if(fileName!=null){
			try{
				//\[Xt@C̓ǂݍ
				script = loadFile(fileName, encoding);
				System.out.println("  XNvg'" + fileName + "'łB");
			}catch(Exception e){
				System.out.println("  XNvg'" + fileName + "'ǂݍ߂܂B");
			}
		}
		
		try{
			//gݍ݃IuWFNg
			scope.put("application", scope, this);
			
			//XNvg
			cx.evaluateString(scope, script, fileName, 1, null);
			
			//\bh``FbN
			if (!(get("onInit") instanceof Function)) {
				System.out.println("      onInit`łB");
				cx.evaluateString(scope, "function onInit(){}", fileName, 1, null);
			}
			if(!(get("onConnect") instanceof Function)){
				System.out.println("      onConnect`łB");
				cx.evaluateString(scope, "function onConnect(client){client.send(\"+OK\");return true;}", fileName, 1, null);
			}
			if(!(get("onDisconnect") instanceof Function)){
				System.out.println("      onDisconnect`łB");
				cx.evaluateString(scope, "function onDisconnect(client){}", fileName, 1, null);
			}
			if(!(get("onCommand") instanceof Function)){
				System.out.println("      onCommand`łB");
				cx.evaluateString(scope, "function onCommand(client,command){application.sendToAllClients(command);return true;}", fileName, 1, null);
			}
			if(!(get("onDestroy") instanceof Function)){
				//System.out.println("      onDestroy`łB");
				cx.evaluateString(scope, "function onDestroy(){}", fileName, 1, null);
			}
			
			if(!(get("onSockletLink") instanceof Function)){
				//System.out.println("      onSockletLink`łB");
				cx.evaluateString(scope, "function onSockletLink(from){return false;}", fileName, 1, null);
			}
			
			//onIniťĂяo
			call("onInit", new Object[] {linkedSocklets});
			Context.exit();
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
			Context.exit();
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * ڑpR}hMANCAǧs߂Ƀ\bhB<BR>
	 * ̃\bh́AT[oVNCAg̐ڑmF_ŁA
	 * ̃NCAg邽߂ɌĂ΂܂B<br>
	 * ̃\bh̓XNvg֐onConnect(client)Ăяo܂B<BR><BR>
	 * ڑNCAgɑ΂ԏ߂Ɉ񂾂Ă΂܂B<BR>
	 * 
	 * SocketProcessor clientIuWFNg̃\bhgpāA
	 * ̐ڑK؂ł邩A
	 * ܂NCAgɕKvȏ^ĂB<BR>
	 * 
	 * ̃NCAgK؂łȂƔfꂽꍇ́AUԂĂB
	 * ɃNCAg\PbgI܂B<BR>
	 * ̑̏ꍇ́A^ԂĂB^ԂƁANCAg\Pbgp܂B<BR>
	 * 
	 * @param client ڑ݂ĂNCAg
	 * @return Aؒfꍇ͋UB
	 * @see jp.wda.gpss.SocketProcessor
	 */
	public boolean checkConnection(SocketProcessor client) {
		try{
			Context.enter();
			Object result = call("onConnect", new Object[] {client});
			Context.exit();
			return("true".equals(result.toString()));
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		Context.exit();
		return false;
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAg폜OɌĂяo郁\bhB<BR>
	 * ڑ̃NCAgؒfÃAvP[V珜O钼OɌĂ΂܂B<BR>
	 * ̃\bh̓XNvg֐onDisconnect(client)Ăяo܂B<BR><BR>
	 * ڑNCAgɑ΂AIOɈ񂾂Ă΂܂B<BR>
	 * ̐ڑNCAgցÃNCAgؒfꂽƂʒm悤ȏꍇ́A
	 * XNvg֐onDisconnect(client)ŋLqĂB<BR>
	 *
	 * @param client ꂩ폜NCAg
	 */
	public void preRemoveClient(SocketProcessor client) {
		try{
			Context.enter();
			call("onDisconnect", new Object[] {client});
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		Context.exit();
	}

	/* ***********************************************************************>> */;
	/**
	 * R}h邽߂̃\bhB<BR>
	 * ڑ̃NCAgAR}hMĂƂɌĂ΂܂B
	 * ̃\bh̓XNvg֐onCommand(client, command)Ăяo܂B<BR><BR>
	 * XNvg֐onCommand(client, command)ŁA
	 * NCAg瑗ĂR}hĂB<BR>
	 * NCAg̐ڑɉxłĂ΂܂B<BR>
	 * <BR>
	 * R}h𑗂Ă\Pbgɑ΂āAbZ[W𑗐Mꍇ́Aȉ̃\bhgpĂB<BR>
	 * <BR>
	 * client.send(<I>M郁bZ[W</I>);<BR>
	 * <BR>
	 * ڑ̑SNCAgփbZ[W𑗐Mꍇ́Aȉ̃\bhgpĂB<BR>
	 * <BR>
	 * application.sendToAllClients(<I>M郁bZ[W</I>); <BR>
	 * <BR>
	 * ܂ÃNCAgւ̂݃bZ[W𑗂肽ꍇ́A
	 * ȉ̃\bhgpĂB<BR>
	 * <BR>
	 * application.sendToClients(<I>M郁bZ[W</I>, <I>MNCAǧ</I>);<BR>
	 * <BR>
	 * \Pbgڑpꍇ̓XNvg֐onCommandŐ^ԂĂB<BR>
	 *
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @return R}hsɐꍇ͐^Asꍇ͋U
	 * 	UԂƒɃNCAg\PbgI܂B
	 */
	public boolean doCommand(SocketProcessor client, String command) {
		try{
			Context.enter();
			Object result = call("onCommand", new Object[] {client, command});
			Context.exit();
			return("true".equals(result.toString()));
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		Context.exit();
		return false;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * SockletT[rX~ۂɁAҎ󂯃CT[oɂČĂяo܂B<BR>
	 * Socklet̏IKvȏꍇ́AXNvg֐onDestroy()LqĂB
	 * 
	 * @see jp.wda.gpss.Socklet#destroy()
	 */
	public void destroy(){
		try{
			Context.enter();
			call("onDestroy", new Object[] {});
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		cx = null;
		scope = null;
		Context.exit();
	}
	
	/* ***********************************************************************>> */;
	/**
	 * Socklet̃ANZX邩ǂmF܂B
	 * ł́AɃANZX܂B
	 * SockletɂăANZXꍇ́AXNvg֐onSockletLink()`ĂB
	 * 
	 * ̐ڑꍇ́A^ԂĂB
	 * 
	 * @param from ڑ݂ĂSocklet
	 * @return Aڑꍇ͐^B
	 */
	public boolean allowAccessFromOtherSocklet(Socklet from){
		try{
			Context.enter();
			Object result = call("onSockletLink", new Object[] {from});
			Context.exit();
			return("true".equals(result.toString()));
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		Context.exit();
		return false;
	}
	
	// XNvgpJ\bh /////////////////////////////////////////////////////////
	//                                                Public Methods for ScriptSocklet //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * t@Cǂݍ݃XNvgƂĕ]Es郁\bhB<BR>
	 * XNvgĂяoƂŊOt@CC|[gāA
	 * p邱Ƃł܂B<br>
	 * 悭gOCu̓ǂݍ݂ɗpł܂B<BR>
	 * XNvǧĂяo application.importSource(fileName)ƂȂ܂B
	 *
	 * @param fileName OǂݍރXNvg\[Xt@C
	 * @return ǂݍ݁E]Esɐꍇ͐^Asꍇ͋U
	 */
	public boolean importSource(String fileName){
		String script = loadFile(fileName, encoding);
		try{
			cx.evaluateString(scope, script, fileName, 1, null);
			return true;
		}catch(Exception e){
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
			return false;
		}
	}
	
	/**
	 * OSockletǉz郁\bhB<BR>
	 * XNvg֐onInit()ĂяoƂŊOSockletz܂B
	 * gpꍇ͕KonInit()ĂяoĂB<BR>
	 * XNvǧĂяo application.addSocklet(links, sockletName, className)ƂȂ܂B
	 *
	 * @param links sockletzXg
	 * @param sockletName sockletz
	 * @param className sockletNX
	 * @return Ȃ
	 */
	public void addSocklet(List links, String sockletName, String className){
		SockletDeployInfo appinfo = this.copyInfo(sockletName, className);
		
		links.add(appinfo);
	}
	
	/**
	 * OScriptSockletǉz郁\bhB<BR>
	 * XNvg֐onInit()ĂяoƂŊOScriptSockletz܂B
	 * gpꍇ͕KonInit()ĂяoĂB<BR>
	 * XNvǧĂяo application.addScriptSocklet(links, sockletName, fileName)ƂȂ܂B
	 *
	 * @param links sockletzXg
	 * @param sockletName sockletz
	 * @param fileName script socklett@C
	 * @return Ȃ
	 */
	public void addScriptSocklet(List links, String sockletName, String fileName){
		SockletDeployInfo appinfo = this.copyInfo(sockletName, "jp.wda.gpss.system.RhinoJsSocklet");
		appinfo.setInitParam("source", fileName);
		
		links.add(appinfo);
	}
	
	/**
	 * XNvg֐Ăяo\bhB<BR>
	 * XNvǧĂяo application.call(functionName, args)ƂȂ܂B
	 *
	 * @param sockletName sockletz
	 * @param fileName script socklett@C
	 * @return ֐̎s
	 */
	public Object call(String functionName, Object[] args) {
		try{
			Object func = scope.get(functionName, scope);
			if (func instanceof Function) {
				return ((Function)func).call(cx, scope, scope, args);
			}
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		return null;
	}

	/**
	 * XNvgϐ擾郁\bhB<BR>
	 * XNvǧĂяo application.get(variableName)ƂȂ܂B
	 *
	 * @param sockletName sockletz
	 * @param fileName script socklett@C
	 * @return ֐̎s
	 */
	public Object get(String variableName) {
		try{
			return scope.get(variableName, scope);
		} catch (Exception e) {
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		return null;
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * t@CǂݍStringɊi[܂B<BR>
	 *
	 */
	private String loadFile(String fileName, String encoding){
		String result = "";
		try{
			BufferedReader fr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName), encoding));
			String inLine = fr.readLine();
			while(inLine != null){
				result = result + inLine + "\n";
				inLine = fr.readLine();
			}
			fr.close();			
		}catch(Exception e){
			if(debug.equals("stacktrace")){
				e.printStackTrace();
			}else{
				System.out.println(e);
			}
		}
		return result;
	}

}


