package jp.wda.gpss.samples;

import java.util.List;
import java.util.Map;

import jp.wda.gpss.GeneralSocklet;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.SockletDeployInfo;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o SockletTv
 * </B></I></FONT><BR>
 * SockletAg@\pāA󋵂mFł悤ɂChatpSockletTv
 *
 * @author	amoi
 */
public class ContoroledChatSample extends GeneralSocklet {
	// JtB[h ///////////////////////////////////////////////////////////////////
	//                                                            Public Static Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	public static final String ADMIN_FOTTER = "_Admin";
	public static final String INIT_ROOM_KEY = "room";
	public static final String P_INIT_ROOM_KEY = "p." + INIT_ROOM_KEY;
	
	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	public String adminSockletName = null;
	
	private ContoroledChatSampleRoomsAdministrator adminSocklet;
	
	// I[@[Ch /////////////////////////////////////////////////////////////////
	//                                                               Over Ride Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * BasicChat Socklet邽߂̃\bhB<BR>
	 * \PbgҎ󂯃T[őNɁA1񂾂Ă΂܂B<BR><BR>
	 * 
	 * ̃\bhł́AǗpSockletN܂B<BR>
	 *
	 * @see jp.wda.gpss.GeneralSocklet#init(List)
	 */
	protected void init(List linkedSocklets) {
		this.adminSockletName = this.getName() + ADMIN_FOTTER;
		
		SockletDeployInfo appinfo = 
			this.copyInfo(adminSockletName, "jp.wda.gpss.samples.ContoroledChatSampleRoomsAdministrator");
		
		// Rg[̃̕^CAEgԂ͖
		appinfo.setTimeout(0);
		
		linkedSocklets.add(appinfo);
	}
	
	/**
	 * ǉzꂽ(͂)ǗpSocklet\ߎ擾Ă܂B
	 */
	public void afterDeployedLinks(Map linkedSocklets){
		this.adminSocklet = (ContoroledChatSampleRoomsAdministrator)linkedSocklets.get(adminSockletName);
	}

	/* ***********************************************************************>> */;
	/**
	 * ڑpR}hMANCAǧs߂Ƀ\bhB<BR>
	 * ̃\bh́AT[oVNCAg̐ڑmF_ŁA
	 * ̃NCAg邽߂ɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 * 
	 * @param client ڑ݂ĂNCAg
	 * @return Aؒfꍇ͋UB
	 * 
	 * @see jp.wda.gpss.Socklet#checkConnection(jp.wda.gpss.SocketProcessor)
	 */
	public boolean checkConnection(SocketProcessor client) {
		String roomname = client.getInitParam(INIT_ROOM_KEY);
		
		// OC̃[UmF
		Boolean loginFailure = new Boolean(false);
		client.setAttribute("loginFailure", Boolean.FALSE);
		List cls = getClients("username==\"" + client.getUserName() + "\"&" + P_INIT_ROOM_KEY + "==\"" + roomname + "\"");
		if(cls.size() > 1){
			client.send("-Login failure user \"" + client.getUserName() + "\"");
			client.setAttribute("loginFailure", Boolean.TRUE);
			chatlog(roomname, client.getUserName(), "OCsłB");
			return false;
		}
		
		client.send("+OK welcome user \"" + client.getUserName() + "\"");
		sendToClients(client.getUserName() + "" + roomname + "ɓ܂", P_INIT_ROOM_KEY + "==\"" + roomname + "\"&username!=\"" + client.getUserName() + "\"");
		if(adminSocklet != null){
			int members = adminSocklet.addToRoom(roomname);
			if(members == 1){
				chatlog(roomname, client.getUserName(), "<<J݂܂>>");
			}else{
				chatlog(roomname, client.getUserName(), "<<܂>>");
			}
		}
		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAg폜OɌĂяo郁\bhB<BR>
	 * ڑ̃NCAgؒfÃAvP[V珜O钼OɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 *
	 * @param client ꂩ폜NCAg
	 * 
	 * @see jp.wda.gpss.Socklet#preRemoveClient(jp.wda.gpss.SocketProcessor)
	 */
	public void preRemoveClient(SocketProcessor client) {
		if(((Boolean)client.getAttribute("loginFailure")).booleanValue()){ return; }
		
		String roomname = client.getInitParam(INIT_ROOM_KEY);
		
		sendToClients(client.getUserName() + "" + roomname + "ގ܂", P_INIT_ROOM_KEY + "==\"" + roomname + "\"");
		if(adminSocklet != null){
			int members = adminSocklet.removeFromRoom(roomname);
			if(members == 0){
				chatlog(roomname, client.getUserName(), "<<܂>>");
			}else{
				chatlog(roomname, client.getUserName(), "<<ގ܂>>");
			}
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * R}h邽߂̃\bhB<BR>
	 * ڑ̃NCAgAR}hMĂƂɌĂ΂܂B<BR><BR>
	 * 
	 * ̃\bh<BR>
	 *
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @return R}hsɐꍇ͐^Asꍇ͋U
	 * 	UԂƒɃNCAg\PbgI܂B
	 * 
	 * @see jp.wda.gpss.Socklet#doCommand(jp.wda.gpss.SocketProcessor, java.lang.String)
	 */
	public boolean doCommand(SocketProcessor client, String command) {
		if(((Boolean)client.getAttribute("loginFailure")).booleanValue()){ return false; }
		String roomname = client.getInitParam(INIT_ROOM_KEY);
		
		sendToClients(client.getUserName() + " : " + command, P_INIT_ROOM_KEY + "==\"" + roomname + "\"");
		chatlog(roomname, client.getUserName(), command);
		return true;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * `bgOƂ܂B
	 * 
	 * @param room `bg
	 * @param user [U[
	 * @param memo eA܂̓VXebZ[W
	 */
	private void chatlog(String room, String user, String memo){
		log(room + "," + user + "," + memo);
	}
}
