package jp.wda.gpss;

import java.util.Hashtable;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/**
 * \Pbg󋵐iǗNX
 *
 * @version	1.00002	2003/05/22
 * @since		1.00010	2003/05/14
 * @author	amoi
 */
public class Progress extends Hashtable {
	// JtB[h ///////////////////////////////////////////////////////////////////
	//                                                            Public Static Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	public static final Priority DEBUG = Priority.DEBUG;
	public static final Priority INFO  = Priority.INFO;
	public static final Priority WARN  = Priority.WARN;
	public static final Priority ERROR = Priority.ERROR;
	public static final Priority FATAL = Priority.FATAL;
	
	/* ***********************************************************************>> */;
	/**
	 * VXeK[
	 */
	public static final String SYSTEM_LOGGER = "gpssSystemLogger";
	
	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽÕK[ǉ܂B
	 * 
	 * @param name K[
	 * @param logger K[
	 */
	public void setLogger(String name, Logger logger){
		this.put(name, logger);
	}
	
	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽÕK[o^Ă邩mF܂B
	 * 
	 * @param name K[
	 * @return w肳ꂽÕK[o^Ăꍇ͐^
	 */
	public boolean contansLogger(String name){
		return this.containsKey(name);
	}

	// Oo͗p\bh ///////////////////////////////////////////////////////////////
	//                                                         Methods for Output Logs //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * VXeOt@CɁA񃍃Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 */
	public void syslog(Object message){
		log(SYSTEM_LOGGER, message, INFO, null);
	}
	/**
	 * VXeOt@CɁAw肳ꂽނ̃Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 */
	public void syslog(Object message, Priority priority){
		log(SYSTEM_LOGGER, message, priority, null);
	}
	/**
	 * VXeOt@CɁAG[Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param throwable G[
	 */
	public void errlog(Object message){
		log(SYSTEM_LOGGER, message, ERROR, null);
	}
	/**
	 * VXeOt@CɁAG[Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param throwable G[
	 */
	public void errlog(Object message, Throwable throwable){
		log(SYSTEM_LOGGER, message, ERROR, throwable);
	}
	/**
	 * VXeOt@CɁAw肳ꂽނ̃Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 * @param throwable G[
	 */
	public void syslog(Object message, Priority priority, Throwable throwable){
		log(SYSTEM_LOGGER, message, priority, throwable);
	}
	/**
	 * w肵Oœo^Ă郍Ot@CɁA񃍃Oo͂܂B<BR>
	 * ̖ÕK[o^ĂȂꍇ́AOo͂܂B
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 */
	public void log(String logger, Object message){
		log(logger, message, INFO, null);
	}
	/**
	 * w肵Oœo^Ă郍Ot@CɁAw肳ꂽނ̃Oo͂܂B<BR>
	 * ̖ÕK[o^ĂȂꍇ́AOo͂܂B
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 */
	public void log(String logger, Object message, Priority priority){
		log(logger, message, priority, null);
	}
	/**
	 * w肵Oœo^Ă郍Ot@CɃG[Oo͂܂B<BR>
	 * ̖ÕK[o^ĂȂꍇ́AOo͂܂B
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 * @param throwable G[
	 */
	public void log(String logger, Object message, Throwable throwable){
		log(logger, message, ERROR, throwable);
	}
	/**
	 * w肵Oœo^Ă郍Ot@CɁAw肳ꂽނ̃Oo͂܂B<BR>
	 * ̖ÕK[o^ĂȂꍇ́AOo͂܂B
	 * @param logger o͐惍K[
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 * @param throwable G[
	 */
	public void log(String logger, Object message, Priority priority, Throwable throwable){
		if(!this.containsKey(logger)){ return; }
		Logger log = (Logger)this.get(logger);
		log.log(priority, message, throwable);
	}
}
