package jp.wda.gpss.util;

import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 *  zXgAhX͎w肳ꂽNCAgAhXA
 *  [UUID𔭐NX
 *
 * @version	1.00		2003/04/29
 * @since		1.00		2003/04/29
 *	@author	amoi
 */
public class PseudoUUID {
	// ÓIRXgN^ ///////////////////////////////////////////////////////////////
	//                                                             Static Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ÓIRXgN^
	 */
	static{
		hostUnique = (new Object()).hashCode();
		mutex      = new Object();
		lastTime   = System.currentTimeMillis();
		DELAY      = 10;
		try{
			md = MessageDigest.getInstance("MD5");
		}catch(NoSuchAlgorithmException e){
			e.printStackTrace();
			md = null;
		}
		try {
			String s    = InetAddress.getLocalHost().getHostAddress();
			hostaddress = MD5(s);
		} catch (Throwable ex) {
			hostaddress = generateNoNetworkID();
		}
	}

	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	public PseudoUUID() throws IOException{
		this(null);
	}

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	public PseudoUUID(String clientaddr) throws IOException{
		super();
		
		if(md == null){
			throw new IOException("MD5ASYCXg[Ă܂B");
		}
		
		synchronized (mutex) {
			set1st();
			set2nd();
			set3rd(clientaddr);
		}
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * 
	 */
	private static String hostaddress;
	
	/**
	 * 
	 */
	private static int hostUnique;
	
	/**
	 * 
	 */
	private static Object mutex;
	
	/**
	 * 
	 */
	private static long lastTime;
	
	/**
	 * 
	 */
	private static long DELAY;
	
	/**
	 * 
	 */
	private static MessageDigest md;

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	XXX<BR>
	 */
	private int unique;
	/**
	 *	XXX擾<BR>
	 *	@return XXX
	 */
	public String get1st(){ return Integer.toHexString(unique); }
	/**
	 * 
	 */
	private void set1st(){
		this.unique = hostUnique;
	}

	/* ***********************************************************************>> */;
	/**
	 *	XXX<BR>
	 */
	private long time;
	/**
	 *	XXX擾<BR>
	 *	@return XXX
	 */
	public String get2nd(){ return Long.toHexString(time); }
	/**
	 * 
	 */
	private void set2nd(){
		while (true) {
			this.time = System.currentTimeMillis();
			
			if (this.time < lastTime + DELAY) {
				try{
					Thread.sleep(DELAY);
				}catch(InterruptedException e){ ; }
					
				continue;
			}
			
			lastTime = time;
			break;
		}
	}

	/* ***********************************************************************>> */;
	/**
	 *	XXX<BR>
	 */
	private String address;
	/**
	 *	XXX擾<BR>
	 *	@return XXX
	 */
	public String get3rd(){ return address; }
	/**
	 * 
	 * @param addr
	 */
	public void set3rd(String addr){
		address = (addr == null ? hostaddress : MD5(addr));
	}

	// I[@[Ch /////////////////////////////////////////////////////////////////
	//                                                               Over Ride Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	public String toString() {
		return get1st() + "-" + get2nd() + "-" + get3rd();
	}

	public boolean equals(Object obj) {
		if((obj != null) && (obj instanceof PseudoUUID)){
			PseudoUUID uuid = (PseudoUUID)obj;
			return (unique == uuid.unique &&
					 time   == uuid.time   &&
					 address.equals(uuid.address));
		}else{
			return false;
		}
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	public static String MD5(String val){
		if(val == null) return null;
		if(md  == null) return null;
		
		byte[] digest = md.digest(val.getBytes());
		
		StringBuffer s = new StringBuffer();
		for (int i = 0; i < digest.length; i++) {
			s.append(Integer.toHexString((digest[i] & 0xf0) >> 4));
			s.append(Integer.toHexString(digest[i] & 0x0f));
		}
		
		return s.toString();
	}
	
	/* ***********************************************************************>> */;
	private static String generateNoNetworkID() {
		Thread current = Thread.currentThread();
		String nid = Thread.activeCount()+
					System.getProperty("os.version")+
					System.getProperty("user.name")+
					System.getProperty("java.version");
		System.out.println(nid);
		
		return MD5(nid);
	}
	
	/* ***********************************************************************>> */;
    
	public static void main(String args[]) {
		try{
			System.out.println(InetAddress.getLocalHost().getHostAddress());
			System.out.println(new PseudoUUID());
			System.out.println(new PseudoUUID());
			System.out.println(new PseudoUUID());
			System.out.println(new PseudoUUID());
		}catch(Throwable ex){
			ex.printStackTrace();
		}
	}
}
