package jp.wda.gpss;

import java.util.List;
import java.util.Map;

import org.apache.log4j.Priority;

import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.util.Finder;


/**
 * SockletC^[tF[X<BR>
 * <BR>
 * SĂSocklet́ÃC^[tF[XKv܂B<BR>
 * ʏ̏ꍇ́Ajp.wda.gpss.GeneralSockletpy`łB<BR>
 *
 * @version	1.00008	2003/06/14
 * @since		1.00007	2003/05/10
 * @author	amoi
 */
public interface Socklet extends java.io.Serializable{
	// ۃ\bh /////////////////////////////////////////////////////////////////////
	//                                                                Abstract Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ڑpR}hMANCAǧs߂̃\bhB<BR>
	 * ̃\bh́AT[oVNCAg̐ڑmF_ŁA
	 * ̃NCAg邽߂ɌĂ΂܂B<BR>
	 * ڑNCAgɑ΂ԏ߂Ɉ񂾂Ă΂܂B<BR>
	 * SocketProcessorNX̃\bhgpāÃNXK؂ł邩A
	 * ܂NCAgɕKvȏ^ĂB<BR>
	 * <BR>
	 * ̃NCAgK؂łȂƔfꂽꍇ́AUfalseԂĂB
	 * ɃNCAg\PbgI܂B<BR>
	 * ̑̏ꍇ́A^ԂĂB^ԂƁANCAg\Pbgp܂B<BR>
	 * 
	 * @param client ڑ݂ĂNCAg
	 * @return AIꍇ͋UB
	 * @see jp.wda.gpss.SocketProcessor
	 */
	public abstract boolean checkConnection(SocketProcessor client);

	/* ***********************************************************************>> */;
	/**
	 * NCAg폜OɌĂяo郁\bhB<BR>
	 * ڑ̃NCAgؒfÃAvP[V珜O钼OɌĂ΂܂B<BR>
	 * ڑNCAgɑ΂AIOɈ񂾂Ă΂܂B<BR>
	 * ̐ڑNCAgցÃNCAgؒfꂽƂʒm悤ȏꍇ́A
	 * ̃\bhŋLqĂB<BR>
	 *
	 * @param client ꂩ폜NCAg
	 */
	public abstract void preRemoveClient(SocketProcessor client);
	
	/* ***********************************************************************>> */;
	/**
	 * R}h邽߂̃\bhB<BR>
	 * ڑ̃NCAgAR}hMĂƂɌĂ΂܂B
	 * TuNX͂̃b\hŁANCAg瑗ĂR}hĂB<BR>
	 * NCAg̐ڑɉxłĂ΂܂B<BR>
	 * <BR>
	 * R}h𑗂Ă\Pbgɑ΂āAbZ[W𑗐Mꍇ́Aȉ̃\bhgpĂB<BR>
	 * <BR>
	 * client.send(<I>M郁bZ[W</I>);<BR>
	 * <BR>
	 * ڑ̑SNCAgփbZ[W𑗐Mꍇ́Aȉ̃\bhgpĂB<BR>
	 * <BR>
	 * sendToAllClients(<I>M郁bZ[W</I>); <BR>
	 * <BR>
	 * ܂ÃNCAgւ̂݃bZ[W𑗂肽ꍇ́A
	 * SocketProcessorFinderhNXpĈȉ̃\bhgpĂB<BR>
	 * <BR>
	 * sendToClients(<I>M郁bZ[W</I>, <I>SocketProcessorFinder</I>);<BR>
	 * ܂́A<BR>
	 * sendToClients(<I>M郁bZ[W</I>, <I>MNCAǧ</I>);<BR>
	 * <BR>
	 * SocketProcessorFinderɂ́A[U[ł̌pNXp^lł̌pNXȂǂpӂĂ܂B<BR>
	 * 
	 * @param client R}h𑗐MĂNCAg\Pbg
	 * @param command MR}h
	 * @return R}hsɐꍇ͐^Asꍇ͋U
	 * 	UԂƒɃNCAg\PbgI܂B
	 */
	public abstract boolean doCommand(SocketProcessor client, String command);

	// ۃ\bh /////////////////////////////////////////////////////////////////////
	//                                                                Abstract Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Socklet܂B<BR>
	 * 
	 * @param info Sockletz
	 * @param links IɒǉzSockletSockletzIuWFNgݒ肷邽߂List
	 * @param progress \Pbg󋵐iǗIuWFNgB
	 */
	public abstract void init(SockletDeployInfo info, List links, Progress progress);

	/* ***********************************************************************>> */;
	/**
	 * ̃\bhinit(SockletDeployInfo info, List links, Progress progress)ɂāA
	 * linksIuWFNgɐݒ肳ꂽǉzSockletzIAT[oɂN1񂾂Ă΂܂B<BR>
	 * T[oɂĒǉzꂽSocklet\ߎ擾ꍇɂ̃\bhgpĂB
	 * 
	 * @param linkedSocklets IɒǉzꂽSocklet̂ASocklet̃ANZXꂽSockletꗗASockletzL[ƂĕێMapIuWFNg
	 */
	public abstract void afterDeployedLinks(Map linkedSocklets);

	/* ***********************************************************************>> */;
	/**
	 * SockletT[rX~ۂɁAҎ󂯃CT[oɂČĂяo܂B<BR>
	 * Socklet̏I[`LqÃ\bhĂB
	 */
	public abstract void destroy();

	/* ***********************************************************************>> */;
	/**
	 * Socklet̔z擾܂B<BR>
	 * zƂ́AGPSSݒt@C<application>m[hɋLqꂽname̒lłB<BR>
	 * NCAǵÁhzh𗊂ɁASocklet܂B<BR>
	 * 
	 * @return Socklet
	 */
	public abstract String getName();

	/* ***********************************************************************>> */;
	/**
	 * ^CAEg(~bP)擾܂B<BR>
	 *
	 * @return ^CAEg(~bP)
	 */
	public abstract int getTimeout();
	/**
	 * SockletzSockletݒ肵܂B<BR>
	 * 
	 * @return ^CAEg(~bP)
	 */
	public abstract void setTimeout(int timeout);

	/* ***********************************************************************>> */;
	/**
	 * SockletzSocklet擾܂B<BR>
	 * 
	 * @return Socklet
	 */
	public abstract String deployedBy();
	/**
	 * SockletzSockletݒ肵܂B<BR>
	 * 
	 * @return Socklet
	 */
	public abstract void deployedBy(ExecutableBase server, String name);
	
	/* ***********************************************************************>> */;
	/**
	 *	w肵NCAgASocklet̐ڑNCAgꗗɒǉ܂B<BR>
	 *
	 *	@param client ǉNCAg
	 */
	public abstract void addClient(SocketProcessor client);
	
	/**
	 *	w肵NCAgASocklet̐ڑNCAgꗗ폜܂B<BR>
	 *	@param client 폜NCAg
	 */
	public abstract void removeClient(SocketProcessor client);
	
	/**
	 *	ݐڑ̃NCAg𐔂܂B<BR>
	 *	@return ݐڑ̃NCAg
	 */
	public abstract int countClients();
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletɐڑ̑SNCAgؒf܂B<BR>
	 * 
	 * @param message bZ[W
	 */
	public abstract void disconnectAllClients(String message);
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletɐڑ̑SẴNCAgɌāAbZ[W𑗐M܂B<BR>
	 * 
	 * @param message M郁bZ[W
	 */
	public void sendToAllClients(String message);
	
	/**
	 * Sockletɐڑ̃NCAĝȀLNCAĝ݂ɌāAbZ[W𑗐M܂B<BR>
	 * Ⴆ΁Ã[U[w肵āÃ[U[݂̂ɑMꍇ́Aȉ̂悤ɂ܂B<BR>
	 * sendToClients("肽bZ[W", new SocketProcessorFinderByUsername("肽[U["));<BR>
	 * ܂Ã[Uɂ̂ݑ肽Ȃꍇ͈ȉ̂悤ɂ܂B<BR>
	 * sendToClients("肽bZ[W", new SocketProcessorFinderByUsername(false, "肽Ȃ[U["));<BR>
	 * 
	 * @param message M郁bZ[W
	 * @param finder MNCAgpIuWFNg
	 * @see jp.wda.gpss.util.SocketProcessorFinder#getFinder(String)
	 */
	public void sendToClients(String message, Finder finder);
	
	/**
	 * Sockletɐڑ̃NCAĝȀLNCAĝ݂ɌāAbZ[W𑗐M܂B<BR>
	 * ̎w@́ASocketProcessorFinder#getFinder(String)B
	 * 
	 * @param message M郁bZ[W
	 * @param condition MNCAǧ
	 * @see jp.wda.gpss.util.SocketProcessorFinder#getFinder(String)
	 */
	public void sendToClients(String message, String condition);
	
	/* ***********************************************************************>> */;
	/**
	 * Socklet̃ANZX邩ǂmF܂B
	 * 
	 * @param from ANZX݂ĂASocklet
	 * @return Socklet̃ANZXꍇ͐^
	 */
	public abstract boolean allowAccessFromOtherSocklet(Socklet from); 
	
	/* ***********************************************************************>> */;
	/**
	 * Sockletw胍Ot@CAꂪo^ĂȂꍇ̓VXeOt@CɁA
	 * w肳ꂽނ̃Oo͂܂B<BR>
	 * @param message o͂郍ObZ[W
	 * @param priority O
	 * @param throwable G[
	 */
	public void log(Object message, Priority priority, Throwable throwable);
}
