/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XMLUtil {
    private XMLUtil() {
    }

    public static SAXParser getSAXParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception ex) {
            throw new SeasarRuntimeException("ESSR0017", new Object[]{ex}, (Throwable)ex);
        }
    }

    public static Document getDocument(InputStream in) throws SeasarException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public static Document getDocument(String name) throws SeasarException {
        InputStream is = ResourceUtil.getResourceAsStream(name, "xml");
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        }
        catch (Exception ex) {
            throw new SeasarException("ESSR0008", new Object[]{name, ex}, (Throwable)ex);
        }
    }

    public static Element getRoot(String name) throws SeasarException {
        return XMLUtil.getDocument(name).getDocumentElement();
    }

    public static Node getAttribute(Node node, String attributeName) {
        return node.getAttributes().getNamedItem(attributeName);
    }

    public static String getAttributeValue(Node node, String attributeName) {
        return XMLUtil.getValue(node.getAttributes().getNamedItem(attributeName));
    }

    public static String getNodeValue(Node node) {
        return XMLUtil.getValue(node.getFirstChild());
    }

    public static String getPackedString(String data) {
        StringTokenizer st = new StringTokenizer(data, " \t\f\n\r");
        StringBuffer buf = new StringBuffer();
        int size = st.countTokens();
        if (size > 0) {
            buf.append(st.nextToken());
            for (int i = 1; i < size; ++i) {
                buf.append(" ");
                buf.append(st.nextToken());
            }
        }
        return buf.toString();
    }

    public static InputStream getContentsAsStream(String contents) {
        return XMLUtil.getContentsAsStream(contents, null);
    }

    public static InputStream getContentsAsStream(String contents, String encoding) {
        if (encoding == null) {
            return new ByteArrayInputStream(contents.getBytes());
        }
        try {
            return new ByteArrayInputStream(contents.getBytes(encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static String encodeAttrQuot(String s) {
        if (s == null) {
            return null;
        }
        char[] content = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(content[i]);
                }
            }
        }
        return buf.toString();
    }

    public static String encodeText(String s) {
        if (s == null) {
            return null;
        }
        char[] content = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(content[i]);
                }
            }
        }
        return buf.toString();
    }

    public static String toString(Document document) {
        StringBuffer buf = new StringBuffer();
        XMLUtil.appendElement(document.getDocumentElement(), buf);
        return buf.toString();
    }

    public static String toString(Element element) {
        StringBuffer buf = new StringBuffer();
        XMLUtil.appendElement(element, buf);
        return buf.toString();
    }

    public static void appendElement(Element element, StringBuffer buf) {
        String tag = element.getTagName();
        buf.append('<');
        buf.append(tag);
        XMLUtil.appendAttrs(element.getAttributes(), buf);
        buf.append('>');
        XMLUtil.appendChildren(element.getChildNodes(), buf);
        buf.append("</");
        buf.append(tag);
        buf.append('>');
    }

    public static void appendChildren(NodeList children, StringBuffer buf) {
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            XMLUtil.appendNode(children.item(i), buf);
        }
    }

    public static void appendAttrs(NamedNodeMap attrs, StringBuffer buf) {
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            buf.append(' ');
            XMLUtil.appendAttr(attr, buf);
        }
    }

    public static void appendAttr(Attr attr, StringBuffer buf) {
        buf.append(attr.getName());
        buf.append("=\"");
        buf.append(XMLUtil.encodeAttrQuot(attr.getValue()));
        buf.append('\"');
    }

    public static void appendText(Text text, StringBuffer buf) {
        buf.append(XMLUtil.encodeText(text.getData()));
    }

    public static void appendCDATASection(CDATASection cdataSection, StringBuffer buf) {
        buf.append("<![CDATA[");
        buf.append(cdataSection.getData());
        buf.append("]]>");
    }

    public static void appendEntityReference(EntityReference entityReference, StringBuffer buf) {
        buf.append('&');
        buf.append(entityReference.getNodeName());
        buf.append(';');
    }

    public static void appendNode(Node node, StringBuffer buf) {
        switch (node.getNodeType()) {
            case 1: {
                XMLUtil.appendElement((Element)node, buf);
                break;
            }
            case 3: {
                XMLUtil.appendText((Text)node, buf);
                break;
            }
            case 4: {
                XMLUtil.appendCDATASection((CDATASection)node, buf);
                break;
            }
            case 5: {
                XMLUtil.appendEntityReference((EntityReference)node, buf);
            }
        }
    }

    private static String getValue(Node node) {
        if (node != null) {
            String value = node.getNodeValue().trim();
            return "".equals(value) ? null : value;
        }
        return null;
    }
}

