/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerRule;
import org.seasar.util.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLHandlerParser {
    private XMLHandlerParser() {
    }

    public static Object parse(String path, XMLHandlerRule rule) {
        return XMLHandlerParser.parse(path, rule, null);
    }

    public static Object parse(String path, XMLHandlerRule rule, boolean usePathMatching) {
        return XMLHandlerParser.parse(path, rule, null, usePathMatching);
    }

    public static Object parse(String path, XMLHandlerRule rule, Object result) {
        return XMLHandlerParser.parse(path, rule, result, true);
    }

    public static Object parse(String path, XMLHandlerRule rule, Object result, boolean usePathMatching) {
        return XMLHandlerParser.parse(ResourceUtil.getResourceAsStream(path, "xml"), rule, result, usePathMatching);
    }

    public static Object parse(URL url, XMLHandlerRule rule) {
        return XMLHandlerParser.parse(url, rule, null);
    }

    public static Object parse(URL url, XMLHandlerRule rule, boolean usePathMatching) {
        return XMLHandlerParser.parse(url, rule, null, usePathMatching);
    }

    public static Object parse(URL url, XMLHandlerRule rule, Object result) {
        return XMLHandlerParser.parse(url, rule, result, true);
    }

    public static Object parse(URL url, XMLHandlerRule rule, Object result, boolean usePathMatching) {
        try {
            return XMLHandlerParser.parse(url.openStream(), rule, result, usePathMatching);
        }
        catch (IOException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static Object parse(File file, XMLHandlerRule rule) {
        return XMLHandlerParser.parse(file, rule, null);
    }

    public static Object parse(File file, XMLHandlerRule rule, boolean usePathMatching) {
        return XMLHandlerParser.parse(file, rule, null, usePathMatching);
    }

    public static Object parse(File file, XMLHandlerRule rule, Object result) {
        return XMLHandlerParser.parse(file, rule, result, true);
    }

    public static Object parse(File file, XMLHandlerRule rule, Object result, boolean usePathMatching) {
        try {
            return XMLHandlerParser.parse(new BufferedInputStream(new FileInputStream(file)), rule, result, usePathMatching);
        }
        catch (IOException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static Object parse(InputStream inputStream, XMLHandlerRule rule) {
        return XMLHandlerParser.parse(inputStream, rule, null);
    }

    public static Object parse(InputStream inputStream, XMLHandlerRule rule, Object result) {
        return XMLHandlerParser.parse(inputStream, rule, result, true);
    }

    public static Object parse(InputStream inputStream, XMLHandlerRule rule, Object result, boolean usePathMatching) {
        return XMLHandlerParser.parse(new InputSource(inputStream), rule, result, usePathMatching);
    }

    public static Object parse(InputSource inputSource, XMLHandlerRule rule) {
        return XMLHandlerParser.parse(inputSource, rule, null);
    }

    public static Object parse(InputSource inputSource, XMLHandlerRule rule, Object result) {
        return XMLHandlerParser.parse(inputSource, rule, result, true);
    }

    public static Object parse(InputSource inputSource, XMLHandlerRule rule, Object result, boolean usePathMatching) {
        SAXParser saxParser = XMLUtil.getSAXParser();
        XMLHandler xmlHandler = new XMLHandler(rule, usePathMatching);
        if (result != null) {
            xmlHandler.push(result);
        }
        try {
            saxParser.parse(inputSource, (DefaultHandler)xmlHandler);
        }
        catch (SAXException ex) {
            Exception e = ex.getException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
        catch (IOException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
        return xmlHandler.getResult();
    }
}

