/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.util.Map;
import java.util.Stack;
import org.seasar.util.Assertion;
import org.seasar.util.ElementHandler;
import org.seasar.util.MathUtil;
import org.seasar.util.SMap;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLHandler
extends DefaultHandler {
    private XMLHandlerRule _xmlHandlerRule = null;
    private StringBuffer _bodyBuffer = null;
    private Stack _bodyBufferStack = new Stack();
    private String _locationPath = "";
    private String _qName = "";
    private Stack _qNameStack = new Stack();
    private String _locationDetailPath = "";
    private Object _result;
    private Stack _stack = new Stack();
    private Map _pathCounts = new SMap();
    private boolean _usePathMatching = true;

    public XMLHandler(XMLHandlerRule xmlHandlerRule) {
        this(xmlHandlerRule, true);
    }

    public XMLHandler(XMLHandlerRule xmlHandlerRule, boolean usePathMatching) {
        Assertion.assertNotNull("xmlHandlerRule", xmlHandlerRule);
        this._xmlHandlerRule = xmlHandlerRule;
        this._usePathMatching = usePathMatching;
    }

    public void push(Object o) {
        if (this._stack.empty()) {
            this._result = o;
        }
        this._stack.push(o);
    }

    public Object getResult() {
        return this._result;
    }

    public Object pop() {
        return this._stack.pop();
    }

    public Object peek() {
        return this._stack.peek();
    }

    public Object peek(int n) {
        return this._stack.get(this._stack.size() - n - 1);
    }

    public Object peek(Class clazz) {
        for (int i = this._stack.size() - 1; i >= 0; --i) {
            Object o = this._stack.get(i);
            if (!clazz.isInstance(o)) continue;
            return o;
        }
        return null;
    }

    public Object peekFirst() {
        return this._stack.get(0);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this._bodyBufferStack.push(this._bodyBuffer);
        this._bodyBuffer = new StringBuffer();
        this._qNameStack.push(this._qName);
        this._qName = qName;
        this._locationPath = this._locationPath + "/" + qName;
        int pathCount = this.incrementPathCount();
        this._locationDetailPath = this._locationDetailPath + "/" + qName + "[" + pathCount + "]";
        ElementHandler eh = null;
        eh = this._usePathMatching ? this._xmlHandlerRule.getElementHandler(this._locationPath) : this._xmlHandlerRule.getElementHandler(qName);
        if (eh != null) {
            try {
                eh.start(this, attributes);
            }
            catch (Exception ex) {
                throw new SeasarRuntimeException("ESSR0347", new Object[]{this._locationDetailPath, ex}, (Throwable)ex);
            }
        }
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        this._bodyBuffer.append(buffer, start, length);
        ElementHandler eh = null;
        eh = this._usePathMatching ? this._xmlHandlerRule.getElementHandler(this._locationPath) : this._xmlHandlerRule.getElementHandler(this._qName);
        if (eh != null) {
            try {
                String body = new String(buffer, start, length).trim();
                if (body.length() > 0) {
                    eh.appendBody(this, body);
                }
            }
            catch (Exception ex) {
                throw new SeasarRuntimeException("ESSR0347", new Object[]{this._locationDetailPath, ex}, (Throwable)ex);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ElementHandler eh = null;
        eh = this._usePathMatching ? this._xmlHandlerRule.getElementHandler(this._locationPath) : this._xmlHandlerRule.getElementHandler(qName);
        if (eh != null) {
            try {
                eh.end(this, this._bodyBuffer.toString().trim());
            }
            catch (Exception ex) {
                throw new SeasarRuntimeException("ESSR0347", new Object[]{this._locationDetailPath, ex}, (Throwable)ex);
            }
        }
        this._bodyBuffer = (StringBuffer)this._bodyBufferStack.pop();
        this._locationPath = this._locationPath.substring(0, this._locationPath.lastIndexOf(47));
        this._locationDetailPath = this._locationDetailPath.substring(0, this._locationDetailPath.lastIndexOf(47));
        this._qName = (String)this._qNameStack.pop();
    }

    public void endDocument() {
        this._bodyBuffer = null;
        this._bodyBufferStack.clear();
        this._stack.clear();
    }

    public String getLocationPath() {
        return this._locationPath;
    }

    public String getLocationDetailPath() {
        return this._locationDetailPath;
    }

    private int incrementPathCount() {
        Integer pathCount = (Integer)this._pathCounts.get(this._locationPath);
        pathCount = pathCount == null ? MathUtil.ONE_INTEGER : MathUtil.increment(pathCount);
        this._pathCounts.put(this._locationPath, pathCount);
        return pathCount;
    }
}

