/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public final class ThrowableUtil {
    private ThrowableUtil() {
    }

    public static Throwable getCause(Throwable throwable) {
        SeasarRuntimeException sre;
        if (throwable instanceof UndeclaredThrowableException) {
            Throwable t = ((UndeclaredThrowableException)throwable).getUndeclaredThrowable();
            return ThrowableUtil.getCause(t);
        }
        if (throwable instanceof InvocationTargetException) {
            Throwable t = ((InvocationTargetException)throwable).getTargetException();
            return ThrowableUtil.getCause(t);
        }
        if (throwable instanceof SeasarException) {
            SeasarException se = (SeasarException)throwable;
            if (se.getMessageCode().equals("ESSR0017")) {
                return ThrowableUtil.getCause(se.getCause());
            }
        } else if (throwable instanceof SeasarRuntimeException && (sre = (SeasarRuntimeException)throwable).getMessageCode().equals("ESSR0017")) {
            return ThrowableUtil.getCause(sre.getCause());
        }
        return throwable;
    }

    public static StackTraceElement getCallerCallerStackTraceElement(Throwable throwable, Class callerClass) {
        StackTraceElement[] stea = throwable.getStackTrace();
        for (int i = 0; i < stea.length; ++i) {
            if (stea[i].getClassName().equals(callerClass.getName())) continue;
            return stea[i];
        }
        throw new IllegalArgumentException(callerClass.getName() + " not found");
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

