/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.seasar.util.ArrayUtil;

public final class StringUtil {
    private StringUtil() {
    }

    public static final String getLastToken(String target, char delim) {
        int pos = target.lastIndexOf(delim);
        if (pos < 0) {
            return target;
        }
        return target.substring(pos + 1);
    }

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    public static String[] split(String str, String delim) {
        if (str == null) {
            return ArrayUtil.EMPTY_STRINGS;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreElements()) {
            list.add(st.nextElement());
        }
        return list.toArray(ArrayUtil.EMPTY_STRINGS);
    }

    public static final String ltrim(String text) {
        return StringUtil.ltrim(text, null);
    }

    public static final String ltrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = 0; pos < text.length() && trimText.indexOf(text.charAt(pos)) >= 0; ++pos) {
        }
        return text.substring(pos);
    }

    public static final String rcut(String text, String cutText) {
        if (text == null) {
            return null;
        }
        if (StringUtil.isEmpty(cutText) || !text.endsWith(cutText)) {
            return text;
        }
        return text.substring(0, text.length() - cutText.length());
    }

    public static final String rtrim(String text) {
        return StringUtil.rtrim(text, null);
    }

    public static final String rtrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = text.length() - 1; pos >= 0 && trimText.indexOf(text.charAt(pos)) >= 0; --pos) {
        }
        return text.substring(0, pos + 1);
    }

    public static final String btrim(String text) {
        return StringUtil.btrim(text, " ");
    }

    public static final String btrim(String text, String trimText) {
        int pos2;
        int pos;
        if (text == null) {
            return null;
        }
        for (pos = 0; pos < text.length() && trimText.indexOf(text.charAt(pos)) >= 0; ++pos) {
        }
        for (pos2 = text.length() - 1; pos2 > pos && trimText.indexOf(text.charAt(pos2)) >= 0; --pos2) {
        }
        return text.substring(pos, pos2 + 1);
    }

    public static final String lpad(String text, int length) {
        return StringUtil.lpad(text, length, null);
    }

    public static final String lpad(String text, int length, String fillText) {
        if (text == null) {
            return null;
        }
        if (fillText == null) {
            fillText = " ";
        }
        if (text.length() >= length) {
            return text.substring(0, length);
        }
        int num = length - text.length();
        int div = num / fillText.length();
        int mod = num % fillText.length();
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < div; ++i) {
            buf.append(fillText);
        }
        if (mod > 0) {
            buf.append((Object)fillText.subSequence(0, mod));
        }
        buf.append(text);
        return buf.toString();
    }

    public static final String rpad(String text, int length) {
        return StringUtil.rpad(text, length, " ");
    }

    public static final String rpad(String text, int length, String fillText) {
        if (text == null) {
            return null;
        }
        if (text.length() >= length) {
            return text.substring(0, length);
        }
        int num = length - text.length();
        int div = num / fillText.length();
        int mod = num % fillText.length();
        StringBuffer buf = new StringBuffer(100);
        buf.append(text);
        for (int i = 0; i < div; ++i) {
            buf.append(fillText);
        }
        if (mod > 0) {
            buf.append((Object)fillText.subSequence(0, mod));
        }
        return buf.toString();
    }

    public static final String translate(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int pos = fromText.indexOf(c);
            if (pos < 0) {
                buf.append(c);
                continue;
            }
            if (pos >= toText.length()) continue;
            buf.append(toText.charAt(pos));
        }
        return buf.toString();
    }

    public static final String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                buf.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            buf.append(text.substring(pos2, pos));
            buf.append(toText);
            pos2 = pos + fromText.length();
        }
        buf.append(text.substring(pos2));
        return buf.toString();
    }

    public static final String repeat(String text, int count) {
        if (text == null || count < 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < count; ++i) {
            buf.append(text);
        }
        return buf.toString();
    }

    public static int ascii(String str) {
        return str.charAt(0);
    }

    public static String chr(int arg) {
        return String.valueOf((char)arg);
    }

    public static int length(String arg) {
        return arg.length();
    }

    public static String lower(String arg) {
        return arg.toLowerCase();
    }

    public static String upper(String arg) {
        return arg.toUpperCase();
    }

    public static int strpos(String str, String arg) {
        return str.indexOf(arg) + 1;
    }

    public static String substr(String str, int from) {
        if (str == null) {
            return null;
        }
        return StringUtil.substr(str, from, str.length());
    }

    public static String substr(String str, int from, int count) {
        if (str == null) {
            return null;
        }
        int f = from - 1;
        if (f < 0) {
            f = 0;
        } else if (f >= str.length()) {
            return null;
        }
        if (count <= 0) {
            return null;
        }
        int t = str.length();
        if (f + count < t) {
            t = f + count;
        }
        return str.substring(f, t);
    }

    public static String substrb(String str, int byteLength) {
        if (str == null) {
            return null;
        }
        byte[] bytesval = str.getBytes();
        int len = bytesval.length;
        String s = str;
        if (len > byteLength) {
            for (int i = byteLength; i >= 0; --i) {
                s = new String(bytesval, 0, i);
                if (s.equals("") || s.charAt(s.length() - 1) == '\ufffd') continue;
                return s;
            }
        }
        return s;
    }

    public static int indexOf(char[] source, char[] target) {
        return StringUtil.indexOf(source, target, 0);
    }

    public static int indexOf(char[] source, char[] target, int fromIndex) {
        return StringUtil.indexOf(source, 0, source.length, target, 0, target.length, fromIndex);
    }

    public static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char targetFirst = target[targetOffset];
        int sourceFirstPos = sourceOffset + fromIndex;
        int sourceFirstMax = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (sourceFirstPos <= sourceFirstMax && source[sourceFirstPos] != targetFirst) {
                ++sourceFirstPos;
                continue;
            }
            if (sourceFirstPos > sourceFirstMax) {
                return -1;
            }
            int sourcePos = sourceFirstPos + 1;
            int sourcePosMax = sourceFirstPos + targetCount;
            int targetPos = targetOffset + 1;
            while (sourcePos < sourcePosMax) {
                if (source[sourcePos++] == target[targetPos++]) continue;
                ++sourceFirstPos;
                continue block0;
            }
            break;
        }
        return sourceFirstPos - sourceOffset;
    }

    public static String newString(char[] buf, int off, int len) {
        return new String(buf, off, len).intern();
    }
}

