/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

public class Sorter {
    public final void sort(Object[] dest) {
        this.sort(dest, 0, dest.length);
    }

    public final void sort(Object[] dest, int low, int high) {
        Object[] src = (Object[])dest.clone();
        this.mergeSort(src, dest, low, high);
    }

    protected int doCompare(Object o1, Object o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    private void mergeSort(Object[] src, Object[] dest, int low, int high) {
        int length = high - low;
        if (length < 7) {
            this.bubbleSort(dest, low, high);
            return;
        }
        int mid = (low + high) / 2;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        if (this.doCompare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && this.doCompare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private void bubbleSort(Object[] dest, int low, int high) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low && this.doCompare(dest[j - 1], dest[j]) > 0; --j) {
                Sorter.swap(dest, j, j - 1);
            }
        }
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
}

