/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import org.seasar.message.MessageFormatter;
import org.seasar.util.ArrayUtil;
import org.seasar.util.SeasarRuntimeException;

public class SeasarException
extends Exception {
    private String _messageCode;
    private Object[] _arguments;
    private String _className;
    private String _methodName;
    private String _message;

    public SeasarException(String messageCode) {
        this(messageCode, ArrayUtil.EMPTY_OBJECTS, (Throwable)null);
    }

    public SeasarException(String messageCode, Object arg0) {
        this(messageCode, new Object[]{arg0}, (Throwable)null);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1) {
        this(messageCode, new Object[]{arg0, arg1}, (Throwable)null);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1, Object arg2) {
        this(messageCode, new Object[]{arg0, arg1, arg2}, (Throwable)null);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1, Object arg2, Object arg3) {
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3}, (Throwable)null);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4}, (Throwable)null);
    }

    public SeasarException(String messageCode, Throwable cause) {
        this(messageCode, ArrayUtil.EMPTY_OBJECTS, cause);
    }

    public SeasarException(String messageCode, Object arg0, Throwable cause) {
        this(messageCode, new Object[]{arg0}, cause);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1, Throwable cause) {
        this(messageCode, new Object[]{arg0, arg1}, cause);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1, Object arg2, Throwable cause) {
        this(messageCode, new Object[]{arg0, arg1, arg2}, cause);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1, Object arg2, Object arg3, Throwable cause) {
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3}, cause);
    }

    public SeasarException(String messageCode, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable cause) {
        this(messageCode, new Object[]{arg0, arg1, arg2, arg3, arg4}, cause);
    }

    public SeasarException(String messageCode, Object[] arguments) {
        this(messageCode, arguments, (Throwable)null);
    }

    public SeasarException(String messageCode, Object[] arguments, Throwable cause) {
        super(cause);
        if (messageCode == null) {
            throw new IllegalArgumentException(MessageFormatter.getMessage("ESSR0007", new Object[]{"messageCode"}));
        }
        this._messageCode = messageCode;
        this._arguments = arguments;
        this._message = MessageFormatter.getMessage(messageCode, this._arguments);
        StackTraceElement ste = this.getStackTrace()[0];
        this._className = ste.getClassName();
        this._methodName = ste.getMethodName();
    }

    public static SeasarException convertSeasarException(Throwable throwable) {
        return SeasarException.convertSeasarException("ESSR0017", new Object[]{throwable}, throwable);
    }

    public static SeasarException convertSeasarException(String messageCode, Object[] arguments, Throwable throwable) {
        if (throwable instanceof SeasarException) {
            return (SeasarException)throwable;
        }
        return new SeasarException(messageCode, arguments, throwable);
    }

    public SeasarRuntimeException convertSeasarRuntimeException() {
        return new SeasarRuntimeException(this._messageCode, this._arguments, this.getCause(), this._className, this._methodName, this._message);
    }

    public String getMessage() {
        return this._message;
    }

    public String getLocalizedMessage() {
        return this._message;
    }

    public String getMessageCode() {
        return this._messageCode;
    }

    public Object[] getArguments() {
        return this._arguments;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }
}

