/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.seasar.util.EMap;
import org.seasar.util.ElementHandler;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class SeasarContext
implements Serializable {
    static final long serialVersionUID = 5048121277903501233L;
    private static final EMap _seasarContextMap = new EMap();
    private static XMLHandlerRule _xmlHandlerRule = new XMLHandlerRule();
    private String _name;
    private int _hashCode;
    private Properties _jndiProperties = new Properties();
    private String _dataSourceJNDIName;
    private String _userTransactionJNDIName;
    private String _hostName = null;
    private int _port = 0;
    private transient Map _jndiMap;
    private transient InitialContext _initialContext;
    private transient DataSource _dataSource;
    private transient UserTransaction _userTransaction;

    private SeasarContext(String name) {
        this._name = name;
        this._hashCode = name.hashCode();
    }

    public static SeasarContext getInstance() {
        return (SeasarContext)_seasarContextMap.get(0);
    }

    public static SeasarContext getInstance(String name) {
        SeasarContext churaContext = (SeasarContext)_seasarContextMap.get(name);
        if (churaContext != null) {
            return churaContext;
        }
        throw new SeasarRuntimeException("ESSR0001", new Object[]{name});
    }

    public String getName() {
        return this._name;
    }

    public final String getHostName() {
        return this._hostName;
    }

    public final int getPort() {
        return this._port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof SeasarContext)) {
            return false;
        }
        return this._name.equals(((SeasarContext)o)._name);
    }

    public int hashCode() {
        return this._hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitialContext getInitialContext() throws SeasarException {
        if (this._initialContext != null) {
            return this._initialContext;
        }
        SeasarContext seasarContext = this;
        synchronized (seasarContext) {
            if (this._initialContext == null) {
                try {
                    this._initialContext = new InitialContext(this._jndiProperties);
                }
                catch (Exception ex) {
                    throw new SeasarException("ESSR0333", new Object[]{ex}, (Throwable)ex);
                }
            }
        }
        return this._initialContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String jndiName) throws SeasarException {
        Map jndiMap = this.getJndiMap();
        Object o = jndiMap.get(jndiName);
        if (o != null) {
            return o;
        }
        SeasarContext seasarContext = this;
        synchronized (seasarContext) {
            if (o == null) {
                o = this.lookupNoCache(jndiName);
                jndiMap.put(jndiName, o);
            }
        }
        return o;
    }

    public Object lookupNoCache(String jndiName) throws SeasarException {
        InitialContext context = this.getInitialContext();
        try {
            return context.lookup(jndiName);
        }
        catch (NameNotFoundException ex) {
            try {
                return context.lookup(jndiName.replace('.', '/'));
            }
            catch (NamingException ex2) {
                throw new SeasarException("ESSR0328", new Object[]{jndiName, ex2}, (Throwable)ex2);
            }
        }
        catch (Throwable t) {
            this.init();
            try {
                return this.getInitialContext().lookup(jndiName);
            }
            catch (NamingException ex3) {
                throw new SeasarException("ESSR0328", new Object[]{jndiName, ex3}, (Throwable)ex3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource() throws SeasarException {
        if (this._dataSource != null) {
            return this._dataSource;
        }
        SeasarContext seasarContext = this;
        synchronized (seasarContext) {
            if (this._dataSource == null) {
                this._dataSource = (DataSource)this.lookupNoCache(this._dataSourceJNDIName);
            }
        }
        return this._dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SeasarException {
        DataSource ds = this.getDataSource();
        try {
            return ds.getConnection();
        }
        catch (Throwable t) {
            SeasarContext seasarContext = this;
            synchronized (seasarContext) {
                this._dataSource = (DataSource)this.lookupNoCache(this._dataSourceJNDIName);
            }
            try {
                return this._dataSource.getConnection();
            }
            catch (Exception ex) {
                throw new SeasarException("ESSR0329", new Object[]{ex}, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTransaction getUserTransaction() throws SeasarException {
        if (this._userTransaction != null) {
            return this._userTransaction;
        }
        SeasarContext seasarContext = this;
        synchronized (seasarContext) {
            if (this._userTransaction == null) {
                this._userTransaction = (UserTransaction)this.lookupNoCache(this._userTransactionJNDIName);
            }
        }
        return this._userTransaction;
    }

    public boolean hasTransaction() throws SeasarException {
        UserTransaction ut = this.getUserTransaction();
        try {
            return ut.getStatus() != 6;
        }
        catch (SystemException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public void begin() throws SeasarException {
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            userTransaction.begin();
        }
        catch (Exception ex) {
            throw new SeasarException("ESSR0330", new Object[]{ex}, (Throwable)ex);
        }
    }

    public void commit() throws SeasarException {
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            userTransaction.commit();
        }
        catch (Exception ex) {
            throw new SeasarException("ESSR0331", new Object[]{ex}, (Throwable)ex);
        }
    }

    public void rollback() throws SeasarException {
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            userTransaction.rollback();
        }
        catch (Exception ex) {
            throw new SeasarException("ESSR0332", new Object[]{ex}, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getJndiMap() {
        if (this._jndiMap != null) {
            return this._jndiMap;
        }
        SeasarContext seasarContext = this;
        synchronized (seasarContext) {
            if (this._jndiMap == null) {
                this._jndiMap = new EMap();
            }
        }
        return this._jndiMap;
    }

    private static void configure() {
        SeasarContext.setupXMLHandlerRule();
        XMLHandlerParser.parse("/seasar-context.xml", _xmlHandlerRule);
        _seasarContextMap.put((Object)null, _seasarContextMap.get(0));
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("/seasarContext/context", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String name = attributes.getValue("name");
                SeasarContext seasarContext = new SeasarContext(name);
                _seasarContextMap.put(seasarContext.getName(), seasarContext);
                xmlHandler.push(seasarContext);
            }

            public void end(XMLHandler xmlHandler, String body) {
                SeasarContext seasarContext = (SeasarContext)xmlHandler.pop();
                seasarContext.setupHostNameAndPort();
            }
        });
        _xmlHandlerRule.addElementHandler("/seasarContext/context/jndiProperties/property", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                SeasarContext seasarContext = (SeasarContext)xmlHandler.peek();
                seasarContext._jndiProperties.setProperty(name, value);
            }
        });
        _xmlHandlerRule.addElementHandler("/seasarContext/context/dataSource", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                SeasarContext seasarContext = (SeasarContext)xmlHandler.peek();
                seasarContext._dataSourceJNDIName = attributes.getValue("jndiName");
            }
        });
        _xmlHandlerRule.addElementHandler("/seasarContext/context/userTransaction", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                SeasarContext seasarContext = (SeasarContext)xmlHandler.peek();
                seasarContext._userTransactionJNDIName = attributes.getValue("jndiName");
            }
        });
    }

    private void setupHostNameAndPort() {
        String url = (String)this._jndiProperties.get("java.naming.provider.url");
        if (url == null) {
            return;
        }
        int colonPos = url.lastIndexOf(58);
        int slashPos = url.lastIndexOf(47);
        if (colonPos > 0) {
            this._port = Integer.parseInt(url.substring(colonPos + 1));
            this._hostName = slashPos > 0 ? url.substring(slashPos + 1, colonPos) : url.substring(0, colonPos);
        }
    }

    private synchronized void init() {
        this._dataSource = null;
        this._userTransaction = null;
        this._jndiMap = null;
        this._initialContext = null;
    }

    static {
        SeasarContext.configure();
    }
}

