/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.seasar.util.Reflector;

public final class SMap
extends AbstractMap
implements Map,
Cloneable,
Externalizable {
    private static final int INITIAL_CAPACITY = 17;
    private static final float LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1383533715771521971L;
    private transient int _threshold;
    private transient Entry[] _mapTable;
    private transient int _size = 0;
    private transient Set _entrySet = null;

    public SMap() {
        this(17);
    }

    public SMap(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 17;
        }
        this._mapTable = new Entry[initialCapacity];
        this._threshold = (int)((float)initialCapacity * 0.75f);
    }

    public SMap(Map map) {
        this((int)((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final boolean containsValue(Object value) {
        Entry[] tab = this._mapTable;
        if (value == null) {
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (e._value == null) {
                        return true;
                    }
                    e = e._next;
                }
            }
        } else {
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e._value)) {
                        return true;
                    }
                    e = e._next;
                }
            }
        }
        return false;
    }

    public final boolean containsKey(Object key) {
        Entry[] tab = this._mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    return true;
                }
                e = e._next;
            }
        } else {
            Entry e = tab[0];
            while (e != null) {
                if (e._key == null) {
                    return true;
                }
                e = e._next;
            }
        }
        return false;
    }

    public final Object get(Object key) {
        Entry[] tab = this._mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    return e._value;
                }
                e = e._next;
            }
        } else {
            Entry e = tab[0];
            while (e != null) {
                if (e._key == null) {
                    return e._value;
                }
                e = e._next;
            }
        }
        return null;
    }

    public final Object put(Object key, Object value) {
        Entry e;
        Entry[] tab = this._mapTable;
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % tab.length;
            e = tab[index];
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    return this.swapValue(e, value);
                }
                e = e._next;
            }
        } else {
            e = tab[0];
            while (e != null) {
                if (e._key == null) {
                    return this.swapValue(e, value);
                }
                e = e._next;
            }
        }
        this.ensureCapacity();
        tab = this._mapTable;
        index = (hashCode & Integer.MAX_VALUE) % tab.length;
        tab[index] = e = new Entry(hashCode, key, value, tab[index]);
        ++this._size;
        return null;
    }

    public final Object remove(Object key) {
        Entry e = this.removeMap(key);
        if (e != null) {
            Object old = e._value;
            e.clear();
            return old;
        }
        return null;
    }

    public final void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public final void clear() {
        for (int i = 0; i < this._mapTable.length; ++i) {
            this._mapTable[i] = null;
        }
        this._size = 0;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map) || o == null) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
            return false;
        }
        return true;
    }

    public final Object clone() {
        try {
            SMap copy = (SMap)super.clone();
            copy._mapTable = new Entry[this._mapTable.length];
            for (int i = 0; i < this._mapTable.length; ++i) {
                copy._mapTable[i] = this._mapTable[i] != null ? (Entry)this._mapTable[i].clone() : null;
            }
            copy._entrySet = null;
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public final Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new SMapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    int index = (entry._hashCode & Integer.MAX_VALUE) % SMap.this._mapTable.length;
                    Entry e = SMap.this._mapTable[index];
                    while (e != null) {
                        if (e.equals(entry)) {
                            return true;
                        }
                        e = e._next;
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    return SMap.this.remove(entry._key) != null;
                }

                public int size() {
                    return SMap.this._size;
                }

                public void clear() {
                    SMap.this.clear();
                }
            };
        }
        return this._entrySet;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        Entry[] tab = this._mapTable;
        out.writeInt(tab.length);
        out.writeInt(this._size);
        for (int i = 0; i < tab.length; ++i) {
            Entry entry = tab[i];
            while (entry != null) {
                out.writeObject(entry._key);
                out.writeObject(entry._value);
                entry = entry._next;
            }
        }
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int num = in.readInt();
        this._mapTable = new Entry[num];
        this._threshold = (int)((float)num * 0.75f);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    private final Entry removeMap(Object key) {
        Entry[] tab = this._mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    if (prev != null) {
                        prev._next = e._next;
                    } else {
                        tab[index] = e._next;
                    }
                    --this._size;
                    return e;
                }
                prev = e;
                e = e._next;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                if (e._key == null) {
                    if (prev != null) {
                        prev._next = e._next;
                    } else {
                        tab[0] = e._next;
                    }
                    --this._size;
                    return e;
                }
                prev = e;
                e = e._next;
            }
        }
        return null;
    }

    private final void ensureCapacity() {
        if (this._size >= this._threshold) {
            int oldCapacity = this._mapTable.length;
            Entry[] oldTab = this._mapTable;
            int newCapacity = oldCapacity * 2 + 1;
            Entry[] newTab = new Entry[newCapacity];
            this._threshold = (int)((float)newCapacity * 0.75f);
            this._mapTable = newTab;
            for (int i = 0; i < oldCapacity; ++i) {
                Entry old = oldTab[i];
                while (old != null) {
                    Entry e = old;
                    old = old._next;
                    int index = (e._hashCode & Integer.MAX_VALUE) % newCapacity;
                    e._next = newTab[index];
                    newTab[index] = e;
                }
            }
        }
    }

    private final Object swapValue(Entry entry, Object value) {
        Object old = entry._value;
        entry._value = value;
        return old;
    }

    private static final class Entry
    implements Map.Entry,
    Externalizable {
        transient int _hashCode;
        transient Object _key;
        transient Object _value;
        transient Entry _next;

        public Entry(int hashCode, Object key, Object value, Entry next) {
            this._hashCode = hashCode;
            this._key = key;
            this._value = value;
            this._next = next;
        }

        public Object clone() {
            Object value = this._value;
            if (value instanceof Cloneable) {
                value = Reflector.clone(value);
            }
            return new Entry(this._hashCode, this._key, value, this._next == null ? null : (Entry)this._next.clone());
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        public void clear() {
            this._key = null;
            this._value = null;
            this._next = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Entry e = (Entry)o;
            return (this._key != null ? this._key.equals(e._key) : e._key == null) && (this._value != null ? this._value.equals(e._value) : e._value == null);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public String toString() {
            return this._key + "=" + this._value;
        }

        public void writeExternal(ObjectOutput s) throws IOException {
            s.writeInt(this._hashCode);
            s.writeObject(this._key);
            s.writeObject(this._value);
            s.writeObject(this._next);
        }

        public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
            this._hashCode = s.readInt();
            this._key = s.readObject();
            this._value = s.readObject();
            this._next = (Entry)s.readObject();
        }
    }

    private final class SMapIterator
    implements Iterator {
        private int _index;
        private Entry _entry;
        private Entry _lastReturned;

        private SMapIterator() {
            this._index = SMap.this._mapTable.length;
            this._entry = null;
            this._lastReturned = null;
        }

        public boolean hasNext() {
            Entry e = this._entry;
            int i = this._index;
            Entry[] t = SMap.this._mapTable;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this._entry = e;
            this._index = i;
            return e != null;
        }

        public Object next() {
            Entry et = this._entry;
            int i = this._index;
            Entry[] t = SMap.this._mapTable;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this._entry = et;
            this._index = i;
            if (et != null) {
                Entry e = this._lastReturned = this._entry;
                this._entry = e._next;
                return e;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            SMap.this.remove(this._lastReturned._key);
            this._lastReturned = null;
        }
    }
}

