/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.jar.JarFile;
import org.seasar.util.Assertion;
import org.seasar.util.SeasarRuntimeException;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static boolean isExist(String name) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(ResourceUtil.resolveName(name)) != null;
    }

    public static String resolveName(String name) {
        return ResourceUtil.resolveName(name, null);
    }

    public static String resolveName(String name, String extension) {
        String ext;
        String string = ext = extension != null ? "." + extension : "";
        if (name.indexOf(47) >= 0) {
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (name.indexOf(46) > 0) {
                return name;
            }
            return name + ext;
        }
        if (extension != null) {
            if (name.endsWith(extension)) {
                name = ResourceUtil.trimExtension(name, extension);
            }
        } else {
            int pos = name.indexOf(46);
            int pos2 = name.lastIndexOf(46);
            if (pos > 0 && pos == pos2) {
                return name;
            }
        }
        return name.replace('.', '/') + ext;
    }

    public static String unresolveName(String name, String extension) {
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return ResourceUtil.trimExtension(name, extension).replace('/', '.');
    }

    public static String trimExtension(String name, String extension) {
        int extPos = name.lastIndexOf("." + extension);
        if (extPos >= 0) {
            return name.substring(0, extPos);
        }
        int lastPeriodPos = name.lastIndexOf(46);
        if (lastPeriodPos < 0) {
            return name;
        }
        int lastPeriodPos2 = name.lastIndexOf(46, lastPeriodPos - 1);
        if (lastPeriodPos2 < 0) {
            return name.substring(0, lastPeriodPos);
        }
        return name;
    }

    public static InputStream getResourceAsStream(String name) {
        return ResourceUtil.getResourceAsStream(name, null);
    }

    public static InputStream getResourceAsStream(String name, String extension) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(ResourceUtil.resolveName(name, extension));
        if (is != null) {
            return is;
        }
        throw new SeasarRuntimeException("ESSR0001", new Object[]{ResourceUtil.resolveName(name, extension)});
    }

    public static URL getResource(String name) {
        return ResourceUtil.getResource(name, null);
    }

    public static URL getResource(String name, String extension) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(ResourceUtil.resolveName(name, extension));
        if (url != null) {
            return url;
        }
        throw new SeasarRuntimeException("ESSR0001", new Object[]{ResourceUtil.resolveName(name, extension)});
    }

    public static final File getFile(String path) {
        return ResourceUtil.getFile(path, null);
    }

    public static final String toExternalForm(URL url) {
        String s = url.toExternalForm();
        try {
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static final String getFileName(URL url) {
        String s = url.getFile();
        try {
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static final File getFile(String path, String extension) {
        URL url = ResourceUtil.getResource(path, extension);
        Assertion.assertFound("path", url);
        return new File(ResourceUtil.getFileName(url));
    }

    public static long getLastModified(URL url) {
        String fileName = ResourceUtil.getFileName(url);
        if (fileName.startsWith("file:")) {
            int pos = fileName.indexOf(33);
            fileName = fileName.substring(5, pos);
        }
        return new File(fileName).lastModified();
    }

    public static Properties getProperties(String name) {
        if (name.charAt(0) == '/') {
            return ResourceUtil.getProperties(name, null);
        }
        return ResourceUtil.getProperties(name, "properties");
    }

    public static Properties getProperties(String name, String extension) {
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream(name, extension);
        try {
            props.load(is);
            return props;
        }
        catch (IOException ex) {
            throw new SeasarRuntimeException("ESSR0008", new Object[]{ResourceUtil.resolveName(name, extension), ex}, (Throwable)ex);
        }
    }

    public static File getFileFromClassPath(String name) {
        String classPath = System.getProperty("java.class.path");
        int pos = classPath.indexOf(name);
        if (pos < 0) {
            throw new SeasarRuntimeException("ESSR0009", new Object[]{name, classPath});
        }
        int start = classPath.lastIndexOf(System.getProperty("path.separator"), pos) + 1;
        int end = classPath.indexOf(System.getProperty("path.separator"), pos);
        String location = end > 0 ? classPath.substring(start, end) : classPath.substring(start);
        return new File(location);
    }

    public static boolean isJarFile(File file) {
        try {
            new JarFile(file, true);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isAvailableDirectory(File file) {
        return file.isDirectory() && file.exists() && file.canRead();
    }

    public static void close(InputStream is) {
        try {
            is.close();
        }
        catch (IOException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static final byte[] getBytes(URL url) {
        try {
            return ResourceUtil.getBytes(url.openStream());
        }
        catch (IOException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static final byte[] getBytes(File file) {
        try {
            return ResourceUtil.getBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static final byte[] getBytes(InputStream is) {
        byte[] bytes = null;
        byte[] buf = new byte[8192];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, n);
            }
            bytes = baos.toByteArray();
        }
        catch (IOException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
        finally {
            if (is != null) {
                ResourceUtil.close(is);
            }
        }
        return bytes;
    }

    public static String getExtension(String name) {
        int extPos = name.lastIndexOf(".");
        if (extPos >= 0) {
            return name.substring(extPos + 1);
        }
        return "";
    }
}

