/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.seasar.util.ArrayUtil;
import org.seasar.util.EMap;
import org.seasar.util.PropertyDesc;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.StringUtil;

public class Reflector {
    private static Map _methodsMapMap = new SMap();
    private static Map _writeMethodMapMap = new SMap();
    private static Map _propertyDescMapCache = new SMap();
    private Class _targetClass;
    private Object _target;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;

    private Reflector(Class targetClass, Object target) {
        this._targetClass = targetClass;
        this._target = target;
    }

    public static Class getClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new SeasarRuntimeException("ESSR0008", new Object[]{className, ex}, (Throwable)ex);
        }
    }

    public static Object newInstance(String className) {
        return Reflector.newInstance(Reflector.getClass(className));
    }

    public static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new SeasarRuntimeException("ESSR0008", new Object[]{clazz.getName(), ex}, (Throwable)ex);
        }
    }

    public static Object newInstance(String className, Object[] arguments) {
        return Reflector.newInstance(Reflector.getClass(className), arguments);
    }

    public static Object newInstance(Class clazz, Object[] arguments) {
        Constructor constructor = Reflector.getConstructor(clazz, arguments);
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception ex) {
            throw new SeasarRuntimeException("ESSR0008", new Object[]{clazz.getName(), ex}, (Throwable)ex);
        }
    }

    public static Method getMethod(String className, String methodName, Class[] parameterTypes) {
        return Reflector.getMethod(Reflector.getClass(className), methodName, parameterTypes);
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parameterTypes) {
        if (parameterTypes == null) {
            parameterTypes = ArrayUtil.EMPTY_CLASSES;
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ignore) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName) || !ArrayUtil.equals(methods[i].getParameterTypes(), parameterTypes)) continue;
                methods[i].setAccessible(true);
                return methods[i];
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return Reflector.getMethod(superClass, methodName, parameterTypes);
            }
            throw new SeasarRuntimeException("ESSR0009", new Object[]{methodName, clazz.getName()});
        }
    }

    public static Map getConstants(String className) {
        return Reflector.getConstants(Reflector.getClass(className));
    }

    public static Map getConstants(Class clazz) {
        SMap ret = new SMap();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
            String name = fields[i].getName();
            Object value = Reflector.getFieldValue(fields[i], clazz);
            ret.put(name, value);
        }
        return ret;
    }

    public static Field getField(Class clazz, String fieldName) {
        try {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(fieldName)) continue;
                fields[i].setAccessible(true);
                return fields[i];
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return Reflector.getField(superClass, fieldName);
            }
            return null;
        }
        catch (Exception ex) {
            throw new SeasarRuntimeException("ESSR0009", new Object[]{fieldName, clazz.getName()}, (Throwable)ex);
        }
    }

    public static List getMethods(Class clazz, String methodName) {
        Map methodsMap = Reflector.getMethodsMap(clazz);
        List ret = (List)methodsMap.get(methodName);
        if (ret == null) {
            throw new SeasarRuntimeException("ESSR0009", new Object[]{methodName, clazz.getName()});
        }
        return ret;
    }

    public static List getMethods(Class clazz, String methodName, int argSize) {
        ArrayList<Method> ret = new ArrayList<Method>();
        List methods = Reflector.getMethods(clazz, methodName);
        for (int i = 0; i < methods.size(); ++i) {
            Method m = (Method)methods.get(i);
            if (m.getParameterTypes().length != argSize) continue;
            ret.add(m);
        }
        return ret;
    }

    public static Constructor getConstructor(String className, Object[] args) {
        return Reflector.getConstructor(Reflector.getClass(className), args);
    }

    public static Constructor getConstructor(Class clazz, Object[] args) {
        if (args == null) {
            args = ArrayUtil.EMPTY_OBJECTS;
        }
        if (args.length == 0) {
            try {
                return clazz.getConstructor(null);
            }
            catch (NoSuchMethodException ex) {
                throw new SeasarRuntimeException("ESSR0008", new Object[]{clazz.getName(), ex}, (Throwable)ex);
            }
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        block2: for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] parameterTypes = constructors[i].getParameterTypes();
            if (parameterTypes.length != args.length) continue;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (!Reflector.isSameType(parameterTypes[j], args[j])) continue block2;
            }
            constructors[i].setAccessible(true);
            return constructors[i];
        }
        throw new SeasarRuntimeException("ESSR0009", new Object[]{"Constructor", clazz.getName()});
    }

    public static boolean isSameType(Class clazz, Object object) {
        if (object == null) {
            return !clazz.isPrimitive();
        }
        if (clazz.isInstance(object)) {
            return true;
        }
        return clazz == Reflector.getPrimitiveClass(object.getClass());
    }

    public static Class getPrimitiveClass(Class clazz) {
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Reflector.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Reflector.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Reflector.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Reflector.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Reflector.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Reflector.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Reflector.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        return null;
    }

    public static Reflector create(String className) {
        return Reflector.create(className, ArrayUtil.EMPTY_OBJECTS);
    }

    public static Reflector create(String className, Object[] args) {
        if (className == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"className"});
        }
        Class targetClass = Reflector.getClass(className);
        Object target = Reflector.newInstance(targetClass, args);
        return new Reflector(targetClass, target);
    }

    public static Reflector create(String className, String methodName) {
        return Reflector.create(className, methodName, ArrayUtil.EMPTY_OBJECTS);
    }

    public static Reflector create(String className, String methodName, Object[] args) {
        return Reflector.create(Reflector.getClass(className), methodName, args);
    }

    public static Reflector create(Class clazz, String methodName, Object[] args) {
        if (clazz == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"clazz"});
        }
        if (methodName == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"methodName"});
        }
        Object target = null;
        Method method = Reflector.getMethodByArgs(clazz, methodName, args);
        try {
            target = method.invoke((Object)clazz, args);
        }
        catch (Exception ex) {
            throw new SeasarRuntimeException("ESSR0017", new Object[]{ex}, (Throwable)ex);
        }
        return new Reflector(clazz, target);
    }

    public static boolean isDeclaredException(Method method, Class exceptionClass) {
        Class<?>[] exTypes = method.getExceptionTypes();
        for (int i = 0; i < exTypes.length; ++i) {
            if (!exTypes[i].isAssignableFrom(exceptionClass)) continue;
            return true;
        }
        return false;
    }

    public static Object invoke(Method method, Object target, Object[] args) throws SeasarException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
        catch (IllegalArgumentException ex2) {
            throw SeasarException.convertSeasarException(ex2);
        }
        catch (InvocationTargetException ex3) {
            Throwable t = ex3.getTargetException();
            if (t instanceof SeasarException) {
                throw (SeasarException)t;
            }
            if (t instanceof SeasarRuntimeException) {
                throw (SeasarRuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw SeasarException.convertSeasarException(t);
        }
    }

    public static Object invokeNoException(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
        catch (IllegalArgumentException ex2) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex2);
        }
        catch (InvocationTargetException ex3) {
            Throwable t = ex3.getTargetException();
            throw SeasarRuntimeException.convertSeasarRuntimeException(t);
        }
    }

    public static Object invoke(String targetClassName, String methodName, Object[] args) throws SeasarException {
        return Reflector.invoke(Reflector.getClass(targetClassName), methodName, args);
    }

    public static Object invoke(Class targetClass, String methodName, Object[] args) throws SeasarException {
        Method m = Reflector.getMethodByArgs(targetClass, methodName, args);
        try {
            return m.invoke((Object)targetClass, args);
        }
        catch (Exception ex) {
            throw new SeasarException("ESSR0017", new Object[]{ex}, (Throwable)ex);
        }
    }

    public static Object invoke(Object target, String methodName, Object[] args) throws SeasarException {
        Method m = Reflector.getMethodByArgs(target.getClass(), methodName, args);
        try {
            return m.invoke(target, args);
        }
        catch (Exception ex) {
            throw new SeasarException("ESSR0017", new Object[]{ex}, (Throwable)ex);
        }
    }

    public static Object invokeNoException(Object target, String methodName, Object[] args) {
        try {
            Method m = Reflector.getMethodByArgs(target.getClass(), methodName, args);
            return m.invoke(target, args);
        }
        catch (Exception ex) {
            throw new SeasarRuntimeException("ESSR0017", new Object[]{ex}, (Throwable)ex);
        }
    }

    public static Object clone(Object target) {
        if (target == null) {
            return null;
        }
        Class<?> clazz = target.getClass();
        if (clazz.isArray()) {
            return ArrayUtil.clone((Object[])target);
        }
        try {
            return Reflector.invoke(target, "clone", ArrayUtil.EMPTY_OBJECTS);
        }
        catch (SeasarException ex) {
            throw ex.convertSeasarRuntimeException();
        }
    }

    public static String decapitalizePropertyName(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void setProperties(Object target, Properties properties) {
        if (properties == null) {
            return;
        }
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = properties.getProperty(key);
            Reflector.setProperty(target, key, value);
        }
    }

    public static void setProperties(Object target, Map properties) {
        if (properties == null) {
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = null;
            Object o = properties.get(key);
            if (o instanceof String) {
                value = (String)o;
            }
            Reflector.setProperty(target, key, value);
        }
    }

    public static Method getReadMethod(Class clazz, String propertyName) {
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method m = Reflector.getMethod(clazz, methodName, ArrayUtil.EMPTY_CLASSES);
        if (m == null) {
            throw new SeasarRuntimeException("ESSR0009", new Object[]{methodName, clazz.getName()});
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EMap getPropertyDescMap(Class clazz) {
        String key = clazz.getName().intern();
        EMap map = (EMap)_propertyDescMapCache.get(key);
        if (map != null) {
            return map;
        }
        Map map2 = _propertyDescMapCache;
        synchronized (map2) {
            map = (EMap)_propertyDescMapCache.get(key);
            if (map == null) {
                map = Reflector.newPropertyDescMap(clazz);
                _propertyDescMapCache.put(key, map);
            }
        }
        return map;
    }

    public static EMap newPropertyDescMap(Class clazz) {
        EMap map = new EMap();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            PropertyDesc propDesc;
            Class<?> propertyType;
            String propertyName;
            Method m = methods[i];
            String methodName = m.getName();
            if (methodName.startsWith("get")) {
                if (m.getParameterTypes().length != 0 || methodName.equals("getClass")) continue;
                propertyName = Reflector.decapitalizePropertyName(methodName.substring(3)).intern();
                propertyType = m.getReturnType();
                propDesc = (PropertyDesc)map.get(propertyName);
                if (propDesc != null) {
                    if (!propDesc.getPropertyType().equals(propertyType)) {
                        throw new SeasarRuntimeException("ESSR0361", (Object)propertyName, (Object)propDesc.getPropertyType(), propertyType);
                    }
                    propDesc.setReadMethod(m);
                    continue;
                }
                propDesc = new PropertyDesc(propertyName, propertyType, m, null);
                map.put(propertyName, propDesc);
                continue;
            }
            if (methodName.startsWith("is")) {
                if (m.getParameterTypes().length != 0 || !m.getReturnType().equals(Boolean.TYPE)) continue;
                propertyName = Reflector.decapitalizePropertyName(methodName.substring(2)).intern();
                propertyType = m.getReturnType();
                propDesc = (PropertyDesc)map.get(propertyName);
                if (propDesc != null) {
                    if (!propDesc.getPropertyType().equals(propertyType)) {
                        throw new SeasarRuntimeException("ESSR0361", (Object)propertyName, (Object)propDesc.getPropertyType(), propertyType);
                    }
                    propDesc.setReadMethod(m);
                    continue;
                }
                propDesc = new PropertyDesc(propertyName, propertyType, m, null);
                map.put(propertyName, propDesc);
                continue;
            }
            if (!methodName.startsWith("set") || m.getParameterTypes().length != 1 || methodName.equals("setClass")) continue;
            propertyName = Reflector.decapitalizePropertyName(methodName.substring(3)).intern();
            propertyType = m.getParameterTypes()[0];
            propDesc = (PropertyDesc)map.get(propertyName);
            if (propDesc != null) {
                if (!propDesc.getPropertyType().equals(propertyType)) {
                    throw new SeasarRuntimeException("ESSR0361", (Object)propertyName, (Object)propDesc.getPropertyType(), propertyType);
                }
                propDesc.setWriteMethod(m);
                continue;
            }
            propDesc = new PropertyDesc(propertyName, propertyType, null, m);
            map.put(propertyName, propDesc);
        }
        return map;
    }

    public static Object getProperty(Object target, String name) {
        Method m = Reflector.getReadMethod(target.getClass(), name);
        try {
            return Reflector.invoke(m, target, ArrayUtil.EMPTY_OBJECTS);
        }
        catch (Exception ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static Method getWriteMethod(Class clazz, String propertyName) {
        String methodName;
        Map setMethodMap = Reflector.getWriteMethodMap(clazz);
        Method m = (Method)setMethodMap.get(methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1));
        if (m == null) {
            throw new SeasarRuntimeException("ESSR0001", new Object[]{methodName});
        }
        return m;
    }

    public static void setProperty(Object target, String name, String value) {
        Method m = Reflector.getWriteMethod(target.getClass(), name);
        Class<?>[] types = m.getParameterTypes();
        try {
            if (types[0].isPrimitive()) {
                if (types[0] == Integer.TYPE) {
                    m.invoke(target, Integer.valueOf(value));
                } else if (types[0] == Boolean.TYPE) {
                    m.invoke(target, Boolean.valueOf(value));
                } else if (types[0] == Long.TYPE) {
                    m.invoke(target, Long.valueOf(value));
                } else if (types[0] == Short.TYPE) {
                    m.invoke(target, Short.valueOf(value));
                } else if (types[0] == Double.TYPE) {
                    m.invoke(target, Double.valueOf(value));
                } else if (types[0] == Float.TYPE) {
                    m.invoke(target, Float.valueOf(value));
                } else if (types[0] == Character.TYPE) {
                    m.invoke(target, new Character(value.toCharArray()[0]));
                }
            } else {
                m.invoke(target, value);
            }
        }
        catch (Exception ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static void setProperty2(Object target, String name, Object value) {
        Method m = Reflector.getWriteMethod(target.getClass(), name);
        Reflector.invokeNoException(m, target, new Object[]{value});
    }

    public static void setFieldValue(Object target, String fieldName, Object value) throws SeasarException {
        Field field = Reflector.getField(target.getClass(), fieldName);
        if (field != null) {
            try {
                field.set(target, value);
            }
            catch (Exception ex) {
                throw new SeasarException("ESSR0017", new Object[]{ex}, (Throwable)ex);
            }
        } else {
            throw new SeasarException("ESSR0009", new Object[]{fieldName, target.getClass().getName()});
        }
    }

    public static Object getFieldValue(Object target, String fieldName) {
        Field field = Reflector.getField(target.getClass(), fieldName);
        if (field != null) {
            return Reflector.getFieldValue(field, target);
        }
        throw new SeasarRuntimeException("ESSR0009", new Object[]{fieldName, target.getClass().getName()});
    }

    public static Object getFieldValue(Class clazz, String fieldName) {
        Field field = Reflector.getField(clazz, fieldName);
        if (field != null) {
            return Reflector.getFieldValue(field, clazz);
        }
        throw new SeasarRuntimeException("ESSR0009", new Object[]{fieldName, clazz.getName()});
    }

    public static Object getFieldValue(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (Exception ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public static String toStringForBean(Object bean) {
        try {
            StringBuffer buf = new StringBuffer(100);
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] propertyDescs = beanInfo.getPropertyDescriptors();
            buf.append("{");
            for (int i = 0; i < propertyDescs.length; ++i) {
                String name = propertyDescs[i].getName();
                Method m = propertyDescs[i].getReadMethod();
                if (m == null || name.equals("class")) continue;
                Object value = Reflector.invokeNoException(m, bean, ArrayUtil.EMPTY_OBJECTS);
                buf.append(name).append("=").append(value).append(",");
            }
            buf.setLength(buf.length() - 1);
            buf.append("}");
            return buf.toString();
        }
        catch (IntrospectionException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public Class getTargetClass() {
        return this._targetClass;
    }

    public Object getTarget() {
        return this._target;
    }

    public Object invoke(String methodName) throws SeasarException {
        return this.invoke(methodName, ArrayUtil.EMPTY_OBJECTS);
    }

    public Object invoke(String methodName, Object[] args) throws SeasarException {
        Method m = Reflector.getMethodByArgs(this._targetClass, methodName, args);
        try {
            if (Modifier.isStatic(m.getModifiers())) {
                return m.invoke((Object)this._targetClass, args);
            }
            return m.invoke(this._target, args);
        }
        catch (Exception ex) {
            throw new SeasarException("ESSR0008", new Object[]{methodName, ex}, (Throwable)ex);
        }
    }

    public Object invokeNoException(String methodName, Object[] args) {
        try {
            return this.invoke(methodName, args);
        }
        catch (SeasarException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private static Method getMethodByArgs(Class clazz, String methodName, Object[] args) {
        List methods;
        if (args == null) {
            args = ArrayUtil.EMPTY_OBJECTS;
        }
        if ((methods = Reflector.getMethods(clazz, methodName)).size() == 1) {
            return (Method)methods.get(0);
        }
        block0: for (int i = 0; i < methods.size(); ++i) {
            Method m = (Method)methods.get(i);
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (parameterTypes.length != args.length) continue;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (!Reflector.isSameType(parameterTypes[j], args[j])) continue block0;
            }
            return m;
        }
        throw new SeasarRuntimeException("ESSR0009", new Object[]{methodName, clazz.getName()});
    }

    private static Map newMethodsMap(Class clazz) {
        SMap methodsMap = new SMap();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            ArrayList<Method> list = (ArrayList<Method>)methodsMap.get(methods[i].getName());
            if (list == null) {
                list = new ArrayList<Method>();
                methodsMap.put(methods[i].getName(), list);
            }
            list.add(methods[i]);
        }
        return methodsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getWriteMethodMap(Class clazz) {
        Map writeMethodMap = (Map)_writeMethodMapMap.get(clazz);
        if (writeMethodMap != null) {
            return writeMethodMap;
        }
        Map map = _writeMethodMapMap;
        synchronized (map) {
            if (writeMethodMap == null) {
                writeMethodMap = Reflector.newWriteMethodMap(clazz);
                _writeMethodMapMap.put(clazz, writeMethodMap);
            }
        }
        return writeMethodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getMethodsMap(Class clazz) {
        Map methodsMap = (Map)_methodsMapMap.get(clazz);
        if (methodsMap != null) {
            return methodsMap;
        }
        Map map = _methodsMapMap;
        synchronized (map) {
            methodsMap = (Map)_methodsMapMap.get(clazz);
            if (methodsMap == null) {
                methodsMap = Reflector.newMethodsMap(clazz);
                _methodsMapMap.put(clazz, methodsMap);
            }
        }
        return methodsMap;
    }

    private static Map newWriteMethodMap(Class clazz) {
        Method[] methods = clazz.getMethods();
        SMap setMethodMap = new SMap();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith("set") || methods[i].getParameterTypes().length != 1) continue;
            setMethodMap.put(methodName, methods[i]);
        }
        return setMethodMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

