/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.lang.reflect.Method;
import org.seasar.util.ArrayUtil;
import org.seasar.util.Assertion;
import org.seasar.util.Reflector;

public final class PropertyDesc {
    private String _propertyName;
    private Class _propertyType;
    private Method _readMethod;
    private Method _writeMethod;

    public PropertyDesc(String propertyName, Class propertyType, Method readMethod, Method writeMethod) {
        Assertion.assertNotNull("propertyName", propertyName);
        Assertion.assertNotNull("propertyType", propertyType);
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._readMethod = readMethod;
        this._writeMethod = writeMethod;
    }

    public final String getPropertyName() {
        return this._propertyName;
    }

    public final Class getPropertyType() {
        return this._propertyType;
    }

    public final Method getReadMethod() {
        return this._readMethod;
    }

    public final void setReadMethod(Method readMethod) {
        this._readMethod = readMethod;
    }

    public final Method getWriteMethod() {
        return this._writeMethod;
    }

    public final void setWriteMethod(Method writeMethod) {
        this._writeMethod = writeMethod;
    }

    public final Object getValue(Object target) {
        return Reflector.invokeNoException(this._readMethod, target, ArrayUtil.EMPTY_OBJECTS);
    }

    public final void setValue(Object target, Object value) {
        Reflector.invokeNoException(this._writeMethod, target, new Object[]{value});
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("propertyName=");
        buf.append(this._propertyName);
        buf.append(",propertyType=");
        buf.append(this._propertyType.getName());
        buf.append(",readMethod=");
        buf.append(this._readMethod != null ? this._readMethod.getName() : "null");
        buf.append(",writeMethod=");
        buf.append(this._writeMethod != null ? this._writeMethod.getName() : "null");
        return buf.toString();
    }
}

