/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.Sorter;

public final class EMap
extends AbstractMap
implements Map,
Cloneable,
Externalizable {
    static final long serialVersionUID = -6319986824963561001L;
    private static final int INITIAL_CAPACITY = 17;
    private static final float LOAD_FACTOR = 0.75f;
    private transient int _threshold;
    private transient Entry[] _mapTable;
    private transient Entry[] _listTable;
    private transient int _size = 0;
    private transient Set _entrySet = null;

    public EMap() {
        this(17);
    }

    public EMap(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 17;
        }
        this._mapTable = new Entry[initialCapacity];
        this._listTable = new Entry[initialCapacity];
        this._threshold = (int)((float)initialCapacity * 0.75f);
    }

    public EMap(Map map) {
        this((int)((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final boolean containsValue(Object value) {
        return this.indexOf(value) >= 0;
    }

    public final int indexOf(Object value) {
        if (value != null) {
            for (int i = 0; i < this._size; ++i) {
                if (!value.equals(this._listTable[i]._value)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._size; ++i) {
                if (this._listTable[i]._value != null) continue;
                return i;
            }
        }
        return -1;
    }

    public final boolean containsKey(Object key) {
        Entry[] mapTable = this._mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % mapTable.length;
            Entry e = mapTable[index];
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    return true;
                }
                e = e._next;
            }
        } else {
            Entry e = mapTable[0];
            while (e != null) {
                if (e._key == null) {
                    return true;
                }
                e = e._next;
            }
        }
        return false;
    }

    public final Object get(Object key) {
        Entry[] mapTable = this._mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % mapTable.length;
            Entry e = mapTable[index];
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    return e._value;
                }
                e = e._next;
            }
        } else {
            Entry e = mapTable[0];
            while (e != null) {
                if (e._key == null) {
                    return e._value;
                }
                e = e._next;
            }
        }
        return null;
    }

    public final Object get(int index) {
        return this.getEntry((int)index)._value;
    }

    public final Object getKey(int index) {
        return this.getEntry((int)index)._key;
    }

    public final Entry getEntry(int index) {
        if (index >= this._size) {
            throw new SeasarRuntimeException("ESSR0012", new Object[]{Integer.toString(index), Integer.toString(this._size)});
        }
        return this._listTable[index];
    }

    public final List getList() {
        return new EMapList();
    }

    public final Object put(Object key, Object value) {
        Entry e;
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this._mapTable.length;
            e = this._mapTable[index];
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    return this.swapValue(e, value);
                }
                e = e._next;
            }
        } else {
            e = this._mapTable[0];
            while (e != null) {
                if (e._key == null) {
                    return this.swapValue(e, value);
                }
                e = e._next;
            }
        }
        this.ensureCapacity();
        index = (hashCode & Integer.MAX_VALUE) % this._mapTable.length;
        this._mapTable[index] = e = new Entry(hashCode, key, value, this._mapTable[index]);
        this._listTable[this._size++] = e;
        return null;
    }

    public final Object put(int index, Object key, Object value) {
        Entry e;
        int hashCode = 0;
        int mapIndex = 0;
        if (key != null) {
            hashCode = key.hashCode();
            mapIndex = (hashCode & Integer.MAX_VALUE) % this._mapTable.length;
            e = this._mapTable[mapIndex];
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    return this.swapValue(index, e, value);
                }
                e = e._next;
            }
        } else {
            e = this._mapTable[0];
            while (e != null) {
                if (e._key == null) {
                    return this.swapValue(index, e, value);
                }
                e = e._next;
            }
        }
        this.ensureCapacity();
        mapIndex = (hashCode & Integer.MAX_VALUE) % this._mapTable.length;
        this._mapTable[mapIndex] = e = new Entry(hashCode, key, value, this._mapTable[mapIndex]);
        this.addList(index, e);
        return null;
    }

    public final Object remove(Object key) {
        Entry e = this.removeMap(key);
        if (e != null) {
            Object value = e._value;
            this.removeList(this.indexOf(e));
            e.clear();
            return value;
        }
        return null;
    }

    public final Object remove(int index) {
        Entry e = this.removeList(index);
        Object value = e._value;
        this.removeMap(e._key);
        e._value = null;
        return value;
    }

    public final void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public final void clear() {
        int i;
        for (i = 0; i < this._mapTable.length; ++i) {
            this._mapTable[i] = null;
        }
        for (i = 0; i < this._listTable.length; ++i) {
            this._listTable[i] = null;
        }
        this._size = 0;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this._size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public final Object[] toArray(Object[] proto) {
        Object[] array = proto;
        if (proto.length < this._size) {
            array = (Object[])Array.newInstance(proto.getClass().getComponentType(), this._size);
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        if (array.length > this._size) {
            array[this._size] = null;
        }
        return array;
    }

    public final void sort() {
        EMapSorter sorter = new EMapSorter();
        sorter.sort(this._listTable, 0, this._size);
    }

    public final void sort(Comparator comparator) {
        EMapSorterForComparator sorter = new EMapSorterForComparator(comparator);
        sorter.sort(this._listTable, 0, this._size);
    }

    public final Object clone() {
        EMap emap = new EMap();
        emap._mapTable = new Entry[this._mapTable.length];
        emap._listTable = new Entry[this._listTable.length];
        for (int i = 0; i < this._size; ++i) {
            Entry e = (Entry)this._listTable[i].clone();
            emap.put(e._key, e._value);
        }
        emap._entrySet = null;
        return emap;
    }

    public final boolean equals(Object o) {
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        EMap e = (EMap)o;
        if (this._size != e._size) {
            return false;
        }
        for (int i = 0; i < this._size; ++i) {
            if (this._listTable[i].equals(e._listTable[i])) continue;
            return false;
        }
        return true;
    }

    public final Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new EMapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    int index = (entry._hashCode & Integer.MAX_VALUE) % EMap.this._mapTable.length;
                    Entry e = EMap.this._mapTable[index];
                    while (e != null) {
                        if (e.equals(entry)) {
                            return true;
                        }
                        e = e._next;
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    return EMap.this.remove(entry._key) != null;
                }

                public int size() {
                    return EMap.this._size;
                }

                public void clear() {
                    EMap.this.clear();
                }
            };
        }
        return this._entrySet;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._listTable.length);
        out.writeInt(this._size);
        for (int i = 0; i < this._size; ++i) {
            out.writeObject(this._listTable[i]._key);
            out.writeObject(this._listTable[i]._value);
        }
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int num = in.readInt();
        this._mapTable = new Entry[num];
        this._listTable = new Entry[num];
        this._threshold = (int)((float)num * 0.75f);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    private final void addList(int index, Entry entry) {
        this.checkHighRange(index);
        System.arraycopy(this._listTable, index, this._listTable, index + 1, this._size - index);
        this._listTable[index] = entry;
        ++this._size;
    }

    private final Entry removeMap(Object key) {
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this._mapTable.length;
            Entry e = this._mapTable[index];
            Entry prev = null;
            while (e != null) {
                if (e._hashCode == hashCode && key.equals(e._key)) {
                    if (prev != null) {
                        prev._next = e._next;
                    } else {
                        this._mapTable[index] = e._next;
                    }
                    return e;
                }
                prev = e;
                e = e._next;
            }
        } else {
            Entry e = this._mapTable[index];
            Entry prev = null;
            while (e != null) {
                if (e._hashCode == hashCode && e._key == null) {
                    if (prev != null) {
                        prev._next = e._next;
                    } else {
                        this._mapTable[index] = e._next;
                    }
                    return e;
                }
                prev = e;
                e = e._next;
            }
        }
        return null;
    }

    private final Entry removeList(int index) {
        Entry e = this._listTable[index];
        int numMoved = this._size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this._listTable, index + 1, this._listTable, index, numMoved);
        }
        this._listTable[--this._size] = null;
        return e;
    }

    private final int indexOf(Entry entry) {
        for (int i = 0; i < this._size; ++i) {
            if (this._listTable[i] != entry) continue;
            return i;
        }
        throw new SeasarRuntimeException("ESSR0001", new Object[]{entry});
    }

    private final void ensureCapacity() {
        if (this._size >= this._threshold) {
            Entry[] oldTable = this._listTable;
            int newCapacity = oldTable.length * 2 + 1;
            Entry[] newMapTable = new Entry[newCapacity];
            Entry[] newListTable = new Entry[newCapacity];
            this._threshold = (int)((float)newCapacity * 0.75f);
            System.arraycopy(oldTable, 0, newListTable, 0, this._size);
            for (int i = 0; i < this._size; ++i) {
                Entry old = oldTable[i];
                int index = (old._hashCode & Integer.MAX_VALUE) % newCapacity;
                Entry e = old;
                old = old._next;
                e._next = newMapTable[index];
                newMapTable[index] = e;
            }
            this._mapTable = newMapTable;
            this._listTable = newListTable;
        }
    }

    private final Object swapValue(Entry entry, Object value) {
        Object old = entry._value;
        entry._value = value;
        return old;
    }

    private final Object swapValue(int index, Entry entry, Object value) {
        Object old = this.swapValue(entry, value);
        this.removeList(this.indexOf(entry));
        this.addList(index, entry);
        return old;
    }

    private final void checkHighRange(int index) {
        if (index > this._size) {
            throw new ArrayIndexOutOfBoundsException("index:" + index);
        }
    }

    private class EMapSorterForComparator
    extends Sorter {
        private Comparator _comparator;

        EMapSorterForComparator(Comparator comparator) {
            if (comparator == null) {
                throw new SeasarRuntimeException("ESSR0007", new Object[]{"comparator"});
            }
            this._comparator = comparator;
        }

        protected int doCompare(Object o1, Object o2) {
            Object v = ((Entry)o1)._value;
            Object v2 = ((Entry)o2)._value;
            return this._comparator.compare(v, v2);
        }
    }

    private class EMapSorter
    extends Sorter {
        private EMapSorter() {
        }

        protected int doCompare(Object o1, Object o2) {
            Object v = ((Entry)o1)._value;
            Object v2 = ((Entry)o2)._value;
            return super.doCompare(v, v2);
        }
    }

    private class EMapList
    extends AbstractList
    implements Serializable {
        static final long serialVersionUID = -351835908133693895L;
        private Entry[] _array;

        EMapList() {
            this._array = new Entry[EMap.this._size];
            System.arraycopy(EMap.this._listTable, 0, this._array, 0, EMap.this._size);
        }

        public int size() {
            return this._array.length;
        }

        public Object get(int index) {
            return this._array[index]._value;
        }

        public Object set(int index, Object value) {
            Object oldValue = this.get(index);
            int originalIndex = this.indexOf(value);
            ((EMap)EMap.this)._listTable[index] = this._array[originalIndex];
            return oldValue;
        }

        public int indexOf(Object o) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return i;
            }
            return -1;
        }
    }

    private static class Entry
    implements Map.Entry,
    Externalizable {
        transient int _hashCode;
        transient Object _key;
        transient Object _value;
        transient Entry _next;

        public Entry(int hashCode, Object key, Object value, Entry next) {
            this._hashCode = hashCode;
            this._key = key;
            this._value = value;
            this._next = next;
        }

        public Object clone() {
            Object value = this._value;
            if (value instanceof Cloneable) {
                value = Reflector.clone(value);
            }
            return new Entry(this._hashCode, this._key, value, this._next == null ? null : (Entry)this._next.clone());
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        public void clear() {
            this._key = null;
            this._value = null;
            this._next = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Entry e = (Entry)o;
            return (this._key != null ? this._key.equals(e._key) : e._key == null) && (this._value != null ? this._value.equals(e._value) : e._value == null);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public String toString() {
            return this._key + "=" + this._value;
        }

        public void writeExternal(ObjectOutput s) throws IOException {
            s.writeInt(this._hashCode);
            s.writeObject(this._key);
            s.writeObject(this._value);
            s.writeObject(this._next);
        }

        public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
            this._hashCode = s.readInt();
            this._key = s.readObject();
            this._value = s.readObject();
            this._next = (Entry)s.readObject();
        }
    }

    private class EMapIterator
    implements Iterator {
        private int _current = 0;
        private int _last = -1;

        private EMapIterator() {
        }

        public boolean hasNext() {
            return this._current != EMap.this._size;
        }

        public Object next() {
            try {
                Entry n = EMap.this._listTable[this._current];
                this._last = this._current++;
                return n;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this._last == -1) {
                throw new IllegalStateException();
            }
            EMap.this.remove(this._last);
            if (this._last < this._current) {
                --this._current;
            }
            this._last = -1;
        }
    }
}

