/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;

public class ELinkedList
implements Cloneable,
Externalizable {
    static final long serialVersionUID = -6031901980461979602L;
    private transient Entry _header = new Entry(null, null, null);
    private transient int _size = 0;

    public ELinkedList() {
        this._header._next = (this._header._previous = this._header);
    }

    public Entry getFirstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this._header._next;
    }

    public Object getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFirstEntry()._element;
    }

    public Entry getLastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this._header._previous;
    }

    public Object getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLastEntry()._element;
    }

    public Object removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object first = this._header._next._element;
        this._header._next.remove();
        return first;
    }

    public Object removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object last = this._header._previous._element;
        this._header._previous.remove();
        return last;
    }

    public void addFirst(Object o) {
        this._header._next.addBefore(o);
    }

    public void addLast(Object o) {
        this._header.addBefore(o);
    }

    public void add(int index, Object element) {
        this.getEntry(index).addBefore(element);
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean remove(Object o) {
        if (o == null) {
            Entry e = this._header._next;
            while (e != this._header) {
                if (e._element == null) {
                    e.remove();
                    return true;
                }
                e = e._next;
            }
        } else {
            Entry e = this._header._next;
            while (e != this._header) {
                if (o.equals(e._element)) {
                    e.remove();
                    return true;
                }
                e = e._next;
            }
        }
        return false;
    }

    public Object remove(int index) {
        Entry e = this.getEntry(index);
        e.remove();
        return e._element;
    }

    public void clear() {
        this._header._next = (this._header._previous = this._header);
        this._size = 0;
    }

    public Entry getEntry(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._size);
        }
        Entry e = this._header;
        if (index < this._size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e._next;
            }
        } else {
            for (int i = this._size; i > index; --i) {
                e = e._previous;
            }
        }
        return e;
    }

    public Object get(int index) {
        return this.getEntry(index)._element;
    }

    public Object set(int index, Object element) {
        Entry e = this.getEntry(index);
        Object oldVal = e._element;
        e._element = element;
        return oldVal;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this._header._next;
            while (e != this._header) {
                if (e._element == null) {
                    return index;
                }
                ++index;
                e = e._next;
            }
        } else {
            Entry e = this._header._next;
            while (e != this._header) {
                if (o.equals(e._element)) {
                    return index;
                }
                ++index;
                e = e._next;
            }
        }
        return -1;
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeInt(this._size);
        Entry e = this._header._next;
        while (e != this._header) {
            s.writeObject(e._element);
            e = e._next;
        }
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this._header = new Entry(null, null, null);
        this._header._next = (this._header._previous = this._header);
        for (int i = 0; i < this._size; ++i) {
            this.addLast(s.readObject());
        }
    }

    public Object clone() {
        ELinkedList copy = new ELinkedList();
        Entry e = this._header._next;
        while (e != this._header) {
            copy.addLast(e._element);
            e = e._next;
        }
        return copy;
    }

    public Object[] toArray() {
        Object[] result = new Object[this._size];
        int i = 0;
        Entry e = this._header._next;
        while (e != this._header) {
            result[i++] = e._element;
            e = e._next;
        }
        return result;
    }

    public final class Entry {
        private Object _element;
        private Entry _next;
        private Entry _previous;

        Entry(Object element, Entry next, Entry previous) {
            this._element = element;
            this._next = next;
            this._previous = previous;
        }

        public Object getElement() {
            return this._element;
        }

        public Entry getNext() {
            if (this._next != ELinkedList.this._header) {
                return this._next;
            }
            return null;
        }

        public Entry getPrevious() {
            if (this._previous != ELinkedList.this._header) {
                return this._previous;
            }
            return null;
        }

        public void remove() {
            this._previous._next = this._next;
            this._next._previous = this._previous;
            ELinkedList.this._size--;
        }

        public Entry addBefore(Object o) {
            Entry newEntry;
            this._previous._next = newEntry = new Entry(o, this, this._previous);
            this._previous = newEntry;
            ELinkedList.this._size++;
            return newEntry;
        }
    }
}

