/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class EArrayList
extends AbstractCollection
implements List,
Cloneable,
Externalizable {
    static final long serialVersionUID = 1L;
    private transient Object[] _elements;
    private transient int _size = 0;

    public EArrayList() {
        this(10);
    }

    public EArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this._elements = new Object[initialCapacity];
    }

    public EArrayList(Collection c) {
        this._size = c.size();
        this._elements = new Object[this._size * 110 / 100];
        c.toArray(this._elements);
    }

    public EArrayList(Object[] array) {
        this.addAll(array);
    }

    public final void trimToSize() {
        Object[] oldElements = this._elements;
        this._elements = new Object[this._size];
        System.arraycopy(oldElements, 0, this._elements, 0, this._size);
    }

    public final int getCapacity() {
        return this._elements.length;
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    public final boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public final int indexOf(Object element) {
        if (element == null) {
            for (int i = 0; i < this._size; ++i) {
                if (this._elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._size; ++i) {
                if (!element.equals(this._elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final int lastIndexOf(Object element) {
        if (element == null) {
            for (int i = this._size - 1; i >= 0; --i) {
                if (this._elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this._size - 1; i >= 0; --i) {
                if (!element.equals(this._elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final Object clone() {
        EArrayList copy = new EArrayList(this._size * 110 / 100);
        System.arraycopy(this._elements, 0, copy._elements, 0, this._size);
        copy._size = this._size;
        return copy;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this._size];
        System.arraycopy(this._elements, 0, array, 0, this._size);
        return array;
    }

    public final Object[] toArray(Object[] proto) {
        Object[] array = proto;
        if (proto.length < this._size) {
            array = (Object[])Array.newInstance(proto.getClass().getComponentType(), this._size);
        }
        System.arraycopy(this._elements, 0, array, 0, this._size);
        if (array.length > this._size) {
            array[this._size] = null;
        }
        return array;
    }

    public final Object get(int index) {
        this.checkRange(index);
        return this._elements[index];
    }

    public final Object set(int index, Object element) {
        int n = index - this._size;
        if (n >= 0) {
            for (int i = 0; i <= n; ++i) {
                this.add((Object)null);
            }
        }
        Object oldElement = this._elements[index];
        this._elements[index] = element;
        return oldElement;
    }

    public final boolean add(Object element) {
        this.ensureCapacity(this._size + 1);
        this._elements[this._size++] = element;
        return true;
    }

    public final void add(int index, Object element) {
        this.checkHighRange(index);
        this.ensureCapacity(this._size + 1);
        System.arraycopy(this._elements, index, this._elements, index + 1, this._size - index);
        this._elements[index] = element;
        ++this._size;
    }

    public final boolean addAll(Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        this.ensureCapacity(this._size + numNew);
        System.arraycopy(c.toArray(), 0, this._elements, this._size, numNew);
        this._size += numNew;
        return true;
    }

    public final boolean addAll(int index, Collection c) {
        this.checkHighRange(index);
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        this.ensureCapacity(this._size + numNew);
        int numMoved = this._size - index;
        if (numMoved > 0) {
            System.arraycopy(this._elements, index, this._elements, index + numNew, numMoved);
        }
        System.arraycopy(c.toArray(), 0, this._elements, index, c.size());
        this._size += numNew;
        return true;
    }

    public final void addAll(Object[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array");
        }
        this._size = array.length;
        this._elements = new Object[this._size * 110 / 100];
        System.arraycopy(array, 0, this._elements, 0, this._size);
    }

    public final Object remove(int index) {
        this.checkRange(index);
        Object oldElement = this._elements[index];
        int numMoved = this._size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this._elements, index + 1, this._elements, index, numMoved);
        }
        this._elements[--this._size] = null;
        return oldElement;
    }

    public final boolean removeAll(Collection c) {
        boolean modified = false;
        for (int i = this._size - 1; i >= 0; --i) {
            if (!c.contains(this._elements[i])) continue;
            this.remove(i);
            modified = true;
        }
        return modified;
    }

    public final boolean retainAll(Collection c) {
        boolean modified = false;
        for (int i = this._size - 1; i >= 0; --i) {
            if (c.contains(this._elements[i])) continue;
            this.remove(i);
            modified = true;
        }
        return modified;
    }

    public final void clear() {
        for (int i = 0; i < this._size; ++i) {
            this._elements[i] = null;
        }
        this._size = 0;
    }

    public final Iterator iterator() {
        return new Itr(this);
    }

    public final ListIterator listIterator() {
        return this.listIterator(0);
    }

    public final ListIterator listIterator(int index) {
        this.checkHighRange(index);
        return new ListItr(this, index);
    }

    public final List subList(int fromIndex, int toIndex) {
        this.checkRange(fromIndex, toIndex);
        return new SubList(this, fromIndex, toIndex);
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("[");
        for (int i = 0; i < this._size; ++i) {
            buf.append(String.valueOf(this._elements[i]));
            if (i >= this._size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List) || o == null) {
            return false;
        }
        List l = (List)o;
        if (this._size != l.size()) {
            return false;
        }
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object o1 = i1.next();
            Object o2 = i2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int hashCode = 1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._elements.length);
        out.writeInt(this._size);
        for (int i = 0; i < this._size; ++i) {
            out.writeObject(this._elements[i]);
        }
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int num = in.readInt();
        this._size = in.readInt();
        this._elements = new Object[num];
        for (int i = 0; i < this._size; ++i) {
            this._elements[i] = in.readObject();
        }
    }

    private final void ensureCapacity(int minCapacity) {
        Object[] oldElements = this._elements;
        if (minCapacity > oldElements.length) {
            int newCapacity = minCapacity * 3 / 2 + 1;
            this._elements = new Object[newCapacity];
            System.arraycopy(oldElements, 0, this._elements, 0, this._size);
        }
    }

    private final void checkRange(int index) {
        if (index >= this._size) {
            throw new ArrayIndexOutOfBoundsException("index:" + index);
        }
    }

    private final void checkHighRange(int index) {
        if (index > this._size) {
            throw new ArrayIndexOutOfBoundsException("index:" + index);
        }
    }

    private void checkRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException("fromIndex:" + fromIndex + ",toIndex:" + toIndex);
        }
        this.checkHighRange(toIndex);
    }

    private final class SubList
    extends AbstractList {
        private List _list;
        private int _offset;
        private int _size;

        SubList(List list, int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > list.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this._list = list;
            this._offset = fromIndex;
            this._size = toIndex - fromIndex;
        }

        public final Object set(int index, Object element) {
            return this._list.set(index + this._offset, element);
        }

        public final Object get(int index) {
            return this._list.get(index + this._offset);
        }

        public final int size() {
            return this._size;
        }

        public final void add(int index, Object element) {
            this._list.add(index + this._offset, element);
            ++this._size;
        }

        public final Object remove(int index) {
            --this._size;
            return this._list.remove(index + this._offset);
        }

        public final boolean addAll(Collection c) {
            return this.addAll(this._size, c);
        }

        public final boolean addAll(int index, Collection c) {
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this._list.addAll(this._offset + index, c);
            this._size += cSize;
            return true;
        }

        public final Iterator iterator() {
            return this.listIterator();
        }

        public final ListIterator listIterator(int index) {
            return new ListIterator(this, index){
                private ListIterator _iter;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ SubList this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                    this._iter = SubList.access$100(this.this$1).listIterator(this.val$index + SubList.access$000(this.this$1));
                }

                public boolean hasNext() {
                    return this.nextIndex() < SubList.access$200(this.this$1);
                }

                public Object next() {
                    if (this.hasNext()) {
                        return this._iter.next();
                    }
                    throw new NoSuchElementException();
                }

                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                public Object previous() {
                    if (this.hasPrevious()) {
                        return this._iter.previous();
                    }
                    throw new NoSuchElementException();
                }

                public int nextIndex() {
                    return this._iter.nextIndex() - SubList.access$000(this.this$1);
                }

                public int previousIndex() {
                    return this._iter.previousIndex() - SubList.access$000(this.this$1);
                }

                public void remove() {
                    this._iter.remove();
                    SubList.access$210(this.this$1);
                }

                public void set(Object o) {
                    this._iter.set(o);
                }

                public void add(Object o) {
                    this._iter.add(o);
                    SubList.access$208(this.this$1);
                }
            };
        }

        public final List subList(int fromIndex, int toIndex) {
            return new SubList(this, fromIndex, toIndex);
        }

        static /* synthetic */ int access$000(SubList x0) {
            return x0._offset;
        }

        static /* synthetic */ List access$100(SubList x0) {
            return x0._list;
        }

        static /* synthetic */ int access$200(SubList x0) {
            return x0._size;
        }

        static /* synthetic */ int access$210(SubList x0) {
            return x0._size--;
        }

        static /* synthetic */ int access$208(SubList x0) {
            return x0._size++;
        }
    }

    private final class ListItr
    extends Itr
    implements ListIterator {
        ListItr(List list, int index) {
            super(list);
            this._current = index;
        }

        public final boolean hasPrevious() {
            return this._current != 0;
        }

        public final Object previous() {
            try {
                Object p = this._list.get(--this._current);
                this._last = this._current;
                return p;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public final int nextIndex() {
            return this._current;
        }

        public final int previousIndex() {
            return this._current - 1;
        }

        public final void set(Object element) {
            if (this._last == -1) {
                throw new IllegalStateException();
            }
            this._list.set(this._last, element);
        }

        public final void add(Object element) {
            this._list.add(this._current++, element);
            this._last = -1;
        }
    }

    private class Itr
    implements Iterator {
        protected final List _list;
        protected int _current = 0;
        protected int _last = -1;

        Itr(List list) {
            this._list = list;
        }

        public final boolean hasNext() {
            return this._current != this._list.size();
        }

        public final Object next() {
            try {
                Object n = this._list.get(this._current);
                this._last = this._current++;
                return n;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public final void remove() {
            if (this._last == -1) {
                throw new IllegalStateException();
            }
            this._list.remove(this._last);
            if (this._last < this._current) {
                --this._current;
            }
            this._last = -1;
        }
    }
}

