/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.StringUtil;

public final class Conversion {
    private Conversion() {
    }

    public static BigDecimal toBigDecimal(Object o) {
        return Conversion.toBigDecimal(o, null);
    }

    public static BigDecimal toBigDecimal(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        if (o instanceof String) {
            return new BigDecimal((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new BigDecimal(new SimpleDateFormat(pattern).format(o));
            }
            return new BigDecimal((double)((Date)o).getTime());
        }
        return new BigDecimal(o.toString());
    }

    public static Double toDouble(Object o) {
        return Conversion.toDouble(o, null);
    }

    public static Double toDouble(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Double(new SimpleDateFormat(pattern).format(o));
            }
            return new Double(((Date)o).getTime());
        }
        return new Double(o.toString());
    }

    public static Float toFloat(Object o) {
        return Conversion.toFloat(o, null);
    }

    public static Float toFloat(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return new Float(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return Float.valueOf((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Float(new SimpleDateFormat(pattern).format(o));
            }
            return new Float(((Date)o).getTime());
        }
        return new Float(o.toString());
    }

    public static Long toLong(Object o) {
        return Conversion.toLong(o, null);
    }

    public static Long toLong(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return new Long(((Number)o).longValue());
        }
        if (o instanceof String) {
            return new Long((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Long(new SimpleDateFormat(pattern).format(o));
            }
            return new Long(((Date)o).getTime());
        }
        return new Long(o.toString());
    }

    public static Integer toInteger(Object o) {
        return Conversion.toInteger(o, null);
    }

    public static Integer toInteger(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return new Integer(((Number)o).intValue());
        }
        if (o instanceof String) {
            return new Integer((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Integer(new SimpleDateFormat(pattern).format(o));
            }
            return new Integer((int)((Date)o).getTime());
        }
        return new Integer(o.toString());
    }

    public static Short toShort(Object o) {
        return Conversion.toShort(o, null);
    }

    public static Short toShort(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return new Short(((Number)o).shortValue());
        }
        if (o instanceof String) {
            return Short.valueOf((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Short(new SimpleDateFormat(pattern).format(o));
            }
            return new Short((short)((Date)o).getTime());
        }
        return new Short(o.toString());
    }

    public static Number toNumber(String s) {
        long v2;
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        s = s.trim();
        char[] charArray = s.toCharArray();
        int index = 0;
        boolean neg = false;
        char c = charArray[index];
        if (c == '-') {
            if ((c = charArray[++index]) != '.' && (c < '0' || c > '9')) {
                throw new SeasarRuntimeException("ESSR0346", new Object[]{s});
            }
            neg = true;
        }
        long v = 0L;
        int decexp = 0;
        int seendot = 0;
        while (true) {
            if (c == '.' && seendot == 0) {
                seendot = 1;
            } else {
                if ('0' > c || c > '9') break;
                v = v * 10L + (long)(c - 48);
                decexp += seendot;
            }
            if (index >= charArray.length - 1) break;
            c = charArray[++index];
        }
        long l = v2 = neg ? -v : v;
        if (decexp != 0) {
            return new BigDecimal(BigInteger.valueOf(v2), decexp);
        }
        if (v2 > Integer.MAX_VALUE || v2 < Integer.MIN_VALUE) {
            return new Long(v2);
        }
        int v3 = (int)v;
        v3 = neg ? -v3 : v3;
        return new Integer(v3);
    }

    public static Timestamp toTimestamp(Object o) {
        return Conversion.toTimestamp(o, null);
    }

    public static Timestamp toTimestamp(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            SimpleDateFormat sdf = Conversion.getSimpleDateFormat(pattern);
            return new Timestamp(Conversion.toDate((String)o, pattern).getTime());
        }
        if (o instanceof Date) {
            return new Timestamp(((Date)o).getTime());
        }
        if (o instanceof BigDecimal) {
            return new Timestamp(((BigDecimal)o).longValue());
        }
        if (o instanceof Long) {
            return new Timestamp((Long)o);
        }
        if (o instanceof Integer) {
            return new Timestamp(((Integer)o).longValue());
        }
        SimpleDateFormat sdf = Conversion.getSimpleDateFormat(pattern);
        return new Timestamp(Conversion.toDate(o.toString(), pattern).getTime());
    }

    public static String toString(Object value) {
        return Conversion.toString(value, null);
    }

    public static String toString(Object value, String pattern) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return Conversion.toString((Date)value, pattern);
        }
        if (value instanceof Number) {
            return Conversion.toString((Number)value, pattern);
        }
        return value.toString();
    }

    public static String toString(Number value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new DecimalFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static String toString(Date value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return Conversion.getSimpleDateFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static byte[] toByteArray(Object o) {
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return ((String)o).getBytes();
        }
        throw new SeasarRuntimeException("ESSR0027", new Object[]{o});
    }

    public static boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    private static Date toDate(String s, String pattern) {
        try {
            SimpleDateFormat sdf = Conversion.getSimpleDateFormat(pattern);
            return new Timestamp(sdf.parse(s).getTime());
        }
        catch (ParseException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    private static SimpleDateFormat getSimpleDateFormat(String pattern) {
        SimpleDateFormat sdf = null;
        sdf = pattern != null ? new SimpleDateFormat(pattern) : new SimpleDateFormat();
        sdf.setLenient(false);
        return sdf;
    }
}

