/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.transaction;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    static final long serialVersionUID = 4949943953549496531L;
    private static final int FORMAT_ID = 4360;
    private static final byte[] INITIAL_BRANCH_ID = XidImpl.convert64bytes(new byte[0]);
    private static String _base = System.currentTimeMillis() + "/";
    private static int _nextId = 0;
    private int _hashCode;
    private byte[] _globalId;
    private byte[] _branchId;

    public XidImpl() {
        this._hashCode = XidImpl.getNextId();
        this._globalId = XidImpl.convert64bytes((_base + Integer.toString(this._hashCode)).getBytes());
        this._branchId = INITIAL_BRANCH_ID;
    }

    public XidImpl(Xid xid, int branchId) {
        this._hashCode = xid.hashCode();
        this._globalId = xid.getGlobalTransactionId();
        this._branchId = XidImpl.convert64bytes(Integer.toString(branchId).getBytes());
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this._globalId.clone();
    }

    public byte[] getBranchQualifier() {
        return (byte[])this._branchId.clone();
    }

    public int getFormatId() {
        return 4360;
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl other = (XidImpl)obj;
        if (this._hashCode != other._hashCode) {
            return false;
        }
        if (this._globalId.length != other._globalId.length || this._branchId.length != other._branchId.length) {
            return false;
        }
        for (i = 0; i < this._globalId.length; ++i) {
            if (this._globalId[i] == other._globalId[i]) continue;
            return false;
        }
        for (i = 0; i < this._branchId.length; ++i) {
            if (this._branchId[i] == other._branchId[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return "[FormatId=4360, GlobalId=" + new String(this._globalId).trim() + ", BranchId=" + new String(this._branchId).trim() + "]";
    }

    private static byte[] convert64bytes(byte[] bytes) {
        byte[] new64bytes = new byte[64];
        System.arraycopy(bytes, 0, new64bytes, 0, bytes.length);
        return new64bytes;
    }

    private static synchronized int getNextId() {
        return _nextId++;
    }
}

