/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.transaction;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.seasar.transaction.TransactionManagerImpl;

public final class XAResourceManager {
    private static XAResourceManager _instance = new XAResourceManager();
    private ThreadLocal _threadXAResourceList = new ThreadLocal();

    private XAResourceManager() {
    }

    public static XAResourceManager getInstance() {
        return _instance;
    }

    public void addXAResource(XAResource xaResource) throws SystemException, RollbackException {
        Transaction tx = TransactionManagerImpl.getInstance().getTransaction();
        if (tx != null && tx.getStatus() == 0) {
            tx.enlistResource(xaResource);
            return;
        }
        ArrayList<XAResource> list = this.getXAResourceList();
        if (list == null) {
            list = new ArrayList<XAResource>();
            this._threadXAResourceList.set(list);
        }
        list.add(xaResource);
    }

    public void removeXAResource(XAResource xaResource) {
        List list = this.getXAResourceList();
        if (list == null) {
            return;
        }
        list.remove(xaResource);
    }

    public List getXAResourceList() {
        return (List)this._threadXAResourceList.get();
    }

    public int getXAResourceCount() {
        List list = this.getXAResourceList();
        if (list == null) {
            return 0;
        }
        return list.size();
    }
}

