/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.seasar.log.Logger;
import org.seasar.message.MessageFormatter;
import org.seasar.transaction.TransactionImpl;
import org.seasar.transaction.XidImpl;
import org.seasar.util.SeasarException;

public final class TransactionManagerImpl
implements TransactionManager {
    private static TransactionManagerImpl _instance = new TransactionManagerImpl();
    private ThreadLocal _threadAttachTx = new ThreadLocal();

    private TransactionManagerImpl() {
    }

    public static TransactionManagerImpl getInstance() {
        return _instance;
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionImpl tx = (TransactionImpl)this._threadAttachTx.get();
        if (tx != null && tx.getStatus() != 6) {
            throw new NotSupportedException(MessageFormatter.getMessage("ESSR0316", null));
        }
        tx = this.attachTransaction(tx);
        tx.begin();
    }

    public void begin2() throws SeasarException {
        try {
            this.begin();
        }
        catch (NotSupportedException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
        catch (SystemException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new IllegalStateException(MessageFormatter.getMessage("ESSR0311", null));
        }
        try {
            tx.commit();
        }
        finally {
            this.detachTransaction(tx);
        }
    }

    public void commit2() throws SeasarException {
        try {
            this.commit();
        }
        catch (Exception ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public Transaction suspend() {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new IllegalStateException(MessageFormatter.getMessage("ESSR0311", null));
        }
        this.suspendInternal(tx);
        return tx;
    }

    public void resume(Transaction resumeTx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (resumeTx == null) {
            throw new InvalidTransactionException(MessageFormatter.getMessage("ESSR0007", new Object[]{"Transaction"}));
        }
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            throw new IllegalStateException(MessageFormatter.getMessage("ESSR0317", null));
        }
        this.setCurrent((TransactionImpl)resumeTx);
        ((TransactionImpl)resumeTx).resume();
    }

    public void resume2(Transaction resumeTx) throws SeasarException {
        try {
            this.resume(resumeTx);
        }
        catch (Exception ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx = this.getCurrent();
        if (tx == null) {
            throw new IllegalStateException(MessageFormatter.getMessage("ESSR0311", null));
        }
        try {
            tx.rollback();
        }
        finally {
            this.detachTransaction(tx);
        }
    }

    public void rollback2() {
        try {
            if (this.getStatus() != 6) {
                this.rollback();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).log("ESSR0017", new Object[]{ex}, (Throwable)ex);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException(MessageFormatter.getMessage("ESSR0311", null));
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
    }

    public int getStatus() {
        TransactionImpl tx = this.getCurrent();
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.getCurrent();
    }

    public boolean preRequiredProcess() throws SeasarException {
        boolean began = false;
        int preStatus = this.getStatus();
        if (preStatus == 6) {
            this.begin2();
            began = true;
        }
        return began;
    }

    public void postNormalRequiredProcess(boolean began) throws SeasarException {
        if (began) {
            this.commit2();
        }
    }

    public void postExceptionRequiredProcess(boolean began) {
        if (began) {
            try {
                if (this.getStatus() != 6) {
                    this.rollback();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass()).log("ESSR0017", new Object[]{ex}, (Throwable)ex);
            }
        }
    }

    public TransactionImpl preRequiresNewProcess() throws SeasarException {
        TransactionImpl preTx = this.getCurrent();
        if (preTx != null) {
            this.suspendInternal(preTx);
        }
        this.begin2();
        return preTx;
    }

    public void postNormalRequiresNewProcess() throws SeasarException {
        this.commit2();
    }

    public void postExceptionRequiresNewProcess() {
        this.rollback2();
    }

    public void finalRequiresNewProcess(TransactionImpl preTx) throws SeasarException {
        if (preTx != null) {
            this.resume2(preTx);
        }
    }

    private TransactionImpl getCurrent() {
        TransactionImpl tx = (TransactionImpl)this._threadAttachTx.get();
        if (tx != null && tx.getStatus() == 6) {
            return null;
        }
        return tx;
    }

    private void setCurrent(TransactionImpl current) {
        this._threadAttachTx.set(current);
    }

    private TransactionImpl attachTransaction(TransactionImpl tx) {
        XidImpl xid = new XidImpl();
        if (tx != null) {
            tx.init(xid);
        } else {
            tx = new TransactionImpl(xid);
        }
        this._threadAttachTx.set(tx);
        return tx;
    }

    private void detachTransaction(TransactionImpl tx) {
        if (tx != null) {
            tx.destroy();
        }
    }

    private void suspendInternal(TransactionImpl tx) {
        tx.suspend();
        this.setCurrent(null);
    }
}

