/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.transaction;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.seasar.log.Logger;
import org.seasar.message.MessageFormatter;
import org.seasar.transaction.XAResourceManager;
import org.seasar.transaction.XidImpl;
import org.seasar.util.SeasarRuntimeException;

public final class TransactionImpl
implements Transaction {
    private static final int VOTE_READONLY = 0;
    private static final int VOTE_COMMIT = 1;
    private static final int VOTE_ROLLBACK = 2;
    private static Logger _logger = Logger.getLogger(class$org$seasar$transaction$TransactionImpl == null ? (class$org$seasar$transaction$TransactionImpl = TransactionImpl.class$("org.seasar.transaction.TransactionImpl")) : class$org$seasar$transaction$TransactionImpl);
    private Xid _xid;
    private int _status = 6;
    private List _xaResourceInfoList = new ArrayList();
    private List _synchronizationList = new ArrayList();
    private boolean _suspended = false;
    private int _branchId = 0;
    static /* synthetic */ Class class$org$seasar$transaction$TransactionImpl;

    public TransactionImpl(Xid xid) {
        this.init(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws SystemException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Transaction.begin()");
        }
        this._status = 0;
        List list = XAResourceManager.getInstance().getXAResourceList();
        if (list == null) {
            return;
        }
        try {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    this.enlistResource((XAResource)list.get(i));
                    continue;
                }
                catch (RollbackException ex) {
                    Logger.getLogger(this.getClass()).log(ex);
                }
            }
        }
        finally {
            list.clear();
        }
    }

    public void suspend() {
        this.checkIsNotSuspended();
        this.checkStatus();
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            try {
                xari.end(0x2000000);
                continue;
            }
            catch (XAException ex) {
                Logger.getLogger(this.getClass()).log(ex);
            }
        }
        this._suspended = true;
    }

    public void resume() {
        this.checkIsSuspended();
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            try {
                xari.start(0x8000000);
                continue;
            }
            catch (XAException ex) {
                Logger.getLogger(this.getClass()).log(ex);
            }
        }
        this._suspended = false;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Transaction.commit()");
        }
        this.checkIsNotSuspended();
        this.checkStatus();
        this.beforeCompletion();
        this.endResources(0x4000000);
        if (this._status == 0) {
            if (this._xaResourceInfoList.size() == 0) {
                this._status = 3;
            } else if (this._xaResourceInfoList.size() == 1) {
                this.commitOnePhase();
            } else {
                switch (this.prepareResources()) {
                    case 0: {
                        this._status = 3;
                        break;
                    }
                    case 1: {
                        this.commitTwoPhase();
                        break;
                    }
                    case 2: {
                        this.rollbackForVoteOK();
                        this.afterCompletion();
                        this.clear();
                        throw new RollbackException(MessageFormatter.getMessage("ESSR0303", new Object[]{this.toString()}));
                    }
                }
            }
        }
        this.afterCompletion();
        this.clear();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Transaction.rollback()");
        }
        this.checkIsNotSuspended();
        this.checkStatusForRollback();
        this.beforeCompletion();
        this.endResources(0x20000000);
        this.rollbackResources();
        this.afterCompletion();
        this.clear();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkIsNotSuspended();
        this.checkStatusForSetRollbackOnly();
        this._status = 1;
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        boolean commitTarget;
        if (xaResource == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"xaResource"});
        }
        this.checkIsNotSuspended();
        this.checkStatusForEnlistResource();
        Xid xid = null;
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            if (xaResource.equals(xari._xaResource)) {
                return false;
            }
            if (xaResource.getClass().getName().startsWith("oracle")) continue;
            try {
                if (!xaResource.isSameRM(xari._xaResource)) continue;
                xid = xari._xid;
                break;
            }
            catch (XAException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
        int flag = xid == null ? 0 : 0x200000;
        boolean bl = commitTarget = xid == null;
        if (xid == null) {
            xid = this.createXidBranch();
        }
        try {
            xaResource.start(xid, flag);
            this._xaResourceInfoList.add(new XAResourceInfo(xaResource, xid, commitTarget));
            return true;
        }
        catch (XAException ex) {
            throw SeasarRuntimeException.convertSeasarRuntimeException(ex);
        }
    }

    public boolean delistResource(XAResource xaResource, int flag) throws IllegalStateException, SystemException {
        if (xaResource == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"xaResource"});
        }
        this.checkIsNotSuspended();
        this.checkStatusForDelistResource();
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            if (!xaResource.equals(xari._xaResource)) continue;
            try {
                xari.end(flag);
                return true;
            }
            catch (XAException ex) {
                Logger.getLogger(this.getClass()).log(ex);
                this._status = 1;
                return false;
            }
        }
        throw new SeasarRuntimeException("ESSR0001", new Object[]{xaResource});
    }

    public int getStatus() {
        return this._status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (sync == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"sync"});
        }
        this.checkIsNotSuspended();
        this.checkStatusForRegisterSynchronization();
        this._synchronizationList.add(sync);
    }

    public Xid getXid() {
        return this._xid;
    }

    public boolean isSuspended() {
        return this._suspended;
    }

    public int hashCode() {
        return this._xid.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof TransactionImpl)) {
            return false;
        }
        return this._xid.equals(((TransactionImpl)o)._xid);
    }

    public String toString() {
        return this._xid.toString();
    }

    public void init(Xid xid) {
        this._xid = xid;
        this._xaResourceInfoList.clear();
        this._synchronizationList.clear();
        this._suspended = false;
    }

    public void destroy() {
        this._status = 6;
    }

    private void endResources(int flag) {
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            try {
                xari.end(flag);
                continue;
            }
            catch (XAException ex) {
                Logger.getLogger(class$org$seasar$transaction$TransactionImpl == null ? TransactionImpl.class$("org.seasar.transaction.TransactionImpl") : class$org$seasar$transaction$TransactionImpl).log("ESSR0017", new Object[]{ex}, (Throwable)ex);
                this._status = 1;
            }
        }
    }

    private void beforeCompletion() {
        for (int i = 0; i < this._synchronizationList.size(); ++i) {
            Synchronization sync = (Synchronization)this._synchronizationList.get(i);
            try {
                sync.beforeCompletion();
                continue;
            }
            catch (Throwable t) {
                Logger.getLogger(class$org$seasar$transaction$TransactionImpl == null ? (class$org$seasar$transaction$TransactionImpl = TransactionImpl.class$("org.seasar.transaction.TransactionImpl")) : class$org$seasar$transaction$TransactionImpl).log("ESSR0017", new Object[]{t}, t);
                this._status = 1;
                break;
            }
        }
    }

    private void afterCompletion() {
        for (int i = 0; i < this._synchronizationList.size(); ++i) {
            Synchronization sync = (Synchronization)this._synchronizationList.get(i);
            try {
                sync.afterCompletion(this._status);
                continue;
            }
            catch (Throwable t) {
                Logger.getLogger(class$org$seasar$transaction$TransactionImpl == null ? TransactionImpl.class$("org.seasar.transaction.TransactionImpl") : class$org$seasar$transaction$TransactionImpl).log("ESSR0017", new Object[]{t}, t);
            }
        }
    }

    private void clear() {
        this._synchronizationList.clear();
        this._xaResourceInfoList.clear();
    }

    private int prepareResources() {
        this._status = 7;
        int vote = 0;
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            if (!xari._commitTarget) continue;
            try {
                if (xari.prepare() != 0) continue;
                xari._voteOk = true;
                vote = 1;
                continue;
            }
            catch (XAException ex) {
                this._status = 1;
                return 2;
            }
        }
        if (this._status == 7) {
            this._status = 2;
        }
        return vote;
    }

    private void commitOnePhase() {
        this._status = 8;
        XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(0);
        try {
            xari.commit(true);
        }
        catch (XAException ex) {
            Logger.getLogger(this.getClass()).log(ex);
            this._status = 5;
        }
        if (this._status == 8) {
            this._status = 3;
        }
    }

    private void commitTwoPhase() {
        this._status = 8;
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            if (!xari._commitTarget || !xari._voteOk) continue;
            try {
                xari.commit(false);
                continue;
            }
            catch (XAException ex) {
                Logger.getLogger(this.getClass()).log(ex);
                this._status = 5;
            }
        }
        if (this._status == 8) {
            this._status = 3;
        }
    }

    private void rollbackForVoteOK() {
        this._status = 9;
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            try {
                if (!xari._voteOk) continue;
                xari.rollback();
                continue;
            }
            catch (XAException ex) {
                Logger.getLogger(class$org$seasar$transaction$TransactionImpl == null ? TransactionImpl.class$("org.seasar.transaction.TransactionImpl") : class$org$seasar$transaction$TransactionImpl).log("ESSR0017", new Object[]{ex}, (Throwable)ex);
                this._status = 5;
            }
        }
        if (this._status == 9) {
            this._status = 4;
        }
    }

    private void rollbackResources() {
        this._status = 9;
        for (int i = 0; i < this._xaResourceInfoList.size(); ++i) {
            XAResourceInfo xari = (XAResourceInfo)this._xaResourceInfoList.get(i);
            try {
                if (!xari._commitTarget) continue;
                xari.rollback();
                continue;
            }
            catch (XAException ex) {
                Logger.getLogger(class$org$seasar$transaction$TransactionImpl == null ? TransactionImpl.class$("org.seasar.transaction.TransactionImpl") : class$org$seasar$transaction$TransactionImpl).log("ESSR0017", new Object[]{ex}, (Throwable)ex);
                this._status = 5;
            }
        }
        if (this._status == 9) {
            this._status = 4;
        }
    }

    private Xid createXidBranch() {
        return new XidImpl(this._xid, ++this._branchId);
    }

    private void checkStatus() throws IllegalStateException {
        switch (this._status) {
            case 0: {
                break;
            }
            case 7: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0304", null));
            }
            case 2: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0305", null));
            }
            case 8: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0306", null));
            }
            case 3: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0307", null));
            }
            case 1: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0308", null));
            }
            case 9: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0309", null));
            }
            case 4: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0310", null));
            }
            case 6: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0311", null));
            }
            case 5: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0312", null));
            }
            default: {
                throw new IllegalStateException(MessageFormatter.getMessage("ESSR0313", new Object[]{String.valueOf(this._status)}));
            }
        }
    }

    private void checkStatusForRollback() throws IllegalStateException {
        switch (this._status) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.checkStatus();
            }
        }
    }

    private void checkStatusForEnlistResource() throws IllegalStateException {
        switch (this._status) {
            case 0: 
            case 7: {
                break;
            }
            default: {
                this.checkStatus();
            }
        }
    }

    private void checkStatusForDelistResource() throws IllegalStateException {
        switch (this._status) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.checkStatus();
            }
        }
    }

    private void checkStatusForSetRollbackOnly() throws IllegalStateException {
        switch (this._status) {
            case 0: 
            case 2: 
            case 7: {
                break;
            }
            default: {
                this.checkStatus();
            }
        }
    }

    private void checkStatusForRegisterSynchronization() throws IllegalStateException {
        switch (this._status) {
            case 0: 
            case 7: {
                break;
            }
            default: {
                this.checkStatus();
            }
        }
    }

    private void checkIsNotSuspended() throws IllegalStateException {
        if (this._suspended) {
            throw new IllegalStateException(MessageFormatter.getMessage("ESSR0314", null));
        }
    }

    private void checkIsSuspended() throws IllegalStateException {
        if (!this._suspended) {
            throw new IllegalStateException(MessageFormatter.getMessage("ESSR0315", null));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class XAResourceInfo {
        private final XAResource _xaResource;
        private final Xid _xid;
        private final boolean _commitTarget;
        private boolean _voteOk = false;

        XAResourceInfo(XAResource xaResource, Xid xid, boolean commitTarget) {
            this._xaResource = xaResource;
            this._xid = xid;
            this._commitTarget = commitTarget;
        }

        void start(int flag) throws XAException {
            this._xaResource.start(this._xid, flag);
        }

        void end(int flag) throws XAException {
            this._xaResource.end(this._xid, flag);
        }

        int prepare() throws XAException {
            return this._xaResource.prepare(this._xid);
        }

        void commit(boolean onePhase) throws XAException {
            this._xaResource.commit(this._xid, onePhase);
        }

        void rollback() throws XAException {
            this._xaResource.rollback(this._xid);
        }

        void forget() throws XAException {
            this._xaResource.forget(this._xid);
        }
    }
}

