/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.transaction;

import java.lang.reflect.Method;
import java.util.Map;
import org.seasar.transaction.TransactionImpl;
import org.seasar.transaction.TransactionManagerImpl;
import org.seasar.util.Assertion;
import org.seasar.util.Reflector;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public abstract class TransAttribute {
    public static final String SUPPORTS_NAME = "Supports";
    public static final String REQUIRED_NAME = "Required";
    public static final String REQUIRES_NEW_NAME = "RequiresNew";
    public static final String MANDATORY_NAME = "Mandatory";
    public static final TransAttribute SUPPORTS = new Supports();
    public static final TransAttribute REQUIRED = new Required();
    public static final TransAttribute REQUIRES_NEW = new RequiresNew();
    public static final TransAttribute MANDATORY = new Mandatory();
    private static Map _transAttributes = new SMap();
    private String _name;

    protected TransAttribute(String name) {
        this._name = name;
    }

    public static TransAttribute getInstance(String name) {
        TransAttribute type = (TransAttribute)_transAttributes.get(name);
        Assertion.assertFound("name", type);
        return type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isInstance(o)) {
            return false;
        }
        return this._name.equals(((TransAttribute)o)._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public abstract Object invoke(Method var1, Object var2, Object[] var3) throws SeasarException;

    static {
        _transAttributes.put(null, SUPPORTS);
        _transAttributes.put(SUPPORTS_NAME, SUPPORTS);
        _transAttributes.put(REQUIRED_NAME, REQUIRED);
        _transAttributes.put(REQUIRES_NEW_NAME, REQUIRES_NEW);
        _transAttributes.put(MANDATORY_NAME, MANDATORY);
    }

    private static final class Mandatory
    extends TransAttribute {
        protected Mandatory() {
            super(TransAttribute.MANDATORY_NAME);
        }

        public final Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            TransactionManagerImpl tm = TransactionManagerImpl.getInstance();
            if (tm.getStatus() == 6) {
                throw new SeasarException("ESSR0311");
            }
            return Reflector.invoke(method, target, args);
        }
    }

    private static final class RequiresNew
    extends TransAttribute {
        protected RequiresNew() {
            super(TransAttribute.REQUIRES_NEW_NAME);
        }

        public final Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            TransactionManagerImpl tm = TransactionManagerImpl.getInstance();
            TransactionImpl preTx = tm.preRequiresNewProcess();
            try {
                Object ret = Reflector.invoke(method, target, args);
                tm.postNormalRequiresNewProcess();
                Object object = ret;
                return object;
            }
            catch (Throwable t) {
                tm.postExceptionRequiresNewProcess();
                throw SeasarException.convertSeasarException(t);
            }
            finally {
                tm.finalRequiresNewProcess(preTx);
            }
        }
    }

    private static final class Required
    extends TransAttribute {
        protected Required() {
            super(TransAttribute.REQUIRED_NAME);
        }

        public final Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            TransactionManagerImpl tm = TransactionManagerImpl.getInstance();
            boolean began = tm.preRequiredProcess();
            try {
                Object ret = Reflector.invoke(method, target, args);
                tm.postNormalRequiredProcess(began);
                return ret;
            }
            catch (Throwable t) {
                tm.postExceptionRequiredProcess(began);
                throw SeasarException.convertSeasarException(t);
            }
        }
    }

    private static final class Supports
    extends TransAttribute {
        protected Supports() {
            super(TransAttribute.SUPPORTS_NAME);
        }

        public final Object invoke(Method method, Object target, Object[] args) throws SeasarException {
            return Reflector.invoke(method, target, args);
        }
    }
}

