/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.transaction;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.seasar.message.MessageFormatter;

public abstract class AbstractXAResource
implements XAResource {
    public static final int RS_NONE = 0;
    public static final int RS_ACTIVE = 1;
    public static final int RS_SUSPENDED = 2;
    public static final int RS_FAIL = 3;
    public static final int RS_SUCCESS = 4;
    public static final int RS_PREPARED = 5;
    private Xid _currentXid;
    private int _status = 0;
    private int _timeout = 0;

    public void start(Xid xid, int flags) throws XAException {
        switch (flags) {
            case 0: {
                this.checkNullCurrentXid();
                this.doBegin(xid);
                this._currentXid = xid;
                this._status = 1;
                break;
            }
            case 0x8000000: {
                this.checkSameCurrentXid(xid);
                this.checkStatusForResume();
                this.doResume(xid);
                this._status = 1;
                break;
            }
            case 0x200000: {
                throw new XAException(MessageFormatter.getMessage("ESSR0317", null));
            }
            default: {
                throw new XAException(MessageFormatter.getMessage("ESSR0022", new Object[]{String.valueOf(flags)}));
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.checkStatusIsActive();
        this.checkSameCurrentXid(xid);
        switch (flags) {
            case 0x2000000: {
                this.doSuspend(xid);
                this._status = 2;
                break;
            }
            case 0x20000000: {
                this.doFail(xid);
                this._status = 3;
                break;
            }
            case 0x4000000: {
                this.doSuccess(xid);
                this._status = 4;
                break;
            }
            default: {
                throw new XAException(MessageFormatter.getMessage("ESSR0022", new Object[]{String.valueOf(flags)}));
            }
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (onePhase) {
            this.checkStatusIsSuccess();
        } else {
            this.checkStatusForTwoPhaseCommit();
        }
        this.checkSameCurrentXid(xid);
        this.doCommit(xid, onePhase);
        this.init();
    }

    public void forget(Xid xid) throws XAException {
        this.checkSameCurrentXid(xid);
        this.doForget(xid);
        this.init();
    }

    public int prepare(Xid xid) throws XAException {
        this.checkStatusIsSuccess();
        this.checkSameCurrentXid(xid);
        int ret = this.doPrepare(xid);
        this._status = ret == 0 ? 5 : 0;
        return ret;
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        this.checkStatusForRollback();
        this.checkSameCurrentXid(xid);
        this.doRollback(xid);
        this.init();
    }

    public boolean isSameRM(XAResource xar) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return this._timeout;
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this._timeout = timeout;
        return true;
    }

    public Xid getCurrentXid() {
        return this._currentXid;
    }

    public int getStatus() {
        return this._status;
    }

    protected abstract void doBegin(Xid var1) throws XAException;

    protected abstract void doResume(Xid var1) throws XAException;

    protected abstract void doSuspend(Xid var1) throws XAException;

    protected abstract void doFail(Xid var1) throws XAException;

    protected abstract void doSuccess(Xid var1) throws XAException;

    protected abstract void doCommit(Xid var1, boolean var2) throws XAException;

    protected abstract void doForget(Xid var1) throws XAException;

    protected abstract int doPrepare(Xid var1) throws XAException;

    protected abstract void doRollback(Xid var1) throws XAException;

    private void init() {
        this._currentXid = null;
        this._status = 0;
    }

    private void checkNullCurrentXid() throws XAException {
        if (this._currentXid != null) {
            throw new XAException(MessageFormatter.getMessage("ESSR0316", null));
        }
    }

    private void checkSameCurrentXid(Xid xid) throws XAException {
        if (this._currentXid != xid) {
            throw new XAException(MessageFormatter.getMessage("ESSR0319", new Object[]{xid, this._currentXid}));
        }
    }

    private void checkStatusIsSuccess() throws XAException {
        switch (this._status) {
            case 4: {
                break;
            }
            default: {
                throw new XAException(MessageFormatter.getMessage("ESSR0320", null));
            }
        }
    }

    private void checkStatusForTwoPhaseCommit() throws XAException {
        switch (this._status) {
            case 5: {
                break;
            }
            default: {
                throw new XAException(MessageFormatter.getMessage("ESSR0321", null));
            }
        }
    }

    private void checkStatusForRollback() throws XAException {
        switch (this._status) {
            case 3: 
            case 5: {
                break;
            }
            default: {
                throw new XAException(MessageFormatter.getMessage("ESSR0322", null));
            }
        }
    }

    private void checkStatusForResume() throws XAException {
        switch (this._status) {
            case 2: {
                break;
            }
            default: {
                throw new XAException(MessageFormatter.getMessage("ESSR0323", null));
            }
        }
    }

    private void checkStatusIsActive() throws XAException {
        switch (this._status) {
            case 1: {
                break;
            }
            default: {
                throw new XAException(MessageFormatter.getMessage("ESSR0324", null));
            }
        }
    }
}

