/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.timer;

import org.seasar.timer.TimeoutTarget;
import org.seasar.util.SeasarRuntimeException;

public class TimeoutTask {
    private static final int ACTIVE = 0;
    private static final int STOPPED = 1;
    private static final int CANCELED = 2;
    private final TimeoutTarget _timeoutTarget;
    private final long _timeoutMillis;
    private final boolean _permanent;
    private long _startTime;
    private int _status = 0;

    TimeoutTask(TimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        this._timeoutTarget = timeoutTarget;
        this._timeoutMillis = timeout * 1000;
        this._permanent = permanent;
        this._startTime = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this._startTime + this._timeoutMillis;
    }

    public boolean isPermanent() {
        return this._permanent;
    }

    public boolean isCanceled() {
        return this._status == 2;
    }

    public void cancel() {
        this._status = 2;
    }

    public boolean isStopped() {
        return this._status == 1;
    }

    public void stop() {
        if (this._status != 0) {
            throw new SeasarRuntimeException("ECHR0024");
        }
        this._status = 1;
    }

    public void restart() {
        this._status = 0;
        this._startTime = System.currentTimeMillis();
    }

    void expired() {
        this._timeoutTarget.expired();
    }
}

