/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.timer;

import org.seasar.timer.TimeoutTarget;
import org.seasar.timer.TimeoutTask;
import org.seasar.util.ELinkedList;
import org.seasar.util.SeasarRuntimeException;

public class TimeoutManager
implements Runnable {
    private static TimeoutManager _instance = new TimeoutManager();
    private Thread _thread;
    private ELinkedList _timeoutTaskList = new ELinkedList();

    private TimeoutManager() {
        this.start();
    }

    public static TimeoutManager getInstance() {
        return _instance;
    }

    public void start() {
        if (this._thread != null) {
            throw new SeasarRuntimeException("ECHR0018", new Object[]{"_thread"});
        }
        this._thread = new Thread(this);
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public void stop() {
        this._thread.interrupt();
        this._thread = null;
    }

    public synchronized void clear() {
        this._timeoutTaskList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    ELinkedList eLinkedList = this._timeoutTaskList;
                    synchronized (eLinkedList) {
                        while (this._timeoutTaskList.isEmpty()) {
                            this._timeoutTaskList.wait();
                        }
                        for (ELinkedList.Entry e = this._timeoutTaskList.getFirstEntry(); e != null; e = e.getNext()) {
                            TimeoutTask task = (TimeoutTask)e.getElement();
                            if (task.isCanceled()) {
                                e.remove();
                                continue;
                            }
                            if (task.isStopped() || !task.isExpired()) continue;
                            task.expired();
                            if (task.isPermanent()) {
                                task.restart();
                                continue;
                            }
                            e.remove();
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutTask addTimeoutTarget(TimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        TimeoutTask task = new TimeoutTask(timeoutTarget, timeout, permanent);
        ELinkedList eLinkedList = this._timeoutTaskList;
        synchronized (eLinkedList) {
            this._timeoutTaskList.addLast(task);
            this._timeoutTaskList.notifyAll();
        }
        return task;
    }

    public int getTimeoutTaskCount() {
        return this._timeoutTaskList.size();
    }
}

