/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import org.seasar.log.Logger;
import org.seasar.timer.TimeoutManager;
import org.seasar.timer.TimeoutTarget;
import org.seasar.timer.TimeoutTask;
import org.seasar.util.ELinkedList;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public class ThreadPool {
    private static Logger _logger = Logger.getLogger(class$org$seasar$system$ThreadPool == null ? (class$org$seasar$system$ThreadPool = ThreadPool.class$("org.seasar.system.ThreadPool")) : class$org$seasar$system$ThreadPool);
    private ELinkedList _idlePool = new ELinkedList();
    private int _activeSize = 0;
    private int _maxSize = 50;
    private int _minSize = 5;
    private int _shrinkSize = 10;
    private int _shrinkInterval = 600;
    private Shrinker _shrinker;
    static /* synthetic */ Class class$org$seasar$system$ThreadPool;

    public ThreadPool() {
    }

    public ThreadPool(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public void start() throws SeasarException {
        this._activeSize = 0;
        for (int i = 0; i < this._minSize; ++i) {
            this._idlePool.addLast(new Worker());
        }
        this._shrinker = new Shrinker();
    }

    public synchronized void stop() {
        if (this._shrinker != null) {
            this._shrinker.cancel();
            this._shrinker = null;
        }
        long tenSec = 10000L;
        while (this._activeSize > 0) {
            int activeSizeBeforeWait = this._activeSize;
            try {
                this.wait(10000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (activeSizeBeforeWait != this._activeSize) continue;
            --this._activeSize;
        }
        while (this._idlePool.size() > 0) {
            Worker worker = (Worker)this._idlePool.removeFirst();
            worker.die();
        }
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 1) {
            throw new SeasarRuntimeException("ESSR0027", new Object[]{String.valueOf(maxSize)});
        }
        this._maxSize = maxSize;
        if (this._minSize > maxSize) {
            this._minSize = maxSize;
        }
        if (this._shrinkSize > maxSize) {
            this._shrinkSize = maxSize;
        }
    }

    public int getMinSize() {
        return this._minSize;
    }

    public void setMinSize(int minSize) {
        if (minSize < 0) {
            throw new SeasarRuntimeException("ESSR0027", new Object[]{String.valueOf(minSize)});
        }
        this._minSize = minSize;
        if (this._maxSize < minSize) {
            this._maxSize = minSize;
        }
        if (this._shrinkSize < minSize) {
            this._shrinkSize = minSize;
        }
    }

    public int getShrinkSize() {
        return this._shrinkSize;
    }

    public void setShrinkSize(int shrinkSize) {
        if (shrinkSize < 0 || shrinkSize < this._minSize || this._maxSize < shrinkSize) {
            throw new SeasarRuntimeException("ESSR0027", new Object[]{String.valueOf(shrinkSize)});
        }
        this._shrinkSize = shrinkSize;
    }

    public int getShrinkInterval() {
        return this._shrinkInterval;
    }

    public void setShrinkInterval(int shrinkInterval) {
        this._shrinkInterval = shrinkInterval;
    }

    public int getActiveSize() {
        return this._activeSize;
    }

    public int getIdleSize() {
        return this._idlePool.size();
    }

    public void request(Runnable work) {
        Worker worker = this.requestWorker();
        worker.request(work);
    }

    public synchronized Worker requestWorker() {
        while (this._activeSize >= this._maxSize) {
            try {
                this.wait();
            }
            catch (InterruptedException ignore) {}
        }
        Worker worker = null;
        worker = this._idlePool.size() == 0 ? new Worker() : (Worker)this._idlePool.removeLast();
        ++this._activeSize;
        return worker;
    }

    private synchronized void returnWorker(Worker worker) {
        --this._activeSize;
        this._idlePool.addLast(worker);
        this.notify();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Shrinker
    implements TimeoutTarget {
        private TimeoutTask _timeoutTask;

        Shrinker() {
            this._timeoutTask = TimeoutManager.getInstance().addTimeoutTarget(this, ThreadPool.this._shrinkInterval, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expired() {
            ELinkedList eLinkedList = ThreadPool.this._idlePool;
            synchronized (eLinkedList) {
                while (ThreadPool.this._idlePool.size() > ThreadPool.this._shrinkSize) {
                    Worker worker = (Worker)ThreadPool.this._idlePool.removeFirst();
                    worker.die();
                }
            }
        }

        void cancel() {
            this._timeoutTask.cancel();
            this._timeoutTask = null;
        }
    }

    public final class Worker
    implements Runnable {
        private Thread _thread = new Thread(this);
        private boolean _running = true;
        private boolean _synchronizing = false;
        private Runnable _work;

        Worker() {
            this._thread.setDaemon(true);
            this._thread.start();
        }

        public synchronized void die() {
            this._running = false;
            this.notify();
        }

        public synchronized void request(Runnable work) {
            if (this._work != null) {
                throw new IllegalStateException("Worker already has work");
            }
            this._work = work;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void synchronize() {
            if (this._work == null) {
                return;
            }
            try {
                Runnable runnable = this._work;
                synchronized (runnable) {
                    this._synchronizing = true;
                    try {
                        this._work.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this._running) {
                Worker worker = this;
                synchronized (worker) {
                    if (this._work != null) {
                        Object var5_5;
                        try {
                            this._work.run();
                        }
                        catch (Throwable t) {
                            _logger.error(t);
                        }
                        try {
                            if (this._synchronizing) {
                                Runnable t = this._work;
                                synchronized (t) {
                                    this._synchronizing = false;
                                    this._work.notify();
                                }
                            }
                            var5_5 = null;
                            this._work = null;
                        }
                        catch (Throwable throwable) {
                            var5_5 = null;
                            this._work = null;
                            ThreadPool.this.returnWorker(this);
                            throw throwable;
                        }
                        ThreadPool.this.returnWorker(this);
                        {
                        }
                    }
                    while (this._running && this._work == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }
}

