/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.seasar.log.Logger;
import org.seasar.system.JMXService;
import org.seasar.system.Lifecycle;
import org.seasar.system.MBeanProxy;
import org.seasar.system.RMIAdaptorService;
import org.seasar.system.SeasarMBean;
import org.seasar.util.ElementHandler;
import org.seasar.util.Reflector;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;
import org.seasar.util.ThreadUtil;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class Seasar
implements SeasarMBean {
    private static final String XML_FILE_NAME = "/seasar-config.xml";
    private static Seasar _instance = new Seasar();
    private static Logger _logger = Logger.getLogger(class$org$seasar$system$Seasar == null ? (class$org$seasar$system$Seasar = Seasar.class$("org.seasar.system.Seasar")) : class$org$seasar$system$Seasar);
    private static List _services;
    private static XMLHandlerRule _xmlHandlerRule;
    private boolean _started = false;
    private Thread _shutdownThread;
    private boolean _needExit = false;
    static /* synthetic */ Class class$org$seasar$system$Seasar;
    static /* synthetic */ Class class$org$seasar$system$SeasarMBean;

    private Seasar() {
    }

    public static void configure() {
        if (ResourceUtil.isExist(XML_FILE_NAME)) {
            Seasar.setupXMLHandlerRule();
            XMLHandlerParser.parse(XML_FILE_NAME, _xmlHandlerRule);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Seasar.usage();
            System.exit(1);
        } else if (args[0].equals("-start")) {
            Seasar.startForMain();
        } else if (args[0].equals("-shutdown")) {
            Seasar.shutdownForMain();
        } else if (args[0].equals("-restart")) {
            if (args.length == 1) {
                Seasar.restartForMain();
            } else {
                Seasar.restartServiceForMain(args[1]);
            }
        } else {
            Seasar.usage();
            System.exit(1);
        }
    }

    public static Seasar getInstance() {
        return _instance;
    }

    public static String getHome() {
        return System.getProperty("seasar.home", "..");
    }

    public synchronized void start() throws SeasarException {
        this.startServices();
        JMXService.registerMBean(this, SeasarMBean.NAME);
        this.addShutdownHook();
        this._started = true;
        _logger.log("ISSR0001", null);
    }

    public synchronized void stop() {
        this.stopServices();
        this._started = false;
        _logger.log("ISSR0002", null);
        if (this._shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this._shutdownThread);
            this._shutdownThread = null;
        }
        System.runFinalization();
        System.gc();
    }

    public boolean isStarted() {
        return this._started;
    }

    public void shutdown() {
        Runtime.getRuntime().removeShutdownHook(this._shutdownThread);
        this._needExit = true;
        this._shutdownThread.start();
    }

    public void restartService(String className) {
        for (int i = 0; i < _services.size(); ++i) {
            Lifecycle service = (Lifecycle)_services.get(i);
            if (!service.getClass().getName().equals(className)) continue;
            try {
                service.stop();
                service.start();
                Logger.getLogger(this.getClass()).log("ISSR0005", new Object[]{className});
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).log(t);
                _services.remove(i);
            }
            break;
        }
    }

    private static boolean isRunning() {
        Socket s = null;
        try {
            s = new Socket("localhost", RMIAdaptorService.getInstance().getPort());
            s.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void usage() {
        _logger.error("Usage:java org.seasar.system.Seasar -start|-shutdown|-restart serviceClassName");
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("/seasar/services", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                _services = new ArrayList();
            }
        });
        _xmlHandlerRule.addElementHandler("/seasar/services/service", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String className = attributes.getValue("className");
                Lifecycle service = (Lifecycle)Reflector.newInstance(className);
                _services.add(service);
                xmlHandler.push(service);
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        _xmlHandlerRule.addElementHandler("/seasar/services/service/properties/property", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                Object service = xmlHandler.peek();
                Reflector.setProperty(service, name, value);
            }
        });
    }

    private void startServices() throws SeasarException {
        for (int i = 0; i < _services.size(); ++i) {
            try {
                ((Lifecycle)_services.get(i)).start();
                continue;
            }
            catch (Exception ex) {
                for (int j = i - 1; j >= 0; --j) {
                    try {
                        ((Lifecycle)_services.get(j)).stop();
                        continue;
                    }
                    catch (Exception ex2) {
                        _logger.log(ex2);
                    }
                }
                _services.clear();
                throw SeasarException.convertSeasarException(ex);
            }
        }
    }

    private void stopServices() {
        for (int i = _services.size() - 1; i >= 0; --i) {
            try {
                ((Lifecycle)_services.get(i)).stop();
                continue;
            }
            catch (Throwable t) {
                _logger.log(t);
            }
        }
    }

    private void addShutdownHook() throws SeasarException {
        this._shutdownThread = new Thread(){

            public void run() {
                if (Seasar.this._shutdownThread == null) {
                    return;
                }
                Seasar.this._shutdownThread = null;
                Seasar.this.stop();
                _logger.log("ISSR0003", null);
                if (Seasar.this._needExit) {
                    System.exit(0);
                }
            }
        };
        this._shutdownThread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(this._shutdownThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startForMain() {
        try {
            if (Seasar.isRunning()) {
                _logger.log("ESSR0301", null);
                System.exit(1);
            }
            _instance.start();
            Seasar seasar = _instance;
            synchronized (seasar) {
                _instance.wait();
            }
        }
        catch (Throwable t) {
            _logger.log(t);
            System.exit(1);
        }
    }

    private static void shutdownForMain() {
        try {
            if (!Seasar.isRunning()) {
                _logger.log("ESSR0302", null);
                System.exit(1);
            }
            SeasarMBean seasar = (SeasarMBean)MBeanProxy.create(class$org$seasar$system$SeasarMBean == null ? (class$org$seasar$system$SeasarMBean = Seasar.class$("org.seasar.system.SeasarMBean")) : class$org$seasar$system$SeasarMBean, SeasarMBean.NAME, "localhost", RMIAdaptorService.getInstance().getPort());
            seasar.shutdown();
            System.exit(0);
        }
        catch (Throwable t) {
            _logger.log(t);
            System.exit(1);
        }
    }

    private static void restartForMain() {
        try {
            if (Seasar.isRunning()) {
                SeasarMBean seasar = (SeasarMBean)MBeanProxy.create(class$org$seasar$system$SeasarMBean == null ? (class$org$seasar$system$SeasarMBean = Seasar.class$("org.seasar.system.SeasarMBean")) : class$org$seasar$system$SeasarMBean, SeasarMBean.NAME, "localhost", RMIAdaptorService.getInstance().getPort());
                seasar.shutdown();
            }
            while (Seasar.isRunning()) {
                ThreadUtil.sleep(100L);
            }
            Seasar.startForMain();
        }
        catch (Throwable t) {
            _logger.log(t);
            System.exit(1);
        }
    }

    private static void restartServiceForMain(String className) {
        try {
            if (!Seasar.isRunning()) {
                _logger.log("ESSR0302", null);
                System.exit(1);
            }
            SeasarMBean seasar = (SeasarMBean)MBeanProxy.create(class$org$seasar$system$SeasarMBean == null ? (class$org$seasar$system$SeasarMBean = Seasar.class$("org.seasar.system.SeasarMBean")) : class$org$seasar$system$SeasarMBean, SeasarMBean.NAME, "localhost", RMIAdaptorService.getInstance().getPort());
            seasar.restartService(className);
            System.exit(0);
        }
        catch (Throwable t) {
            _logger.log(t);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _xmlHandlerRule = new XMLHandlerRule();
        Seasar.configure();
    }
}

