/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.rmi.RemoteException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.seasar.log.Logger;
import org.seasar.system.JMXService;
import org.seasar.system.RMINotificationListener;
import org.seasar.system.RMINotificationListenerServerAdaptorMBean;
import org.seasar.util.LongId;
import org.seasar.util.SeasarException;

public final class RMINotificationListenerServerAdaptor
implements NotificationListener,
RMINotificationListenerServerAdaptorMBean {
    private static LongId _id = new LongId();
    private RMINotificationListener _rmiNotificationListener;
    private String _targetName;
    private String _listenerName;

    public RMINotificationListenerServerAdaptor(String targetName, RMINotificationListener rmiNotificationListener) {
        this._targetName = targetName;
        this._rmiNotificationListener = rmiNotificationListener;
        this._listenerName = "RMINotificationListenerServerAdaptor:id=" + _id.next();
    }

    public String getListenerName() {
        return this._listenerName;
    }

    public void addNotificationListener() throws SeasarException {
        JMXService.registerMBean(this, this._listenerName);
        JMXService.addNotificationListener(this._targetName, this._listenerName);
    }

    public void removeNotificationListener() throws SeasarException {
        JMXService.removeNotificationListener(this._targetName, this._listenerName);
        JMXService.unregisterMBean(this._listenerName);
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            this._rmiNotificationListener.handleRMINotification(notification, handback);
        }
        catch (RemoteException ex) {
            try {
                this.removeNotificationListener();
            }
            catch (SeasarException se) {
                Logger.getLogger(this.getClass()).log(se);
            }
            Logger.getLogger(this.getClass()).log(ex);
        }
    }
}

