/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.seasar.system.RMIAdaptor;
import org.seasar.system.RMIConnector;
import org.seasar.system.RMINotificationListener;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;
import org.seasar.util.SeasarRuntimeException;

public class RMINotificationListenerAdaptor
implements RMINotificationListener {
    private String _targetName;
    private NotificationListener _notificationListener;
    private SeasarContext _seasarContext;
    private RMINotificationListener _rmiNotificationListenerStub;
    private RMIAdaptor _rmiAdaptor;
    private String _listenerName;

    public RMINotificationListenerAdaptor(String targetName, NotificationListener notificationListener, SeasarContext seasarContext) {
        if (targetName == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"targetName"});
        }
        this._targetName = targetName;
        if (notificationListener == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"notificationListener"});
        }
        this._notificationListener = notificationListener;
        if (seasarContext == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"seasarContext"});
        }
        this._seasarContext = seasarContext;
    }

    public void addNotificationListener() throws SeasarException {
        try {
            this._rmiNotificationListenerStub = (RMINotificationListener)((Object)UnicastRemoteObject.exportObject(this));
            this._rmiAdaptor = RMIConnector.getRMIAdaptor(this._seasarContext);
            this._listenerName = this._rmiAdaptor.addNotificationListener(this._targetName, this._rmiNotificationListenerStub);
        }
        catch (RemoteException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public void removeNotificationListener() throws SeasarException {
        try {
            this._rmiAdaptor.removeNotificationListener(this._listenerName);
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (RemoteException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
    }

    public void handleRMINotification(Notification notification, Object handback) {
        this._notificationListener.handleNotification(notification, handback);
    }

    public String getListenerName() {
        return this._listenerName;
    }
}

