/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Map;
import org.seasar.system.RMIAdaptor;
import org.seasar.system.RMIAdaptorService;
import org.seasar.util.EMap;
import org.seasar.util.SeasarContext;
import org.seasar.util.SeasarException;

public final class RMIConnector {
    private static final int DUMMY = 0;
    private static Map _rmiAdaptors = new EMap();

    private RMIConnector() {
    }

    public static RMIAdaptor getRMIAdaptor(SeasarContext seasarContext) throws SeasarException {
        return RMIConnector.getRMIAdaptor(seasarContext.getHostName(), seasarContext.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RMIAdaptor getRMIAdaptor(String hostName, int port) throws SeasarException {
        if (port == 0) {
            return RMIConnector.getRMIAdaptorBySocket("localhost", RMIAdaptorService.getInstance().getPort());
        }
        String address = hostName + ":" + port;
        RMIAdaptor rmiAdaptor = (RMIAdaptor)_rmiAdaptors.get(address);
        if (rmiAdaptor != null) {
            return rmiAdaptor;
        }
        Map map = _rmiAdaptors;
        synchronized (map) {
            rmiAdaptor = (RMIAdaptor)_rmiAdaptors.get(address);
            if (rmiAdaptor == null) {
                rmiAdaptor = RMIConnector.getRMIAdaptorBySocket(hostName, port);
                _rmiAdaptors.put(address, rmiAdaptor);
            }
        }
        return rmiAdaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RMIAdaptor regetRMIAdaptor(String hostName, int port) throws SeasarException {
        if (port == 0) {
            return RMIConnector.getRMIAdaptorBySocket("localhost", RMIAdaptorService.getInstance().getPort());
        }
        String address = hostName + ":" + port;
        RMIAdaptor rmiAdaptor = null;
        Map map = _rmiAdaptors;
        synchronized (map) {
            rmiAdaptor = RMIConnector.getRMIAdaptorBySocket(hostName, port);
            _rmiAdaptors.put(address, rmiAdaptor);
        }
        return rmiAdaptor;
    }

    static void setRMIAdaptor(String hostName, int port, RMIAdaptor rmiAdaptor) {
        String address = hostName + ":" + port;
        _rmiAdaptors.put(address, rmiAdaptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RMIAdaptor getRMIAdaptorBySocket(String hostName, int port) throws SeasarException {
        RMIAdaptor rMIAdaptor;
        block7: {
            Socket socket = new Socket(hostName, port);
            try {
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                out.writeInt(0);
                out.flush();
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                rMIAdaptor = (RMIAdaptor)in.readObject();
                if (socket == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new SeasarException("ESSR0040", new Object[]{ex}, (Throwable)ex);
                }
                catch (Exception ex) {
                    throw SeasarException.convertSeasarException(ex);
                }
            }
            socket.close();
        }
        return rMIAdaptor;
    }
}

