/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.seasar.system.AbstractSocketService;
import org.seasar.system.RMIAdaptor;
import org.seasar.system.RMIAdaptorImpl;
import org.seasar.system.RMIConnector;
import org.seasar.util.NetUtil;
import org.seasar.util.SeasarException;

public final class RMIAdaptorService
extends AbstractSocketService {
    private static RMIAdaptorService _instance;
    private RMIAdaptor _rmiAdaptor;
    private RMIAdaptor _rmiAdaptorStub;

    public RMIAdaptorService() {
        _instance = this;
    }

    public static RMIAdaptorService getInstance() {
        return _instance;
    }

    public static RMIAdaptor getRMIAdaptor() {
        return RMIAdaptorService._instance._rmiAdaptor;
    }

    public static RMIAdaptor getRMIAdaptorStub() {
        return RMIAdaptorService._instance._rmiAdaptorStub;
    }

    public final void start() throws SeasarException {
        try {
            this._rmiAdaptor = new RMIAdaptorImpl();
            this._rmiAdaptorStub = (RMIAdaptor)((Object)UnicastRemoteObject.exportObject(this._rmiAdaptor));
        }
        catch (RemoteException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
        super.start();
        String[] hostNames = NetUtil.getAllHostName();
        for (int i = 0; i < hostNames.length; ++i) {
            RMIConnector.setRMIAdaptor(hostNames[i], this.getPort(), this._rmiAdaptor);
        }
    }

    public final void stop() throws SeasarException {
        super.stop();
        try {
            UnicastRemoteObject.unexportObject(this._rmiAdaptor, true);
        }
        catch (RemoteException ex) {
            throw SeasarException.convertSeasarException(ex);
        }
        finally {
            this._rmiAdaptor = null;
            this._rmiAdaptorStub = null;
        }
    }

    protected final void handleSocket(Socket socket) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        in.readInt();
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        out.writeObject(this._rmiAdaptorStub);
        out.flush();
    }
}

